/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class PollutedWater
extends LiquidBlock {
    public PollutedWater() {
        super(() -> (net.minecraft.world.level.material.FlowingFluid)AdPother.getInstance().fluids.pollutedWaterStill.get(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_280170_().m_60910_().m_60978_(100.0f).m_278166_(PushReaction.DESTROY).m_222994_().m_278788_().m_60918_(SoundType.f_279557_));
    }

    public static boolean isPollutedWith(Pollutant<?> pollutant, BlockGetter world, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        return block instanceof PollutedWater && ((PollutedWater)block).isPollutedWith(pollutant, state);
    }

    public static boolean isSource(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() instanceof PollutedWater && state.m_60819_().m_76170_();
    }

    public static Optional<Pollutant<?>> findPollutant(BlockGetter world, BlockPos pos, Collection<Pollutant<?>> pollutants) {
        BlockState state = world.m_8055_(pos);
        for (Pollutant<?> pollutant : pollutants) {
            if (!PollutedWater.isPollutedWith(pollutant, world, pos, state)) continue;
            return Optional.of(pollutant);
        }
        return Optional.empty();
    }

    public boolean isPollutedWith(Pollutant<?> pollutant, BlockState state) {
        return pollutant == Pollutants.BuiltIn.SULFUR.get();
    }

    public boolean isCleanWaterSource(BlockState state) {
        return state.m_60734_() instanceof LiquidBlock && !(state.m_60734_() instanceof PollutedWater) && state.m_60819_().m_76170_() && state.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    public boolean tryPollute(ServerLevel level, BlockPos pos, BlockState state) {
        if (this.isCleanWaterSource(state) && !this.isCleanWaterSource(level.m_8055_(pos.m_7494_()))) {
            return level.m_46597_(pos, this.m_49966_());
        }
        return false;
    }

    public static class FlowingFluid
    extends BaseFluid {
        public FlowingFluid(ForgeFlowingFluid.Properties properties) {
            super(properties);
            this.m_76142_((FluidState)((FluidState)this.f_76105_.m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(7)));
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }

    public static class StillFluid
    extends BaseFluid {
        public StillFluid(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }

        public int m_7430_(FluidState state) {
            return 8;
        }
    }

    public static abstract class BaseFluid
    extends ForgeFlowingFluid {
        protected BaseFluid(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public boolean m_5486_(FluidState state, BlockGetter world, BlockPos pos, Fluid fluid, Direction direction) {
            return super.m_5486_(state, world, pos, fluid, direction);
        }

        protected void m_6364_(LevelAccessor worldIn, BlockPos pos, BlockState blockStateIn, Direction direction, FluidState fluidStateIn) {
            super.m_6364_(worldIn, pos, blockStateIn, direction, fluidStateIn);
        }

        protected boolean m_75977_(BlockGetter worldIn, BlockPos fromPos, BlockState fromBlockState, Direction direction, BlockPos toPos, BlockState toBlockState, FluidState toFluidState, Fluid fluidIn) {
            return super.m_75977_(worldIn, fromPos, fromBlockState, direction, toPos, toBlockState, toFluidState, fluidIn);
        }
    }
}

