/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.mixin;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.impacts.FluidImpacts;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={BottleItem.class})
public abstract class BottleItemMixin
extends Item {
    public BottleItemMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    @Redirect(method={"use"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/alchemy/PotionUtils;setPotion(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/alchemy/Potion;)Lnet/minecraft/world/item/ItemStack;"))
    private ItemStack setPotion(ItemStack stack, Potion potion, Level level, Player player, InteractionHand hand) {
        BlockHitResult hit = BottleItemMixin.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            FluidState fluid = level.m_6425_(hit.m_82425_());
            if (((FluidImpacts)AdPother.getInstance().impacts.fluidImpacts.get()).contains(fluid)) {
                return this.makePoisonousPotion(stack);
            }
        }
        return PotionUtils.m_43549_((ItemStack)stack, (Potion)potion);
    }

    private ItemStack makePoisonousPotion(ItemStack stack) {
        List<MobEffectInstance> allEffects = Stream.of(this.makeEffect(MobEffects.f_19614_, 5, 15), this.makeEffect(MobEffects.f_19610_, 5, 15), this.makeEffect(MobEffects.f_19599_, 30, 300), this.makeEffect(MobEffects.f_19602_, 1, 1), this.makeEffect(MobEffects.f_19597_, 30, 300), this.makeEffect(MobEffects.f_19613_, 30, 300), this.makeEffect(MobEffects.f_19612_, 30, 300), this.makeEffect(MobEffects.f_19604_, 5, 15)).toList();
        HashSet pickedEffects = new HashSet();
        int maxEffects = CommonMath.Random.between((int)1, (int)allEffects.size());
        for (int i = 0; i < maxEffects; ++i) {
            CommonCollect.getRandomElementFrom(allEffects).ifPresent(pickedEffects::add);
        }
        return PotionUtils.m_43552_((ItemStack)stack, pickedEffects);
    }

    private MobEffectInstance makeEffect(MobEffect effect, int minDuration, int maxDuration) {
        CommonTime.Interval interval = CommonTime.Interval.seconds((double)CommonMath.Random.between((int)minDuration, (int)maxDuration));
        int duration = (int)GameTime.inServerTicks((CommonTime.Interval)interval);
        return new MobEffectInstance(effect, duration);
    }
}

