/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.awt.Color;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class Smog {
    public static ForgeConfigSpec.ConfigValue<Boolean> enabled;
    public static ForgeConfigSpec.ConfigValue<Boolean> colored;
    public static ForgeConfigSpec.ConfigValue<Double> density;
    private static final CommonTime.Interval updateInterval;
    private static CommonTime.Stamp lastUpdate;
    private static ColorARGB currentColor;
    private static ColorARGB pollutionColor;
    private static float currentDensity;
    private static float targetDensity;

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        if (!((Boolean)enabled.get()).booleanValue()) {
            return;
        }
        if (CommonTime.Interval.passedFrom((CommonTime.Stamp)lastUpdate).moreThan(updateInterval)) {
            Entity entity = event.getCamera().m_90592_();
            EntityPollution pollution = WorldData.getEntityPollution(entity);
            targetDensity = (float)pollution.getPollutants().map(pollution::getInfluenceOf).mapToDouble(Percentage::toFraction).sum();
            pollutionColor = ColorARGB.blend(pollution.getPollutants().collect(Collectors.toMap(Pollutant::getColor, p -> (int)pollution.getInfluenceOf((Pollutant<?>)((Object)p)).getValue())));
            lastUpdate = CommonTime.Stamp.now();
        }
        float changingStep = 3.0E-4f;
        float delta = targetDensity - currentDensity;
        currentDensity = Math.abs(delta) >= Math.abs(changingStep) ? (currentDensity += changingStep * Math.signum(delta)) : targetDensity;
        if (Smog.updateFogDistance(-8.0f, 1.0f, () -> ((ViewportEvent.RenderFog)event).getNearPlaneDistance(), arg_0 -> ((ViewportEvent.RenderFog)event).setNearPlaneDistance(arg_0))) {
            event.setCanceled(true);
        }
        if (Smog.updateFogDistance(8.0f, 1.0f, () -> ((ViewportEvent.RenderFog)event).getFarPlaneDistance(), arg_0 -> ((ViewportEvent.RenderFog)event).setFarPlaneDistance(arg_0))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onComputeFogColor(ViewportEvent.ComputeFogColor event) {
        ColorARGB targetColor;
        if (!((Boolean)enabled.get()).booleanValue() || !((Boolean)colored.get()).booleanValue()) {
            return;
        }
        FloatBounds range = FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0f));
        ColorARGB vanillaColor = ColorARGB.from((Color)new Color(range.enclose(Float.valueOf(event.getRed())).floatValue(), range.enclose(Float.valueOf(event.getGreen())).floatValue(), range.enclose(Float.valueOf(event.getBlue())).floatValue()));
        ColorARGB colorARGB = targetColor = pollutionColor.equals((Object)ColorARGB.DEFAULT) ? vanillaColor : ColorARGB.blend(Map.of(vanillaColor, 100, pollutionColor, (int)(currentDensity * 100.0f)));
        if (!currentColor.equals((Object)targetColor)) {
            currentColor = Smog.isInWater() ? targetColor : currentColor.approxTo(targetColor, 0.05f);
        }
        event.setRed(currentColor.getRed().toFloat());
        event.setGreen(currentColor.getGreen().toFloat());
        event.setBlue(currentColor.getBlue().toFloat());
    }

    private static boolean updateFogDistance(float min, float pow, Supplier<Float> getter, Consumer<Float> setter) {
        float factor;
        float current = getter.get().floatValue();
        FloatBounds bounds = FloatBounds.between((Float)Float.valueOf(min), (Float)Float.valueOf(current));
        float target = bounds.interpolateDown(factor = (float)(Math.pow(currentDensity, pow) * (Double)density.get())).floatValue();
        if (target < current) {
            setter.accept(Float.valueOf(target));
            return true;
        }
        return false;
    }

    private static boolean isInWater() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player != null && player.m_20069_();
    }

    static {
        updateInterval = GameTime.quaterSecond().getInterval();
        lastUpdate = CommonTime.Stamp.now();
        currentColor = ColorARGB.DEFAULT;
        pollutionColor = ColorARGB.DEFAULT;
        currentDensity = 0.0f;
        targetDensity = 0.0f;
    }
}

