function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/jesz/createdieselgenerators/blocks/entity/LargeDieselGeneratorBlockEntity',
		'methodName' : 'tick',
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'com/simibubi/create/foundation/fluid/FluidHelper',
		'methodName' : 'copyStackWithAmount',
		'methodDesc' : '(Lnet/minecraftforge/fluids/FluidStack;I)Lnet/minecraftforge/fluids/FluidStack;'
	}

	var stacked = {
    	'class' : 'com/jesz/createdieselgenerators/blocks/entity/LargeDieselGeneratorBlockEntity',
    	'fieldName' : 'stacked',
    	'fieldDesc' : 'I'
    }

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraftforge/fluids/FluidStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [ 
		insnDup("fuel fluidstack"),
		insnLoadThis("engine"),
		insnGetField(stacked),
		insnLoadThis("engine"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}