/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.Commands;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.blocks.FilterFrame;
import com.endertech.minecraft.mods.adpother.compat.Create;
import com.endertech.minecraft.mods.adpother.compat.ImmersivePetroleum;
import com.endertech.minecraft.mods.adpother.compat.ImmersiveVehicles;
import com.endertech.minecraft.mods.adpother.compat.Minecraft;
import com.endertech.minecraft.mods.adpother.emissions.Emission;
import com.endertech.minecraft.mods.adpother.emissions.PeriodicEntityEmission;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.events.AnvilEvents;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.init.BiomeModifierCodecs;
import com.endertech.minecraft.mods.adpother.init.Blocks;
import com.endertech.minecraft.mods.adpother.init.Breakables;
import com.endertech.minecraft.mods.adpother.init.Containers;
import com.endertech.minecraft.mods.adpother.init.Effects;
import com.endertech.minecraft.mods.adpother.init.Emitters;
import com.endertech.minecraft.mods.adpother.init.Entities;
import com.endertech.minecraft.mods.adpother.init.Features;
import com.endertech.minecraft.mods.adpother.init.FluidTypes;
import com.endertech.minecraft.mods.adpother.init.Fluids;
import com.endertech.minecraft.mods.adpother.init.Fuels;
import com.endertech.minecraft.mods.adpother.init.Impacts;
import com.endertech.minecraft.mods.adpother.init.Items;
import com.endertech.minecraft.mods.adpother.init.Materials;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.init.Respirators;
import com.endertech.minecraft.mods.adpother.init.Sources;
import com.endertech.minecraft.mods.adpother.init.Tiles;
import com.endertech.minecraft.mods.adpother.init.Torches;
import com.endertech.minecraft.mods.adpother.items.Aerometer;
import com.endertech.minecraft.mods.adpother.items.GasBlockItem;
import com.endertech.minecraft.mods.adpother.items.VacuumTube;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.GasExplosion;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.renderers.FilterFrameRenderer;
import com.endertech.minecraft.mods.adpother.renderers.FilterFrameScreen;
import com.endertech.minecraft.mods.adpother.renderers.GasRenderer;
import com.endertech.minecraft.mods.adpother.renderers.PurifiedAirRenderer;
import com.endertech.minecraft.mods.adpother.renderers.Smog;
import com.endertech.minecraft.mods.adpother.renderers.VacuumBagLayer;
import com.endertech.minecraft.mods.adpother.sources.BreakableBlock;
import com.endertech.minecraft.mods.adpother.sources.DroppedTorch;
import com.endertech.minecraft.mods.adpother.sources.Torch;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="adpother")
public class AdPother
extends AbstractForgeMod {
    public static final String ID = "adpother";
    private static AdPother instance;
    public final Blocks blocks;
    public final Containers containers;
    public final Effects effects;
    public final Emitters emitters;
    public final Entities entities;
    public final Features features;
    public final BiomeModifierCodecs codecs;
    public final FluidTypes fluidTypes;
    public final Fluids fluids;
    public final Fuels fuels;
    public final Impacts impacts;
    public final Items items;
    public final Pollutants pollutants;
    public final Respirators respirators;
    public final Sources sources;
    public final Tiles tiles;
    public final Torches torches;
    public final Breakables breakables;

    public AdPother() {
        instance = this;
        this.initBounds();
        this.pollutants = new Pollutants(this);
        this.blocks = new Blocks(this);
        this.containers = new Containers(this);
        this.items = new Items(this);
        this.effects = new Effects(this);
        this.emitters = new Emitters(this);
        this.entities = new Entities(this);
        this.features = new Features(this);
        this.codecs = new BiomeModifierCodecs(this);
        this.fuels = new Fuels(this);
        this.fluidTypes = new FluidTypes(this);
        this.fluids = new Fluids(this);
        this.impacts = new Impacts(this);
        this.respirators = new Respirators(this);
        this.sources = new Sources(this);
        this.tiles = new Tiles(this);
        this.torches = new Torches(this);
        this.breakables = new Breakables(this);
        this.registerCommonConfig();
        this.registerClientConfig();
    }

    public static AdPother getInstance() {
        return instance;
    }

    public String getId() {
        return ID;
    }

    public void commonInit() {
        this.registerNetMessage(VacuumTube.BlockSuckInMsg::new);
        this.registerNetMessage(VacuumTube.EntitySuckInMsg::new);
        this.registerNetMessage(EntityPollution.NetMsg::new);
        this.registerNetMessage(ImmersivePetroleum.FuelConsumedMsg::new);
        this.registerNetMessage(FilterFrame.PollutantFilteredMsg::new);
    }

    public void commonPostInit() {
    }

    public void tagsUpdated() {
        this.runPostInitRunnables();
    }

    private void initBounds() {
        UnitConfig config = UnitConfig.in((Path)this.getConfigsDir(), (String)"Bounds");
        WorldData.altitudeBounds = config.getIntBounds("", "Altitude", GameBounds.HEIGHT.getIntBounds(), IntBounds.INTEGER, "Altitude bounds pollution can act within.");
        config.save();
    }

    public void commonConfigInit(AbstractForgeMod.ConfigValueBuilder value) {
        Emission.globalRate = value.comment("Global rate of emissions for all pollutants and sources on the server").defineInRange("globalEmissionRate", 1.0f, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(10.0f)));
        AnvilEvents.filterReplacingExpGain = value.comment("Experience gain after replacing the filter material in a respirator or a vacuum bag").defineInRange("filterReplacingExpGain", 0, IntBounds.between((Integer)-10, (Integer)10));
        GasEntity.maxGasEntitiesInChunk = value.comment("Maximum number of gas entities present at the same time in a chunk").defineInRange("maxGasEntitiesInChunk", 10, IntBounds.between((Integer)0, (Integer)256));
        value.push("GasExplosions");
        GasExplosion.ignitionSources = value.comment("Enables/disables gas explosions caused by ignition sources").define("ignitionSources", true);
        GasExplosion.enclosedEmitters = value.comment("Enables/disables gas explosions caused by emitters (machines) when they produce pollution and it has no way to go").define("enclosedEmitters", true);
        GasExplosion.setOnFire = value.comment("Whether gas explosions set surrounding blocks on fire").define("setOnFire", true);
        GasExplosion.explosionInteraction = value.comment("The way gas explosions affect surroundings").defineEnum("explosionInteraction", (Enum)Level.ExplosionInteraction.TNT);
        GasExplosion.maxChainLength = value.comment("Maximum gas blocks that can be involved in an explosive chain reaction").defineInRange("maxChainLength", 512, IntBounds.between((Integer)0, (Integer)2048));
        value.pop();
        value.push("EmissionSources");
        BreakableBlock.rate = this.defineRate(value, "Breakables", 1.0f);
        PeriodicEntityEmission.rate = this.defineRate(value, "Entities", 1.0f);
        Torch.rate = this.defineRate(value, "WallTorches", 0.0f);
        DroppedTorch.rate = this.defineRate(value, "DroppedTorches", 0.0f);
        Minecraft.Campfire.rate = this.defineRate(value, "Campfires", 0.0f);
        WorldEvents.burntItemEmissionRate = this.defineRate(value, "BurntItems", 1.0f);
        WorldEvents.furnaceEmissions = this.defineSwitch(value, "Furnaces", true);
        WorldEvents.burntBlockEmissions = this.defineSwitch(value, "BurntBlocks", true);
        this.sources.mapAll().forEach((name, source) -> this.sources.enabled.put((String)name, this.defineSwitch(value, String.join((CharSequence)"", UnitId.splitRegName((String)name, (boolean)true, (boolean)false)), true)));
        value.push("Mods");
        ImmersiveVehicles.rate = this.defineRate(value, "ImmersiveVehicles", 1.0f);
        Create.inWorldProcessingEmissions = this.defineSwitch(value, "CreateInWorldProcessing", true);
        value.pop();
        value.pop();
    }

    private ForgeConfigSpec.ConfigValue<Double> defineRate(AbstractForgeMod.ConfigValueBuilder builder, String path, float defaultValue) {
        return builder.comment("Rate of emissions from this source").defineInRange(path, defaultValue, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(10.0f)));
    }

    private ForgeConfigSpec.ConfigValue<Boolean> defineSwitch(AbstractForgeMod.ConfigValueBuilder builder, String path, boolean defaultValue) {
        return builder.comment("Enables / disables emissions from this source").define(path, defaultValue);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientConfigInit(AbstractForgeMod.ConfigValueBuilder value) {
        value.push("Smog");
        Smog.enabled = value.comment("Enables/disables smog from pollution").define("enabled", true);
        Smog.colored = value.comment("Whether smog changes color depending on pollution").define("colored", true);
        Smog.density = value.comment("Smog density").defineInRange("density", 1.0f, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0f)));
        value.pop();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        this.pollutants.streamAll().filter(AbstractGas.class::isInstance).forEach(pollutant -> this.setRenderLayer((Block)pollutant, RenderType.m_110466_()));
        for (Materials material : Materials.values()) {
            this.setRenderLayer((Block)material.filterFrame.get(), RenderType.m_110466_());
        }
        this.setRenderLayer((Block)this.blocks.pollutedWater.get(), RenderType.m_110466_());
        this.setRenderLayer((Fluid)this.fluids.pollutedWaterFlowing.get(), RenderType.m_110466_());
        this.setRenderLayer((Fluid)this.fluids.pollutedWaterStill.get(), RenderType.m_110466_());
        this.registerContainerScreen((MenuType)this.containers.filterFrame.get(), FilterFrameScreen::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientAddRenderLayers() {
        this.addPlayerRenderLayer(VacuumBagLayer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientBuildCreativeModeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256776_) {
            this.items.streamAll().filter(GasBlockItem.class::isInstance).forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).m_246326_(arg_0));
        }
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(this.items.aerometer);
            event.accept(this.items.pollutedWaterBucket);
            for (Materials material : Materials.values()) {
                event.accept(material.respirator);
                event.accept(material.vacuumBag);
                event.accept(material.vacuumTube);
            }
        }
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            for (Materials material : Materials.values()) {
                event.accept(material.filterFrameItem);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterRenderers() {
        this.registerEntityRender((EntityType)this.entities.gas.get(), GasRenderer::new);
        this.registerEntityRender((EntityType)this.entities.purifiedAir.get(), PurifiedAirRenderer::new);
        this.registerTileRenderer((BlockEntityType)this.tiles.filterFrame.get(), FilterFrameRenderer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterItemModelProperties(ItemModel.Properties<?> props) {
        props.register((Item)this.items.aerometer.get(), "state", (stack, world, entity) -> {
            if (ForgeItem.isBroken((ItemStack)stack)) {
                return -1.0f;
            }
            Optional<Entity> carrier = Aerometer.getCarrierFor(stack);
            if (carrier.isPresent()) {
                EntityPollution pollution = WorldData.getEntityPollution(carrier.get());
                return pollution.getDominantPollutant(pollutant -> true).map(pollution::getInfluenceOf).map(influence -> Float.valueOf((float)influence.getGrade().ordinal() + 1.0f)).orElse(Float.valueOf(0.0f)).floatValue();
            }
            return 0.0f;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientReplaceModels(ItemModel.RegistryWrapper registry) {
        registry.replaceModelOf((Item)this.items.aerometer.get(), ItemModel.BuiltIn::new);
    }

    protected void serverStarting(MinecraftServer server) {
    }

    public void registerCommands(ServerCommand command, CommandBuildContext buildContext) {
        command.requires(ServerCommand.OpLevel.MODERATORS);
        command.task("list").executes(Commands::listBreakables, "breakables").executes(Commands::listEmitters, "emitters").executes(Commands::listFluids, "fluids").executes(Commands::listFuels, "fuels").executes(Commands::listTorches, "torches");
        command.task("locate").executes(Commands::locateConfigs, "configs");
        command.task("gen").executes(Commands::generateSpots, new ServerCommand.Arg[]{Commands.pollutantArg(), ServerCommand.Arg.integer((String)"amount", (IntBounds)GameBounds.POLLUTION.getIntBounds())});
        command.task("cloud").executes(Commands::generateCloud, new ServerCommand.Arg[]{Commands.pollutantArg(), ServerCommand.Arg.integer((String)"amount", (IntBounds)GameBounds.POLLUTION.getIntBounds())});
        command.task("identify").executes(Commands::identifyFuel, "fuel").executes(Commands::identifyEmitter, "emitter").executes(Commands::identifyBlock, "block").executes(Commands::identifyFluid, "fluid").executes(Commands::identifyItem, "item").executes(Commands::identifyEntity, "entity").executes(Commands::identifyTile, "tile");
        command.task("clean").executes(Commands::cleanChunk, "chunk").executes(Commands::cleanChunksAround, "around");
        command.task("emit").executes(Commands::emitAt, new ServerCommand.Arg[]{Commands.pollutantArg(), ServerCommand.Arg.integer((String)"quantity", (IntBounds)IntBounds.between((Integer)0, (Integer)16))});
        command.task("impact").executes(Commands::testImpact, new ServerCommand.Arg[]{Commands.pollutantArg(), Commands.impactTypeArg()});
        command.task("logging").executes(Commands::loggingFuelConsumption, "fuel").executes(Commands::loggingFoodConsumption, "food");
        command.task("recalc").executes(Commands::recalcPollutionAtChunk, "chunk").executes(Commands::recalcPollutionAround, "around");
        command.task("reload").executes(Commands::reloadBiomes, "biomes").executes(Commands::reloadBreakables, "breakables").executes(Commands::reloadEmitters, "emitters").executes(Commands::reloadFuels, "fuels").executes(Commands::reloadImpacts, "impacts").executes(Commands::reloadSources, "sources").executes(Commands::reloadTorches, "torches");
        command.task("stats").executes(Commands::chunkStats, "chunk").executes(Commands::worldStats, "world");
        command.task("tag").executes(Commands::testTag, new ServerCommand.Arg[]{ServerCommand.Arg.of((String)"tag", (ArgumentType)StringArgumentType.greedyString())});
        command.task("tick").executes(Commands::tickBlock, "block").executes(Commands::tickFluid, "fluid");
        command.register();
    }
}

