/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.EmitterWithCustomRate;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.INBTSerializable;

public class ImmersiveVehicles {
    public static ForgeConfigSpec.ConfigValue<Double> rate;

    public static class Vehicle
    extends EmitterWithCustomRate {
        protected float emissionFactor = 0.0f;

        public Vehicle(UnitConfig config, Emitter.Properties<?> props) {
            super(config, (Emitter.Properties<?>)((Object)props.activeStateHardcoded()));
        }

        @Override
        protected float getRate() {
            return this.emissionFactor * ((Double)rate.get()).floatValue();
        }

        @Override
        public boolean isActive(INBTSerializable<CompoundTag> nbtSource) {
            this.emissionFactor = 0.0f;
            if (nbtSource == null) {
                return false;
            }
            CompoundTag root = TagHelper.serialize(nbtSource);
            int totalParts = root.m_128451_("totalParts");
            for (int i = 0; i < totalParts; ++i) {
                CompoundTag part = root.m_128469_("part_" + i);
                int engineState = part.m_128451_("state");
                if (engineState < 6) continue;
                String partName = part.m_128461_("systemName");
                float fuelUsage = Engines.getFuelUsage(partName);
                double rpm = part.m_128459_("rpm");
                this.emissionFactor += fuelUsage * (float)(rpm / 1000.0);
            }
            return this.emissionFactor > 0.0f;
        }

        static enum Engines {
            amci4(0.35f),
            lawnmower(0.4f),
            lycomingo360(0.4f),
            bristolmercury(0.75f),
            carterpillarv12(1.55f),
            catc11acert(2.9f),
            catc15acert(3.4f),
            catc18acert(3.6f),
            catc27acert(3.9f),
            catc32acert(4.4f),
            catc4_4acert("catc4.4acert", 1.0f),
            catc4_4acertwinturbo("catc4.4acertwinturbo", 1.25f),
            catc7_1acert("catc7.1acert", 1.39f),
            catc9_3acert("catc9.3acert", 2.09f),
            chevy_engine_v8(0.5f),
            cf34_3series(2.5f),
            corvair_engine_102a(0.4f),
            corvair_engine_102s(0.4f),
            vw_engine_40s(0.3f),
            detroitdiesel(1.5f),
            dvc_model10636(0.45f),
            dvcboxer401650(0.4f),
            dvcv6model10632(0.425f),
            dvcv8model10866(0.6f),
            engineboxer4(0.4f),
            pw610f(0.35f),
            sparrowengine(0.7f),
            trin_biturbine_engine(5.0f),
            trin_boat_engine_small(0.2f),
            trin_i3(0.1f),
            trin_i3_man(0.1f),
            trin_i3_turbo(0.15f),
            trin_i4(0.2f),
            trin_i4_man(0.2f),
            trin_i4_turbo(0.25f),
            trin_i5(0.25f),
            trin_i5_man(0.25f),
            trin_i5_turbo(0.3f),
            trin_v6(0.3f),
            trin_v6_compact(0.45f),
            trin_v6_turbo(0.33f),
            trin_v8(0.5f),
            trin_v8_manual(0.5f),
            trin_v8_turbo(0.6f),
            trin_v10(0.65f),
            trin_v10_man(0.65f),
            trin_v12(0.85f),
            trin_v12_biturbo(1.0f),
            trin_v12_man(0.85f),
            unu_engine_apu(0.1f),
            unu_engine_h6(0.4f),
            unu_engine_i1m(0.05f),
            unu_engine_i2(0.1f),
            unu_engine_i10h(0.95f),
            unu_engine_i12h(1.1f),
            unu_engine_i6h(0.65f),
            unu_engine_i8h(0.8f),
            unu_engine_j1018tj(0.5f),
            unu_engine_j2350tf(2.0f),
            unu_engine_j3283tf(1.2f),
            unu_engine_j34200tj(5.0f),
            unu_engine_v10h(1.05f),
            unu_engine_v6(0.5f),
            unu_engine_v8(0.6f),
            unu_engine_v8h(0.9f),
            unu_engine_v12ha(4.0f);

            private final String customName;
            public final float fuelUsage;

            private Engines(float fuelUsage) {
                this("", fuelUsage);
            }

            private Engines(String customName, float fuelUsage) {
                this.customName = customName;
                this.fuelUsage = fuelUsage;
            }

            public static float getFuelUsage(String partName) {
                for (Engines engine : Engines.values()) {
                    String name;
                    String string = name = engine.customName.isEmpty() ? engine.name() : engine.customName;
                    if (!partName.endsWith(name)) continue;
                    return engine.fuelUsage;
                }
                return 1.0f;
            }
        }
    }
}

