/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.events;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.utils.Color;
import dlovin.advancedcompass.utils.GLShim;
import dlovin.advancedcompass.utils.GLUtils;
import dlovin.advancedcompass.utils.GroupUtils;
import dlovin.advancedcompass.utils.HeadUtils;
import dlovin.advancedcompass.utils.ImageUtils;
import dlovin.advancedcompass.utils.JsonUtils;
import dlovin.advancedcompass.utils.ReflectionUtils;
import dlovin.advancedcompass.utils.StringUtils;
import dlovin.advancedcompass.utils.TextureCoords;
import dlovin.advancedcompass.utils.waypoints.Waypoint;
import dlovin.advancedcompass.utils.waypoints.WaypointIcon;
import dlovin.advancedcompass.utils.waypoints.WaypointJsonUtils;
import dlovin.advancedcompass.utils.waypoints.WaypointUtils;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.client.renderer.entity.model.BatModel;
import net.minecraft.client.renderer.entity.model.BeeModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.BlazeModel;
import net.minecraft.client.renderer.entity.model.ChickenModel;
import net.minecraft.client.renderer.entity.model.CowModel;
import net.minecraft.client.renderer.entity.model.CreeperModel;
import net.minecraft.client.renderer.entity.model.DolphinModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.GhastModel;
import net.minecraft.client.renderer.entity.model.GuardianModel;
import net.minecraft.client.renderer.entity.model.HorseModel;
import net.minecraft.client.renderer.entity.model.IllagerModel;
import net.minecraft.client.renderer.entity.model.IronGolemModel;
import net.minecraft.client.renderer.entity.model.MagmaCubeModel;
import net.minecraft.client.renderer.entity.model.OcelotModel;
import net.minecraft.client.renderer.entity.model.PhantomModel;
import net.minecraft.client.renderer.entity.model.PigModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.entity.model.PolarBearModel;
import net.minecraft.client.renderer.entity.model.QuadrupedModel;
import net.minecraft.client.renderer.entity.model.RabbitModel;
import net.minecraft.client.renderer.entity.model.RavagerModel;
import net.minecraft.client.renderer.entity.model.ShulkerModel;
import net.minecraft.client.renderer.entity.model.SilverfishModel;
import net.minecraft.client.renderer.entity.model.SlimeModel;
import net.minecraft.client.renderer.entity.model.SnowManModel;
import net.minecraft.client.renderer.entity.model.SpiderModel;
import net.minecraft.client.renderer.entity.model.SquidModel;
import net.minecraft.client.renderer.entity.model.StriderModel;
import net.minecraft.client.renderer.entity.model.TropicalFishAModel;
import net.minecraft.client.renderer.entity.model.TropicalFishBModel;
import net.minecraft.client.renderer.entity.model.VillagerModel;
import net.minecraft.client.renderer.entity.model.WolfModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.storage.ServerWorldInfo;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLPaths;

public class EntityEvents {
    private Minecraft mc = Minecraft.func_71410_x();
    private List<EntityType> types = new ArrayList<EntityType>();
    private ArrayDeque<QueuedEntity> queue = new ArrayDeque();

    public EntityEvents() {
        for (Map.Entry<EntityType, TextureCoords> entry : HeadUtils.heads.entrySet()) {
            this.types.add(entry.getKey());
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(GuiOpenEvent event) {
        if (event.getGui() instanceof DeathScreen && AdvancedCompass.getInstance().getCompassGui().settings.autoDeathWaypoint) {
            this.createDeathWaypoint(this.mc.field_71439_g.func_213303_ch());
        }
    }

    private void createDeathWaypoint(Vector3d position) {
        String dir = "";
        dir = this.mc.func_147104_D() != null ? StringUtils.trimPort(this.mc.func_147104_D().field_78845_b) : StringUtils.removeIllegal(((ServerWorldInfo)this.mc.func_71401_C().func_241755_D_().func_72912_H()).func_76065_j());
        String name = "DP(" + (int)position.field_72450_a + "_" + (int)position.field_72448_b + "_" + (int)position.field_72449_c + ")";
        Waypoint wp = new Waypoint(name, position, this.mc.field_71441_e.func_234923_W_().func_240901_a_().toString(), WaypointIcon.SKULL, new Color(1.0f, 1.0f, 1.0f), 0, 0, true);
        WaypointJsonUtils.addWaypoint(dir, wp, true);
        AdvancedCompass.getInstance().getCompassGui().addWaypoint(wp);
    }

    @SubscribeEvent
    public void onEntityEnter(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof MobEntity) {
            if (!this.types.contains(event.getEntity().func_200600_R())) {
                this.types.add(event.getEntity().func_200600_R());
                Entity en = event.getEntity();
                try {
                    ResourceLocation resourceLocation = this.mc.func_175598_ae().func_78713_a(en).func_110775_a(en);
                    this.queue.add(new QueuedEntity(en, resourceLocation));
                }
                catch (Exception ex) {
                    AdvancedCompass.logger.info("Can't add icon for " + event.getEntity().func_200600_R());
                }
            }
        } else if (event.getEntity().equals((Object)this.mc.field_71439_g)) {
            String dir = this.mc.func_147104_D() != null ? StringUtils.trimPort(this.mc.func_147104_D().field_78845_b) : StringUtils.removeIllegal(((ServerWorldInfo)this.mc.func_71401_C().func_241755_D_().func_72912_H()).func_76065_j());
            Collection<Waypoint> waypoints = WaypointJsonUtils.getWaypoints(dir);
            waypoints = WaypointUtils.getWaypointsInDimension(event.getWorld().func_234923_W_().func_240901_a_().toString(), waypoints);
            AdvancedCompass.getInstance().getCompassGui().setWaypoints(waypoints);
        }
    }

    private boolean TryToSaveIcon(BufferedImage mobSkin, Entity en, String namespace) throws RasterFormatException {
        if (mobSkin != null) {
            File directory = new File(FMLPaths.CONFIGDIR.get() + "/AdvancedCompass/mobs/" + namespace);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            File outputfile = new File(directory + "/" + en.func_200600_R().getRegistryName().func_110623_a() + ".png");
            try {
                BufferedImage editedImage = ImageUtils.outlineImage(ImageUtils.rescale(ImageUtils.cropImage(mobSkin), 1));
                ImageIO.write((RenderedImage)editedImage, "png", outputfile);
                JsonUtils.addMob(namespace + "/mobs.json", en.func_200600_R().getRegistryName().func_110623_a(), editedImage.getWidth(), editedImage.getHeight());
                HeadUtils.addHead(en.func_200600_R(), editedImage.getWidth(), editedImage.getHeight(), new ResourceLocation("advancedcompass." + namespace, en.func_200600_R().getRegistryName().func_110623_a()));
                GroupUtils.types.add(en.func_200600_R());
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        AdvancedCompass.logger.info("Can't create icon for: " + en.func_200600_R().getRegistryName());
        return false;
    }

    @SubscribeEvent
    public void onEnter(RenderGameOverlayEvent.Post event) {
        if (!event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
            return;
        }
        while (this.queue.peek() != null) {
            QueuedEntity queuedEntity = this.queue.pop();
            Entity en = queuedEntity.entity;
            ResourceLocation resourceLocation = queuedEntity.resourceLocation;
            String namespace = en.func_200600_R().getRegistryName().func_110624_b();
            BufferedImage mobSkin = this.createAutoIconImageFromResourceLocations(en, (EntityRenderer<? extends Entity>)this.mc.func_175598_ae().func_78713_a(en), resourceLocation, event.getPartialTicks());
            try {
                this.TryToSaveIcon(mobSkin, en, namespace);
            }
            catch (RasterFormatException ex) {
                mobSkin = this.createAutoIconViaEntityRenderer(en);
                try {
                    this.TryToSaveIcon(mobSkin, en, namespace);
                }
                catch (RasterFormatException ex1) {
                    AdvancedCompass.logger.info("Can't create icon for: " + en.func_200600_R().getRegistryName());
                }
            }
        }
    }

    private BufferedImage createAutoIconViaEntityRenderer(Entity en) {
        BufferedImage headImage = null;
        try {
            boolean success = this.drawEntity((LivingEntity)en);
            if (success) {
                headImage = ImageUtils.createBufferedImageFromGLID(GLUtils.fboTextureID);
            }
        }
        catch (Exception ex) {
            headImage = null;
            ex.printStackTrace();
        }
        return headImage;
    }

    /*
     * Unable to fully structure code
     */
    private BufferedImage createAutoIconImageFromResourceLocations(Entity en, EntityRenderer<? extends Entity> render, ResourceLocation resourceLocations, float partialTicks) {
        headImage = null;
        model = null;
        if (render instanceof LivingRenderer || render == null) {
            try {
                model = ((LivingRenderer)render).func_217764_d();
                if (render instanceof TropicalFishRenderer) {
                    fishModel = null;
                    size = ((TropicalFishEntity)en).func_204217_dE();
                    fishModel = size == 0 ? ReflectionUtils.getPrivateFieldValueByType(render, TropicalFishRenderer.class, TropicalFishAModel.class) : ReflectionUtils.getPrivateFieldValueByType(render, TropicalFishRenderer.class, TropicalFishBModel.class);
                    if (fishModel != null) {
                        model = (EntityModel)fishModel;
                    }
                }
                submodels = ReflectionUtils.getFieldsByType(model, EntityModel.class, ModelRenderer.class);
                submodelArrays = ReflectionUtils.getFieldsByType(model, EntityModel.class, ModelRenderer[].class);
                headBits = null;
                headPartsWithResourceLocationList = new ArrayList<ModelPartWithResourceLocation>();
                properties = new Properties();
                fullName = en.getClass().getName();
                simpleName = en.getClass().getSimpleName();
                fullPath = ("textures/icons/" + fullName + ".properties").toLowerCase();
                is = null;
                try {
                    is = this.mc.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (Exception var27) {
                    is = null;
                }
                if (is == null) {
                    fullPath = ("textures/icons/" + simpleName + ".properties").toLowerCase();
                    try {
                        is = this.mc.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                    }
                    catch (Exception var26) {
                        is = null;
                    }
                }
                if (is != null) {
                    properties.load(is);
                    is.close();
                    subModelNames = properties.getProperty("models", "").toLowerCase();
                    submodelNamesArray = subModelNames.split(",");
                    subModelNamesList = Arrays.asList(submodelNamesArray);
                    subModelNamesSet = new HashSet<String>();
                    subModelNamesSet.addAll(subModelNamesList);
                    headPartsArrayList = new ArrayList<ModelRenderer>();
                    var20 = submodelArrays.iterator();
                    block8: while (true) {
                        if (!var20.hasNext()) {
                            var20 = submodels.iterator();
                            while (true) {
                                if (!var20.hasNext()) {
                                    if (headPartsArrayList.size() <= 0) break block8;
                                    headBits = headPartsArrayList.toArray(new ModelRenderer[headPartsArrayList.size()]);
                                    break block8;
                                }
                                submodel = var20.next();
                                name = submodel.getName().toLowerCase();
                                if (!subModelNamesSet.contains(name) && !subModelNames.equals("all") || submodel.get(model) == null) continue;
                                headPartsArrayList.add((ModelRenderer)submodel.get(model));
                            }
                        }
                        submodel = var20.next();
                        name = submodel.getName().toLowerCase();
                        if (!subModelNamesSet.contains(name) && !subModelNames.equals("all") || (submodelArrayValue = (ModelRenderer[])submodel.get(model)) == null) continue;
                        t = 0;
                        while (true) {
                            if (t < submodelArrayValue.length) ** break;
                            continue block8;
                            headPartsArrayList.add(submodelArrayValue[t]);
                            ++t;
                        }
                        break;
                    }
                }
                if (headBits == null) {
                    if (model instanceof PlayerModel) {
                        showHat = true;
                        if (en instanceof PlayerEntity) {
                            player = (PlayerEntity)en;
                            showHat = player.func_175148_a(PlayerModelPart.HAT);
                        }
                        headBits = showHat ? new ModelRenderer[]{((PlayerModel)model).field_78116_c, ((PlayerModel)model).field_178720_f} : new ModelRenderer[]{((PlayerModel)model).field_78116_c};
                    } else if (model instanceof BatModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, BeeModel.class, ModelRenderer.class)};
                    } else if (model instanceof BeeModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, BeeModel.class, ModelRenderer.class, 0), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, BeeModel.class, ModelRenderer.class, 8), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, BeeModel.class, ModelRenderer.class, 9)};
                    } else if (model instanceof BipedModel) {
                        headBits = new ModelRenderer[]{((BipedModel)model).field_78116_c, ((BipedModel)model).field_178720_f};
                    } else if (model instanceof BlazeModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, BlazeModel.class, ModelRenderer.class)};
                    } else if (model instanceof ChickenModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ChickenModel.class, ModelRenderer.class)};
                    } else if (model instanceof CowModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, ModelRenderer.class)};
                    } else if (model instanceof CreeperModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, CreeperModel.class, ModelRenderer.class)};
                    } else if (model instanceof DolphinModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, DolphinModel.class, ModelRenderer.class)};
                    } else if (model instanceof EnderDragonRenderer.EnderDragonModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, EnderDragonRenderer.EnderDragonModel.class, ModelRenderer.class)};
                    } else if (model instanceof GhastModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)((GhastModel)model).func_225601_a_().iterator().next()};
                    } else if (model instanceof GuardianModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, GuardianModel.class, ModelRenderer.class, 0), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, GuardianModel.class, ModelRenderer.class, 1)};
                    } else if (model instanceof HorseModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, HorseModel.class, ModelRenderer.class)};
                    } else if (model instanceof IllagerModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, IllagerModel.class, ModelRenderer.class)};
                    } else if (model instanceof IronGolemModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, IronGolemModel.class, ModelRenderer.class)};
                    } else if (model instanceof MagmaCubeModel) {
                        headBits = (ModelRenderer[])ReflectionUtils.getPrivateFieldValueByType(model, MagmaCubeModel.class, ModelRenderer[].class);
                    } else if (model instanceof OcelotModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, OcelotModel.class, ModelRenderer.class, 6)};
                    } else if (model instanceof PhantomModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, PhantomModel.class, ModelRenderer.class)};
                    } else if (model instanceof PigModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, ModelRenderer.class)};
                    } else if (model instanceof PolarBearModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, ModelRenderer.class)};
                    } else if (model instanceof RabbitModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, ModelRenderer.class, 7), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, ModelRenderer.class, 8), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, ModelRenderer.class, 9), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, ModelRenderer.class, 10)};
                    } else if (model instanceof RavagerModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, RavagerModel.class, ModelRenderer.class, 7)};
                    } else if (model instanceof ShulkerModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ShulkerModel.class, ModelRenderer.class, 2)};
                    } else if (model instanceof SilverfishModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)((Object[])ReflectionUtils.getPrivateFieldValueByType(model, SilverfishModel.class, ModelRenderer[].class))[0], (ModelRenderer)((Object[])ReflectionUtils.getPrivateFieldValueByType(model, SilverfishModel.class, ModelRenderer[].class))[1]};
                    } else if (model instanceof SlimeModel) {
                        modelOuter = new SlimeModel(0);
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, ModelRenderer.class, 0), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, ModelRenderer.class, 1), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, ModelRenderer.class, 2), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, ModelRenderer.class, 3), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(modelOuter, SlimeModel.class, ModelRenderer.class, 0)};
                    } else if (model instanceof SnowManModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SnowManModel.class, ModelRenderer.class, 2)};
                    } else if (model instanceof SpiderModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SpiderModel.class, ModelRenderer.class)};
                    } else if (model instanceof SquidModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SquidModel.class, ModelRenderer.class)};
                    } else if (model instanceof StriderModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, StriderModel.class, ModelRenderer.class, 2)};
                    } else if (model instanceof VillagerModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, VillagerModel.class, ModelRenderer.class)};
                    } else if (model instanceof WolfModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, WolfModel.class, ModelRenderer.class)};
                    } else if (model instanceof QuadrupedModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, ModelRenderer.class)};
                    } else {
                        headPartsArrayList = new ArrayList<ModelRenderer>();
                        purge = new ArrayList<E>();
                        var37 = submodelArrays.iterator();
                        while (true) {
                            if (!var37.hasNext()) {
                                for (Field submodel : submodels) {
                                    name = submodel.getName().toLowerCase();
                                    nameS = submodel.getName();
                                    if (!(name.contains("head") | name.contains("eye") | name.contains("mouth") | name.contains("teeth") | name.contains("tooth") | name.contains("tusk") | name.contains("jaw") | name.contains("mand") | name.contains("nose") | name.contains("beak") | name.contains("snout") | name.contains("muzzle") | (name.contains("rear") == false && name.contains("ear") != false) | name.contains("trunk") | name.contains("mane") | name.contains("horn") | name.contains("antler") | nameS.equals("REar") | nameS.equals("Trout")) || !(nameS.equals("LeftSmallEar") == false & nameS.equals("RightSmallEar") == false & nameS.equals("BHead") == false & nameS.equals("BSnout") == false & nameS.equals("BMouth") == false & nameS.equals("BMouthOpen") == false & nameS.equals("BLEar") == false & nameS.equals("BREar") == false & nameS.equals("CHead") == false & nameS.equals("CSnout") == false & nameS.equals("CMouth") == false & nameS.equals("CMouthOpen") == false & nameS.equals("CLEar") == false & nameS.equals("CREar") == false) || submodel.get(model) == null) continue;
                                    headPartsArrayList.add((ModelRenderer)submodel.get(model));
                                }
                                if (headPartsArrayList.size() == 0) {
                                    if (submodels.size() > 0) {
                                        if (submodels.get(0).get(model) != null) {
                                            headPartsArrayList.add((ModelRenderer)submodels.get(0).get(model));
                                        }
                                    } else if (submodelArrays.size() > 0 && submodelArrays.get(0).get(model) != null && (submodelArrayValue = (ModelRenderer[])submodelArrays.get(0).get(model)).length > 0) {
                                        headPartsArrayList.add(submodelArrayValue[0]);
                                    }
                                }
                                for (ModelRenderer bit : headPartsArrayList) {
                                    try {
                                        childrenObj = ReflectionUtils.getPrivateFieldValueByType(bit, ModelRenderer.class, ObjectList.class, 1);
                                        if (childrenObj == null) continue;
                                        children = (List)childrenObj;
                                        purge.addAll(children);
                                    }
                                    catch (Exception var23_34) {}
                                }
                                headPartsArrayList.removeAll(purge);
                                headBits = headPartsArrayList.toArray(new ModelRenderer[headPartsArrayList.size()]);
                                break;
                            }
                            submodel = var37.next();
                            name = submodel.getName().toLowerCase();
                            if (!(name.contains("head") | name.contains("eye") | name.contains("mouth") | name.contains("teeth") | name.contains("tooth") | name.contains("tusk") | name.contains("jaw") | name.contains("mand") | name.contains("nose") | name.contains("beak") | name.contains("snout") | name.contains("muzzle") | (name.contains("rear") == false && name.contains("ear") != false) | name.contains("trunk") | name.contains("mane") | name.contains("horn") | name.contains("antler")) || (submodelArrayValue = (ModelRenderer[])submodel.get(model)) == null || submodelArrayValue.length < 0) continue;
                            headPartsArrayList.add(submodelArrayValue[0]);
                        }
                    }
                }
                if (en != null && model != null && (headBits != null && headBits.length > 0 || headPartsWithResourceLocationList.size() > 0) && resourceLocations != null) {
                    subModelNames = properties.getProperty("scale", "1");
                    scale = Float.parseFloat(subModelNames);
                    facing = Direction.NORTH;
                    facingString = properties.getProperty("facing", "front");
                    if (facingString.equals("top")) {
                        facing = Direction.UP;
                    } else if (facingString.equals("side")) {
                        facing = Direction.EAST;
                    }
                    if (headBits != null) {
                        for (t = 0; t < headBits.length; ++t) {
                            headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(headBits[t], resourceLocations));
                        }
                    }
                    if (success = this.drawModel(scale, 1000, (LivingEntity)en, facing, model, headBitsWithLocations = headPartsWithResourceLocationList.toArray(new ModelPartWithResourceLocation[headPartsWithResourceLocationList.size()]))) {
                        headImage = ImageUtils.createBufferedImageFromGLID(GLUtils.fboTextureID);
                    }
                } else if (model != null) {
                    headImage = this.createAutoIconViaEntityRenderer(en);
                }
            }
            catch (Exception var28) {
                headImage = null;
                var28.printStackTrace();
            }
        } else {
            headImage = this.createAutoIconViaEntityRenderer(en);
        }
        return headImage;
    }

    private boolean drawEntity(LivingEntity livingEntity) {
        boolean failed = false;
        float scale = livingEntity.func_213302_cg() > 2.5f ? 2.5f / livingEntity.func_213302_cg() : 1.0f;
        this.prepareDraw(scale, 1000);
        try {
            MatrixStack matrixStack = new MatrixStack();
            matrixStack.func_227860_a_();
            float h = (float)Math.atan(0.0);
            float l = (float)Math.atan(0.0);
            Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
            Quaternion quaternion2 = Vector3f.field_229179_b_.func_229187_a_(l * 20.0f);
            quaternion.func_195890_a(quaternion2);
            matrixStack.func_227863_a_(quaternion);
            float m = livingEntity.field_70761_aq;
            float n = livingEntity.field_70177_z;
            float o = livingEntity.field_70125_A;
            float p = livingEntity.field_70758_at;
            float q = livingEntity.field_70759_as;
            livingEntity.field_70761_aq = 180.0f + h * 20.0f;
            livingEntity.field_70177_z = 180.0f + h * 40.0f;
            livingEntity.field_70125_A = -l * 20.0f;
            livingEntity.field_70759_as = livingEntity.field_70177_z;
            livingEntity.field_70758_at = livingEntity.field_70177_z;
            EntityRendererManager entityRenderDispatcher = this.mc.func_175598_ae();
            quaternion2.func_195892_e();
            entityRenderDispatcher.func_229089_a_(quaternion2);
            entityRenderDispatcher.func_178633_a(false);
            IRenderTypeBuffer.Impl immediate = this.mc.func_228019_au_().func_228487_b_();
            entityRenderDispatcher.func_229084_a_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)immediate, 0xF000F0);
            immediate.func_228461_a_();
            matrixStack.func_227865_b_();
            entityRenderDispatcher.func_178633_a(true);
            livingEntity.field_70761_aq = m;
            livingEntity.field_70177_z = n;
            livingEntity.field_70125_A = o;
            livingEntity.field_70758_at = p;
            livingEntity.field_70759_as = q;
        }
        catch (Exception var19) {
            System.out.println("Error attempting to render entity:" + livingEntity.getClass().getSimpleName());
            var19.printStackTrace();
            failed = true;
        }
        this.postDraw();
        return !failed;
    }

    private void postDraw() {
        GLShim.glPopMatrix();
        GLShim.glTexEnvi(8960, 8704, 8448);
        GLShim.glEnable(2884);
        GLShim.glDisable(2929);
        GLShim.glDepthMask(false);
        GLUtils.unbindFrameBuffer();
        GLShim.glMatrixMode(5889);
        GLShim.glPopMatrix();
        GLShim.glMatrixMode(5888);
        GLShim.glPopMatrix();
        GLShim.glPopAttrib();
        GLShim.glViewport(0, 0, this.mc.func_228018_at_().func_198107_o(), this.mc.func_228018_at_().func_198087_p());
    }

    private void prepareDraw(float scale, int captureDepth) {
        float size = 64.0f * scale;
        GLUtils.setupFrameBuffer();
        GLShim.glBindTexture(3553, GLUtils.fboTextureID);
        int width = GLShim.glGetTexLevelParameteri(3553, 0, 4096);
        int height = GLShim.glGetTexLevelParameteri(3553, 0, 4097);
        GLShim.glBindTexture(3553, 0);
        GLShim.glPushAttrib(4096);
        GLShim.glViewport(0, 0, width, height);
        GLShim.glMatrixMode(5889);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glOrtho(0.0, width, height, 0.0, 1000.0, 3000.0);
        GLShim.glMatrixMode(5888);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glTranslatef(0.0f, 0.0f, -3000.0f + (float)captureDepth);
        GLUtils.bindFrameBuffer();
        GLShim.glDepthMask(true);
        GLShim.glEnable(2929);
        GLShim.glEnable(3553);
        GLShim.glEnable(3042);
        GLShim.glEnable(3008);
        GLShim.glEnable(2977);
        GLShim.glDisable(2884);
        GLShim.glTexEnvi(8960, 8704, 7681);
        GLShim.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        GLShim.glClear(16640);
        GLShim.glBlendFunc(770, 771);
        GLShim.glPushMatrix();
        GLShim.glTranslatef(width / 2, height / 2, 0.0f);
        GLShim.glScalef(size, size, size);
        GLShim.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
        GLShim.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
    }

    private boolean drawModel(float scale, int captureDepth, LivingEntity livingEntity, Direction facing, EntityModel model, ModelPartWithResourceLocation[] headBits) {
        boolean failed = false;
        this.prepareDraw(scale, captureDepth);
        if (model instanceof BipedModel) {
            GLShim.glRotatef(130.0f, 0.0f, 1.0f, 0.0f);
        }
        if (facing == Direction.EAST) {
            GLShim.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
        } else if (facing == Direction.UP) {
            GLShim.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        }
        try {
            int t;
            MatrixStack matrixStack = new MatrixStack();
            IRenderTypeBuffer.Impl immediate = this.mc.func_228019_au_().func_228487_b_();
            float offsetByY = model instanceof BipedModel ? 4.0f : 0.0f;
            float maxY = 0.0f;
            float minY = 0.0f;
            for (t = 0; t < headBits.length; ++t) {
                if (headBits[t].modelPart.field_78796_g < minY) {
                    minY = headBits[t].modelPart.field_78796_g;
                }
                if (!(headBits[t].modelPart.field_78796_g > maxY)) continue;
                maxY = headBits[t].modelPart.field_78796_g;
            }
            if (minY < -25.0f) {
                offsetByY = -25.0f - minY;
            } else if (maxY > 25.0f) {
                offsetByY = 25.0f - maxY;
            }
            for (t = 0; t < headBits.length; ++t) {
                IVertexBuilder vertexConsumer = immediate.getBuffer(model.func_228282_a_(headBits[t].resourceLocation));
                try {
                    model.func_225597_a_((Entity)livingEntity, 0.0f, 0.0f, 163.0f, 360.0f, 0.0f);
                }
                catch (NullPointerException ex) {
                    System.out.println(livingEntity.func_200600_R().getRegistryName() + ":NullPointerException at setupAnim method!");
                }
                float y = headBits[t].modelPart.field_78796_g;
                headBits[t].modelPart.field_78796_g += offsetByY;
                headBits[t].modelPart.func_228308_a_(matrixStack, vertexConsumer, 0xF000F0, OverlayTexture.field_229196_a_);
                headBits[t].modelPart.field_78796_g = y;
                immediate.func_228461_a_();
            }
        }
        catch (Exception var19) {
            System.out.println("Error attempting to render head bits for " + livingEntity.getClass().getSimpleName());
            var19.printStackTrace();
            failed = true;
        }
        this.postDraw();
        return !failed;
    }

    private class ModelPartWithResourceLocation {
        ModelRenderer modelPart;
        ResourceLocation resourceLocation;

        public ModelPartWithResourceLocation(ModelRenderer modelPart, ResourceLocation resourceLocation) {
            this.modelPart = modelPart;
            this.resourceLocation = resourceLocation;
        }
    }

    private class QueuedEntity {
        Entity entity;
        ResourceLocation resourceLocation;

        QueuedEntity(Entity en, ResourceLocation loc) {
            this.entity = en;
            this.resourceLocation = loc;
        }
    }
}

