/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.gui.renderers.CompassRenderer;
import dlovin.advancedcompass.gui.renderers.EntitiesRenderer;
import dlovin.advancedcompass.gui.renderers.IRenderer;
import dlovin.advancedcompass.gui.renderers.WaypointRenderer;
import dlovin.advancedcompass.utils.InventoryUtils;
import dlovin.advancedcompass.utils.SettingsValues;
import dlovin.advancedcompass.utils.enums.CoordinatesMode;
import dlovin.advancedcompass.utils.enums.ShowMode;
import dlovin.advancedcompass.utils.waypoints.Waypoint;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CompassGui
extends IngameGui {
    private final ResourceLocation COMPASS_TOP = new ResourceLocation("advancedcompass", "textures/gui/compass_top.png");
    private final ResourceLocation COMPASS_MID = new ResourceLocation("advancedcompass", "textures/gui/compass_mid.png");
    private final ResourceLocation COMPASS_BOT = new ResourceLocation("advancedcompass", "textures/gui/compass_bot.png");
    public SettingsValues settings;
    private CompassRenderer compassRenderer;
    private EntitiesRenderer entitiesRenderer;
    private WaypointRenderer waypointRenderer;
    private Collection<IRenderer> renderers = new ArrayList<IRenderer>();
    private float coordinatesScale;
    private int coordinatesOffset;
    private int compassOffset;
    private int coordinatesHeight;
    private int bossOffset;

    public CompassGui() {
        super(Minecraft.func_71410_x());
        this.settings = new SettingsValues();
        this.settings.yOffset = (Integer)AdvancedCompass.getClient().yOffset.get();
        this.settings.maxDistance = (Integer)AdvancedCompass.getClient().maxDistance.get();
        this.settings.groupRadius = (Integer)AdvancedCompass.getClient().groupRadius.get();
        this.settings.moveBossbar = (Boolean)AdvancedCompass.getClient().moveBossbar.get();
        this.settings.groupEntities = (Boolean)AdvancedCompass.getClient().groupEntities.get();
        this.settings.showDistance = (Boolean)AdvancedCompass.getClient().showDistance.get();
        this.settings.showPlayers = (Boolean)AdvancedCompass.getClient().showDistance.get();
        this.settings.setViewAngle((Integer)AdvancedCompass.getClient().viewAngle.get());
        this.settings.angleThreshold = (Integer)AdvancedCompass.getClient().angleThreshold.get();
        this.settings.hideOverlapped = (Boolean)AdvancedCompass.getClient().hideOverlapped.get();
        this.settings.overlapThreshold = (Integer)AdvancedCompass.getClient().overlapThreshold.get();
        this.settings.autoDeathWaypoint = (Boolean)AdvancedCompass.getClient().autoDeathWaypoint.get();
        this.settings.showMode = (ShowMode)((Object)AdvancedCompass.getClient().showMode.get());
        this.settings.compassWidth = (Integer)AdvancedCompass.getClient().compassWidth.get();
        this.settings.compassHeight = (Integer)AdvancedCompass.getClient().compassHeight.get();
        this.settings.iconScale = (Integer)AdvancedCompass.getClient().iconScale.get();
        this.settings.coordinatesScale = (Integer)AdvancedCompass.getClient().coordinatesScale.get();
        this.coordinatesScale = (float)this.settings.coordinatesScale / 100.0f;
        this.setCoordinatesMode((CoordinatesMode)((Object)AdvancedCompass.getClient().coordinatesMode.get()));
        this.compassRenderer = new CompassRenderer(Minecraft.func_71410_x(), this.func_175179_f(), this.settings);
        this.renderers.add(this.compassRenderer);
        this.entitiesRenderer = new EntitiesRenderer(Minecraft.func_71410_x(), this.func_175179_f(), this.settings);
        this.renderers.add(this.entitiesRenderer);
        this.waypointRenderer = new WaypointRenderer(Minecraft.func_71410_x(), this.func_175179_f(), this.settings);
        this.renderers.add(this.waypointRenderer);
    }

    public void setIconScale(int scale) {
        this.settings.iconScale = scale;
        this.recalculateCoords();
        this.renderers.forEach(r -> r.setIconScale(scale));
    }

    public void setCoordinatesMode(CoordinatesMode mode) {
        this.settings.coordinatesMode = mode;
        this.recalculateCoords();
    }

    public void setCoordinatesScale(int scale) {
        this.settings.coordinatesScale = scale;
        this.coordinatesScale = (float)this.settings.coordinatesScale / 100.0f;
        this.recalculateCoords();
    }

    public void setCompassHeight(int height) {
        this.settings.compassHeight = height;
        this.recalculateCoords();
    }

    private void recalculateCoords() {
        if (this.settings.coordinatesMode.equals((Object)CoordinatesMode.ABOVE)) {
            this.coordinatesOffset = 0;
            this.compassOffset = (int)(10.0f * this.coordinatesScale);
            int iconheight = (int)((float)(9 * this.settings.iconScale) / 100.0f);
            if (this.settings.compassHeight / 2 < iconheight) {
                this.compassOffset += iconheight - this.settings.compassHeight / 2;
            }
            iconheight = (int)((float)(22 * this.settings.iconScale) / 100.0f);
            this.bossOffset = this.compassOffset + this.settings.compassHeight;
            if (this.bossOffset < this.compassOffset + this.settings.compassHeight / 2 + iconheight / 2) {
                this.bossOffset = this.compassOffset + this.settings.compassHeight / 2 + iconheight / 2;
            }
            this.coordinatesHeight = 0;
        } else if (this.settings.coordinatesMode.equals((Object)CoordinatesMode.BELOW)) {
            int iconheight = (int)((float)(10 * this.settings.iconScale) / 100.0f);
            this.compassOffset = this.settings.compassHeight / 2 < iconheight ? iconheight - this.settings.compassHeight / 2 : 0;
            iconheight = (int)(22.0f * ((float)this.settings.iconScale / 100.0f));
            this.coordinatesOffset = this.settings.compassHeight + 2;
            if (this.coordinatesOffset < this.compassOffset + this.settings.compassHeight / 2 + iconheight / 2) {
                this.coordinatesOffset = this.compassOffset + this.settings.compassHeight / 2 + iconheight / 2 + 2;
            }
            this.coordinatesHeight = (int)(8.0f * this.coordinatesScale);
            this.bossOffset = this.coordinatesOffset + this.coordinatesHeight;
        } else {
            this.coordinatesOffset = 0;
            int iconheight = (int)((float)(10 * this.settings.iconScale) / 100.0f);
            this.compassOffset = this.settings.compassHeight / 2 < iconheight ? iconheight - this.settings.compassHeight / 2 : 0;
            this.coordinatesHeight = 0;
            iconheight = (int)((float)(22 * this.settings.iconScale) / 100.0f);
            this.bossOffset = this.settings.compassHeight;
            if (this.settings.compassHeight < this.compassOffset + this.settings.compassHeight / 2 + iconheight / 2) {
                this.bossOffset = this.compassOffset + this.settings.compassHeight / 2 + iconheight / 2;
            }
        }
    }

    @SubscribeEvent
    public void onRenderPost(RenderGameOverlayEvent.Post event) {
        if (!event.getType().equals((Object)RenderGameOverlayEvent.ElementType.BOSSHEALTH)) {
            return;
        }
        if (this.settings.showMode.equals((Object)ShowMode.OFF)) {
            return;
        }
        if (!this.settings.showMode.equals((Object)ShowMode.ALWAYS_ON)) {
            if (this.settings.showMode.equals((Object)ShowMode.MAIN_HAND) && !InventoryUtils.isCompass(this.field_73839_d.field_71439_g.func_184614_ca())) {
                return;
            }
            if (this.settings.showMode.equals((Object)ShowMode.BOTH_HANDS) && !InventoryUtils.hasCompass(this.field_73839_d.field_71439_g.func_184214_aD())) {
                return;
            }
            if (this.settings.showMode.equals((Object)ShowMode.ANY_SLOT) && !InventoryUtils.hasCompass(new Iterable[]{this.field_73839_d.field_71439_g.field_71071_by.field_70462_a, this.field_73839_d.field_71439_g.field_71071_by.field_70460_b, this.field_73839_d.field_71439_g.field_71071_by.field_184439_c})) {
                return;
            }
        }
        if (this.settings.moveBossbar) {
            RenderSystem.translated((double)0.0, (double)(-this.bossOffset - this.settings.yOffset), (double)0.0);
            RenderSystem.popMatrix();
        }
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Pre event) {
        if (!event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL) && !event.getType().equals((Object)RenderGameOverlayEvent.ElementType.BOSSHEALTH)) {
            return;
        }
        if (this.settings.showMode.equals((Object)ShowMode.OFF)) {
            return;
        }
        if (!this.settings.showMode.equals((Object)ShowMode.ALWAYS_ON)) {
            if (this.settings.showMode.equals((Object)ShowMode.MAIN_HAND) && !InventoryUtils.isCompass(this.field_73839_d.field_71439_g.func_184614_ca())) {
                return;
            }
            if (this.settings.showMode.equals((Object)ShowMode.BOTH_HANDS) && !InventoryUtils.hasCompass(this.field_73839_d.field_71439_g.func_184214_aD())) {
                return;
            }
            if (this.settings.showMode.equals((Object)ShowMode.ANY_SLOT) && !InventoryUtils.hasCompass(new Iterable[]{this.field_73839_d.field_71439_g.field_71071_by.field_70462_a, this.field_73839_d.field_71439_g.field_71071_by.field_70460_b, this.field_73839_d.field_71439_g.field_71071_by.field_184439_c})) {
                return;
            }
        }
        if (this.settings.moveBossbar && event.getType().equals((Object)RenderGameOverlayEvent.ElementType.BOSSHEALTH)) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)0.0, (double)(this.bossOffset + this.settings.yOffset), (double)0.0);
            return;
        }
        MatrixStack mat = event.getMatrixStack();
        int width = this.field_73839_d.func_228018_at_().func_198107_o();
        float scale = this.getScale(width, this.settings.compassWidth);
        float angle = -MathHelper.func_76142_g((float)this.field_73839_d.field_71439_g.func_195046_g(event.getPartialTicks()));
        RenderSystem.pushMatrix();
        RenderSystem.enableAlphaTest();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)(this.compassOffset + this.settings.yOffset), (double)-1.0);
        this.field_73839_d.func_110434_K().func_110577_a(this.COMPASS_TOP);
        CompassGui.func_238463_a_((MatrixStack)mat, (int)((int)((float)(width / 2) - (float)(this.settings.compassWidth / 2) * scale)), (int)0, (float)0.0f, (float)0.0f, (int)((int)((float)this.settings.compassWidth * scale)), (int)((int)(3.0f * scale)), (int)((int)((float)this.settings.compassWidth * scale)), (int)((int)(3.0f * scale)));
        this.field_73839_d.func_110434_K().func_110577_a(this.COMPASS_MID);
        CompassGui.func_238463_a_((MatrixStack)mat, (int)((int)((float)(width / 2) - (float)(this.settings.compassWidth / 2) * scale)), (int)((int)(scale * 3.0f)), (float)0.0f, (float)0.0f, (int)((int)((float)this.settings.compassWidth * scale)), (int)((int)((float)(this.settings.compassHeight - 6) * scale)), (int)((int)((float)this.settings.compassWidth * scale)), (int)((int)((float)(this.settings.compassHeight - 6) * scale)));
        this.field_73839_d.func_110434_K().func_110577_a(this.COMPASS_BOT);
        CompassGui.func_238463_a_((MatrixStack)mat, (int)((int)((float)(width / 2) - (float)(this.settings.compassWidth / 2) * scale)), (int)((int)((float)(this.settings.compassHeight - 3) * scale)), (float)0.0f, (float)0.0f, (int)((int)((float)this.settings.compassWidth * scale)), (int)((int)(3.0f * scale)), (int)((int)((float)this.settings.compassWidth * scale)), (int)((int)(3.0f * scale)));
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.translated((double)(width / 2), (double)0.0, (double)1.0);
        this.compassRenderer.render(mat, angle, scale);
        this.entitiesRenderer.render(mat, angle, scale);
        this.waypointRenderer.render(mat, angle, scale);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
        RenderSystem.popMatrix();
        if (!this.settings.coordinatesMode.equals((Object)CoordinatesMode.OFF)) {
            RenderSystem.pushMatrix();
            Vector3d pos = this.field_73839_d.field_71439_g.func_213303_ch();
            String coords = String.format("%.1f  %.0f  %.1f", pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            RenderSystem.translated((double)(width / 2), (double)(this.coordinatesOffset + this.settings.yOffset), (double)0.0);
            RenderSystem.scalef((float)this.coordinatesScale, (float)this.coordinatesScale, (float)this.coordinatesScale);
            this.func_175179_f().func_238405_a_(mat, coords, (float)(-this.func_175179_f().func_78256_a(coords) / 2), 0.0f, -1);
            RenderSystem.popMatrix();
        }
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.popMatrix();
    }

    private float getScale(int width, int w) {
        if (width < w) {
            return (float)width / (float)w;
        }
        return 1.0f;
    }

    public void removeWaypointByName(String name) {
        this.waypointRenderer.removeWaypointByName(name);
    }

    public void addWaypoint(Waypoint waypoint) {
        this.waypointRenderer.addWaypoint(waypoint);
    }

    public void setWaypoints(Collection waypoints) {
        this.waypointRenderer.setWaypoints(waypoints);
    }

    public void removeWaypoint(Waypoint w) {
        this.waypointRenderer.removeWaypoint(w);
    }

    public void changeWaypoint(Waypoint w) {
        this.waypointRenderer.changeWaypoint(w);
    }
}

