/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.config;

import dlovin.advancedcompass.gui.config.ConfigScreen;
import dlovin.advancedcompass.gui.config.widgets.CustomButton;
import dlovin.advancedcompass.gui.config.widgets.EntityCheckBox;
import dlovin.advancedcompass.gui.config.widgets.TextWidget;
import dlovin.advancedcompass.gui.config.widgets.Widget;
import dlovin.advancedcompass.references.Translation;
import dlovin.advancedcompass.utils.GroupUtils;
import dlovin.advancedcompass.utils.HeadUtils;
import dlovin.advancedcompass.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.EntityType;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.screen.ModListScreen;

public class EntityListConfigScreen
extends ConfigScreen {
    public EntityListConfigScreen(boolean inGame) {
        super(1, inGame);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        int i = 0;
        HashMap mobs = new HashMap();
        for (Map.Entry entry : HeadUtils.heads.entrySet().stream().sorted(Comparator.comparing(w -> ((EntityType)w.getKey()).func_212546_e().getString())).collect(Collectors.toList())) {
            if (mobs.get(((EntityType)entry.getKey()).getRegistryName().func_110624_b()) == null) {
                ArrayList newList = new ArrayList();
                newList.add(entry.getKey());
                mobs.put(((EntityType)entry.getKey()).getRegistryName().func_110624_b(), newList);
                continue;
            }
            ((List)mobs.get(((EntityType)entry.getKey()).getRegistryName().func_110624_b())).add(entry.getKey());
        }
        for (Map.Entry entry : mobs.entrySet()) {
            this.OptionList.addWidget(new TextWidget(this.field_230708_k_ / 2 - 10, 10, 0xFFFFFF, TextWidget.TextAlign.CENTER, new TranslationTextComponent((String)entry.getKey()).getString(), this.field_230712_o_), i++);
            for (EntityType type : (List)entry.getValue()) {
                this.OptionList.addWidget(new TextWidget(this.field_230708_k_ / 2 - 10, 10, 0xFFFFFF, TextWidget.TextAlign.RIGHT, type.func_212546_e().getString() + ":", this.field_230712_o_), i);
                this.OptionList.addWidget(new EntityCheckBox(this.field_230708_k_ / 2 + 10, 0, 20, 20, w -> this.changeType(w), GroupUtils.types.contains(type), type), i++);
            }
        }
        int n = this.field_230712_o_.func_78256_a(Translation.HIDEALL.getString());
        CustomButton tmp = new CustomButton(this.field_230708_k_ / 2 - 15 - n, this.field_230709_l_ - 25, n + 10, 20, Translation.HIDEALL.getString(), null, false);
        this.widgetList.add(tmp);
        tmp.addListener(() -> this.HideAll());
        this.field_230705_e_.add(tmp);
        int n2 = this.field_230712_o_.func_78256_a(Translation.SHOWALL.getString());
        tmp = new CustomButton(this.field_230708_k_ / 2 + 5, this.field_230709_l_ - 25, n2 + 10, 20, Translation.SHOWALL.getString(), null, false);
        this.widgetList.add(tmp);
        tmp.addListener(() -> this.ShowAll());
        this.field_230705_e_.add(tmp);
    }

    private void HideAll() {
        for (Widget w : this.OptionList.getWidgets()) {
            if (!(w instanceof EntityCheckBox)) continue;
            ((EntityCheckBox)w).checked = false;
            this.changeType((EntityCheckBox)w);
        }
    }

    private void ShowAll() {
        for (Widget w : this.OptionList.getWidgets()) {
            if (!(w instanceof EntityCheckBox)) continue;
            ((EntityCheckBox)w).checked = true;
            this.changeType((EntityCheckBox)w);
        }
    }

    private void changeType(EntityCheckBox w) {
        if (w.checked) {
            if (!GroupUtils.types.contains(w.getType())) {
                GroupUtils.types.add(w.getType());
            }
        } else {
            GroupUtils.types.remove(w.getType());
        }
    }

    @Override
    public void changeScreen(Screen screen) {
        JsonUtils.saveMobs();
        this.field_230706_i_.func_147108_a(screen);
    }

    @Override
    public void func_231175_as__() {
        JsonUtils.saveMobs();
        if (!this.inGame) {
            this.field_230706_i_.func_147108_a((Screen)new ModListScreen(null));
        } else {
            this.field_230706_i_.func_147108_a(null);
        }
    }
}

