/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.config;

import com.mojang.blaze3d.matrix.MatrixStack;
import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.gui.config.WaypointListGui;
import dlovin.advancedcompass.gui.config.widgets.ButtonWidget;
import dlovin.advancedcompass.gui.config.widgets.CheckBox;
import dlovin.advancedcompass.gui.config.widgets.ColorPicker;
import dlovin.advancedcompass.gui.config.widgets.MultiImageWidget;
import dlovin.advancedcompass.gui.config.widgets.NumericTextField;
import dlovin.advancedcompass.gui.config.widgets.TextField;
import dlovin.advancedcompass.gui.config.widgets.TextWidget;
import dlovin.advancedcompass.gui.config.widgets.Widget;
import dlovin.advancedcompass.references.Translation;
import dlovin.advancedcompass.utils.Color;
import dlovin.advancedcompass.utils.StringUtils;
import dlovin.advancedcompass.utils.waypoints.Waypoint;
import dlovin.advancedcompass.utils.waypoints.WaypointIcon;
import dlovin.advancedcompass.utils.waypoints.WaypointJsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.storage.ServerWorldInfo;

public class WaypointAddGui
extends Screen {
    private boolean fromList = false;
    Collection<Widget> widgets;
    MultiImageWidget iconWidget;
    ColorPicker pickerWidget;
    TextField nameWidget;
    NumericTextField[] positionWidgets;
    NumericTextField[] distanceWidgets;
    CheckBox enableWidget;
    Waypoint waypoint;
    TextWidget[] resultString;
    boolean force = false;

    public WaypointAddGui(Waypoint waypoint) {
        super((ITextComponent)new StringTextComponent(""));
        this.waypoint = waypoint;
    }

    public WaypointAddGui() {
        this(new Waypoint("Name", Minecraft.func_71410_x().field_71439_g.func_213303_ch(), Minecraft.func_71410_x().field_71439_g.field_213837_d.func_234923_W_().func_240901_a_().toString(), WaypointIcon.HOME, new Color(1.0f, 1.0f, 1.0f), 0, 0, true));
    }

    public WaypointAddGui(boolean fromlist) {
        this();
        this.fromList = fromlist;
    }

    public void func_231160_c_() {
        this.force = false;
        this.widgets = new ArrayList<Widget>();
        this.iconWidget = new MultiImageWidget(this.field_230708_k_ / 2 - 16, this.field_230709_l_ / 2 - 95, 32, 32, new ResourceLocation("advancedcompass", "textures/waypoints.png"), this.waypoint.getColor(), this.waypoint.getIcon().ordinal());
        this.widgets.add(this.iconWidget);
        this.iconWidget.setupArray(4, 4, 16);
        this.iconWidget.setupImages(128, 128, 32, 32);
        ButtonWidget tmpBtn = new ButtonWidget(this.field_230708_k_ / 2 - 41, this.field_230709_l_ / 2 - 87, 16, 16, "<");
        this.widgets.add(tmpBtn);
        tmpBtn.addListener(() -> this.changeIcon(this.iconWidget, -1));
        tmpBtn = new ButtonWidget(this.field_230708_k_ / 2 + 25, this.field_230709_l_ / 2 - 87, 16, 16, ">");
        this.widgets.add(tmpBtn);
        tmpBtn.addListener(() -> this.changeIcon(this.iconWidget, 1));
        this.widgets.add(new TextWidget(this.field_230708_k_ / 2 - 110, this.field_230709_l_ / 2 - 39, -1, TextWidget.TextAlign.LEFT, Translation.WPNAME.getString(), this.field_230712_o_));
        this.nameWidget = new TextField(this.field_230712_o_, this.field_230708_k_ / 2 - 40, this.field_230709_l_ / 2 - 49, 140, 20, this.waypoint.getName(), this::onNameChanged);
        this.widgets.add(this.nameWidget);
        this.nameWidget.setMaxStringLength(25);
        this.positionWidgets = new NumericTextField[3];
        this.widgets.add(new TextWidget(this.field_230708_k_ / 2 - 110, this.field_230709_l_ / 2 - 13, -1, TextWidget.TextAlign.LEFT, Translation.WPPOS.getString(), this.field_230712_o_));
        this.positionWidgets[0] = new NumericTextField(this.field_230712_o_, this.field_230708_k_ / 2 - 40, this.field_230709_l_ / 2 - 23, 40, 20, (int)this.waypoint.getPosition().field_72450_a, w -> this.onPositionChanged(w, this.positionWidgets[1], this.positionWidgets[2]));
        this.widgets.add(this.positionWidgets[0]);
        this.positionWidgets[1] = new NumericTextField(this.field_230712_o_, this.field_230708_k_ / 2 + 10, this.field_230709_l_ / 2 - 23, 40, 20, (int)this.waypoint.getPosition().field_72448_b, w -> this.onPositionChanged(this.positionWidgets[0], w, this.positionWidgets[2]));
        this.widgets.add(this.positionWidgets[1]);
        this.positionWidgets[2] = new NumericTextField(this.field_230712_o_, this.field_230708_k_ / 2 + 60, this.field_230709_l_ / 2 - 23, 40, 20, (int)this.waypoint.getPosition().field_72449_c, w -> this.onPositionChanged(this.positionWidgets[0], this.positionWidgets[1], w));
        this.widgets.add(this.positionWidgets[2]);
        this.distanceWidgets = new NumericTextField[2];
        this.widgets.add(new TextWidget(this.field_230708_k_ / 2 - 110, this.field_230709_l_ / 2 + 13, -1, TextWidget.TextAlign.LEFT, Translation.WPDISTANCE.getString(), this.field_230712_o_, (w, m, x, y) -> this.func_238652_a_(m, Translation.WPDISTANCE_TT, x, y)));
        this.widgets.add(new TextWidget(this.field_230708_k_ / 2 - 40, this.field_230709_l_ / 2 + 13, -1, TextWidget.TextAlign.LEFT, Translation.WPDISTANCE_MIN.getString(), this.field_230712_o_));
        this.widgets.add(new TextWidget(this.field_230708_k_ / 2 + 35, this.field_230709_l_ / 2 + 13, -1, TextWidget.TextAlign.LEFT, Translation.WPDISTANCE_MAX.getString(), this.field_230712_o_));
        this.distanceWidgets[0] = new NumericTextField(this.field_230712_o_, this.field_230708_k_ / 2 - 15, this.field_230709_l_ / 2 + 3, 40, 20, this.waypoint.getMinDistance(), this::onMinDistanceChanged);
        this.widgets.add(this.distanceWidgets[0]);
        this.distanceWidgets[1] = new NumericTextField(this.field_230712_o_, this.field_230708_k_ / 2 + 60, this.field_230709_l_ / 2 + 3, 40, 20, this.waypoint.getMaxDistance(), this::onMaxDistanceChanged);
        this.widgets.add(this.distanceWidgets[1]);
        this.widgets.add(new TextWidget(this.field_230708_k_ / 2 - 110, this.field_230709_l_ / 2 + 39, -1, TextWidget.TextAlign.LEFT, Translation.WPCOLOR.getString(), this.field_230712_o_));
        this.pickerWidget = new ColorPicker(this.field_230708_k_ / 2 - 40, this.field_230709_l_ / 2 + 29, 30, 20, this.waypoint.getColor());
        this.pickerWidget.addListener(() -> this.onColorChanged(this.iconWidget, this.pickerWidget.getColor()));
        this.widgets.add(new TextWidget(this.field_230708_k_ / 2 + 30, this.field_230709_l_ / 2 + 39, -1, TextWidget.TextAlign.LEFT, Translation.WPENABLED.getString(), this.field_230712_o_));
        this.enableWidget = new CheckBox(this.field_230708_k_ / 2 + 80, this.field_230709_l_ / 2 + 29, 20, 20, this::onEnabledChanged, this.waypoint.isEnabled());
        this.widgets.add(this.enableWidget);
        this.resultString = new TextWidget[2];
        this.resultString[0] = new TextWidget(this.field_230708_k_ / 2, this.field_230709_l_ / 2 + 65, 0xFFFFFF, TextWidget.TextAlign.CENTER, "", this.field_230712_o_);
        this.widgets.add(this.resultString[0]);
        this.resultString[1] = new TextWidget(this.field_230708_k_ / 2, this.field_230709_l_ / 2 + 75, 0xFFFFFF, TextWidget.TextAlign.CENTER, "", this.field_230712_o_);
        this.widgets.add(this.resultString[1]);
        tmpBtn = new ButtonWidget(this.field_230708_k_ / 2 - 110, this.field_230709_l_ / 2 + 100, 60, 20, Translation.WPCANCEL.getString());
        this.widgets.add(tmpBtn);
        tmpBtn.addListener(this::onCancel);
        tmpBtn = new ButtonWidget(this.field_230708_k_ / 2 - 40, this.field_230709_l_ / 2 + 100, 80, 20, Translation.WPLIST.getString());
        this.widgets.add(tmpBtn);
        tmpBtn.addListener(this::onList);
        tmpBtn = new ButtonWidget(this.field_230708_k_ / 2 + 50, this.field_230709_l_ / 2 + 100, 60, 20, Translation.WPSAVE.getString());
        this.widgets.add(tmpBtn);
        tmpBtn.addListener(this::onSave);
        this.field_230705_e_.addAll(this.widgets);
        this.field_230705_e_.add(this.pickerWidget);
    }

    private void onList() {
        this.field_230706_i_.func_147108_a((Screen)new WaypointListGui());
    }

    private void onColorChanged(MultiImageWidget tmpImage, Color color) {
        tmpImage.setColor(color);
        this.waypoint.setColor(color);
    }

    private void changeIcon(MultiImageWidget tmpImage, int i) {
        tmpImage.next(i);
        this.waypoint.setIcon(tmpImage.getIndex());
    }

    void onSave() {
        String dir = this.field_230706_i_.func_147104_D() != null ? StringUtils.trimPort(this.field_230706_i_.func_147104_D().field_78845_b) : StringUtils.removeIllegal(((ServerWorldInfo)this.field_230706_i_.func_71401_C().func_241755_D_().func_72912_H()).func_76065_j());
        Object[] result = WaypointJsonUtils.addWaypoint(dir, this.waypoint, this.force);
        this.force = false;
        if (((Boolean)result[0]).booleanValue()) {
            AdvancedCompass.getInstance().getCompassGui().addWaypoint(new Waypoint(this.waypoint));
            this.resultString[0].setColor(0xFFFFFF);
            this.resultString[1].setColor(0xFFFFFF);
            this.field_230706_i_.func_147108_a(null);
        } else if (((String)result[1]).equals(Translation.WAYPOINT_EMPTY_NAME.getString())) {
            this.resultString[0].setColor(0xFF0000);
            this.resultString[1].setColor(0xFF0000);
        } else if (((String)result[1]).equals(Translation.WAYPOINT_EXISTS_1.getString())) {
            this.resultString[0].setColor(0xFF8000);
            this.resultString[1].setColor(0xFF8000);
            this.force = true;
        }
        this.resultString[0].setText((String)result[1]);
        this.resultString[1].setText((String)result[2]);
    }

    void onCancel() {
        this.func_231175_as__();
    }

    public void func_231175_as__() {
        if (this.fromList) {
            this.field_230706_i_.func_147108_a((Screen)new WaypointListGui());
        } else {
            this.field_230706_i_.func_147108_a(null);
        }
    }

    private void onEnabledChanged(CheckBox checkBox) {
        this.waypoint.setEnabled(checkBox.checked);
    }

    private void onMinDistanceChanged(TextField textField) {
        this.waypoint.setMinDistance(((NumericTextField)textField).getValue());
    }

    private void onMaxDistanceChanged(TextField textField) {
        this.waypoint.setMaxDistance(((NumericTextField)textField).getValue());
    }

    private void onNameChanged(TextField textField) {
        this.force = false;
        this.resultString[0].setText("");
        this.resultString[1].setText("");
        this.waypoint.setName(textField.getText());
    }

    private void onPositionChanged(TextField fieldX, TextField fieldY, TextField fieldZ) {
        this.waypoint.setPosition(new Vector3d((double)((NumericTextField)fieldX).getValue(), (double)((NumericTextField)fieldY).getValue(), (double)((NumericTextField)fieldZ).getValue()));
    }

    public void func_230430_a_(MatrixStack mat, int mouseX, int mouseY, float partialTicks) {
        super.func_230446_a_(mat);
        this.widgets.forEach(w -> w.func_230430_a_(mat, mouseX, mouseY, partialTicks));
        this.widgets.forEach(w -> w.renderTooltip(mat, mouseX, mouseY));
        this.pickerWidget.func_230430_a_(mat, mouseX, mouseY, partialTicks);
    }

    public boolean func_231044_a_(double mx, double my, int b) {
        if (this.pickerWidget.func_231044_a_(mx, my, b)) {
            return true;
        }
        this.widgets.forEach(w -> w.func_231044_a_(mx, my, b));
        return false;
    }

    public boolean func_231042_a_(char p_231042_1_, int p_231042_2_) {
        for (Widget w : this.widgets) {
            if (!(w instanceof TextField) || !((TextField)w).isFocused()) continue;
            w.func_231042_a_(p_231042_1_, p_231042_2_);
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        for (Widget w : this.widgets) {
            if (!(w instanceof TextField) || !((TextField)w).isFocused()) continue;
            w.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
            return true;
        }
        return super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
    }
}

