/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.config;

import com.mojang.blaze3d.matrix.MatrixStack;
import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.gui.config.WaypointAddGui;
import dlovin.advancedcompass.gui.config.WaypointEditGui;
import dlovin.advancedcompass.gui.config.widgets.CheckBox;
import dlovin.advancedcompass.gui.config.widgets.ConfirmButton;
import dlovin.advancedcompass.gui.config.widgets.CustomButton;
import dlovin.advancedcompass.gui.config.widgets.CustomOptionList;
import dlovin.advancedcompass.gui.config.widgets.TextWidget;
import dlovin.advancedcompass.gui.config.widgets.Widget;
import dlovin.advancedcompass.references.Translation;
import dlovin.advancedcompass.utils.StringUtils;
import dlovin.advancedcompass.utils.waypoints.Waypoint;
import dlovin.advancedcompass.utils.waypoints.WaypointJsonUtils;
import dlovin.advancedcompass.utils.waypoints.WaypointUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.storage.ServerWorldInfo;

public class WaypointListGui
extends Screen {
    CustomOptionList optionList;
    List<Widget> widgetList;
    String dir;

    public WaypointListGui() {
        super((ITextComponent)new StringTextComponent("Waypoint list"));
    }

    public void func_231160_c_() {
        this.optionList = new CustomOptionList(this.field_230706_i_, 30, 40, 24, this);
        this.dir = this.field_230706_i_.func_147104_D() != null ? StringUtils.trimPort(this.field_230706_i_.func_147104_D().field_78845_b) : StringUtils.removeIllegal(((ServerWorldInfo)this.field_230706_i_.func_71401_C().func_241755_D_().func_72912_H()).func_76065_j());
        Collection<Waypoint> waypoints = WaypointJsonUtils.getWaypoints(this.dir);
        String[] dimensions = WaypointUtils.getAllDimensions(waypoints);
        int index = 0;
        for (int i = 0; i < dimensions.length; ++i) {
            Collection<Waypoint> tmpList = WaypointUtils.getWaypointsInDimension(dimensions[i], waypoints);
            String[] dim = dimensions[i].split(":");
            String dimension = String.format("(%s) %s:", StringUtils.capitalize(dim[0]), StringUtils.capitalize(dim[dim.length - 1]));
            this.optionList.addWidget(new TextWidget(this.field_230708_k_ / 2, 10, 0xFFFFFF, TextWidget.TextAlign.CENTER, dimension, this.field_230712_o_), index++);
            for (Waypoint w : tmpList) {
                CustomButton tmp = new CustomButton(this.field_230708_k_ / 2 + 10, 2, 16, 16, 16, "", new ResourceLocation("advancedcompass", "textures/gui/widgets/settings_btn.png"), false);
                this.optionList.addWidget(tmp, index);
                tmp.addListener(() -> this.changeWaypoint(w));
                tmp = new ConfirmButton(this.field_230708_k_ / 2 + 36, 2, 16, 16, 16, "", new ResourceLocation("advancedcompass", "textures/gui/widgets/delete_btn.png"), new Widget.ITooltip[]{(wi, m, x, y) -> this.func_238652_a_(m, Translation.DELETE_BTN, x, y), (wi, m, x, y) -> this.func_238652_a_(m, Translation.CONFIRM_BTN, x, y)});
                this.optionList.addWidget(tmp, index);
                int finalIndex = index;
                tmp.addListener(() -> this.deleteWaypoint(finalIndex, w, this.dir));
                this.optionList.addWidget(new CheckBox(this.field_230708_k_ / 2 + 62, 0, 20, 20, t -> this.changeEnabled(t, w), w.isEnabled()), index);
                this.optionList.addWidget(new TextWidget(this.field_230708_k_ / 2 - 10, 10, 0xFFFFFF, TextWidget.TextAlign.RIGHT, w.getName(), this.field_230712_o_), index++);
            }
        }
        this.widgetList = new ArrayList<Widget>();
        CustomButton tmp = new CustomButton(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 30, 60, 20, Translation.HIDEALL.getString(), null, false);
        this.widgetList.add(tmp);
        tmp.addListener(() -> this.HideAll());
        this.field_230705_e_.add(tmp);
        tmp = new CustomButton(this.field_230708_k_ / 2 - 30, this.field_230709_l_ - 30, 60, 20, Translation.ADDNEW.getString(), null, false);
        this.widgetList.add(tmp);
        tmp.addListener(() -> this.addNew());
        this.field_230705_e_.add(tmp);
        tmp = new CustomButton(this.field_230708_k_ / 2 + 40, this.field_230709_l_ - 30, 60, 20, Translation.SHOWALL.getString(), null, false);
        this.widgetList.add(tmp);
        tmp.addListener(() -> this.ShowAll());
        this.field_230705_e_.add(tmp);
        this.field_230705_e_.add(this.optionList);
    }

    private void ShowAll() {
        for (Widget w : this.optionList.getWidgets()) {
            if (!(w instanceof CheckBox) || ((CheckBox)w).checked) continue;
            ((CheckBox)w).checked = true;
            ((CheckBox)w).onChanged();
        }
    }

    private void addNew() {
        this.field_230706_i_.func_147108_a((Screen)new WaypointAddGui(true));
    }

    private void HideAll() {
        for (Widget w : this.optionList.getWidgets()) {
            if (!(w instanceof CheckBox) || !((CheckBox)w).checked) continue;
            ((CheckBox)w).checked = false;
            ((CheckBox)w).onChanged();
        }
    }

    private void deleteWaypoint(int r, Waypoint w, String dir) {
        this.optionList.removeRow(r);
        WaypointJsonUtils.deleteWaypoint(dir, w);
        AdvancedCompass.getInstance().getCompassGui().removeWaypoint(w);
    }

    private void changeWaypoint(Waypoint w) {
        this.field_230706_i_.func_147108_a((Screen)new WaypointEditGui(w));
    }

    private void changeEnabled(CheckBox t, Waypoint w) {
        w.setEnabled(t.checked);
        WaypointJsonUtils.changeWaypoint(this.dir, w.getName(), w, true);
        AdvancedCompass.getInstance().getCompassGui().changeWaypoint(w);
    }

    public void func_230430_a_(MatrixStack mat, int mouseX, int mouseY, float partialTick) {
        this.func_230446_a_(mat);
        this.optionList.func_230430_a_(mat, mouseX, mouseY, partialTick);
        this.widgetList.forEach(w -> w.func_230430_a_(mat, mouseX, mouseY, partialTick));
        this.optionList.renderTooltips(mat, mouseX, mouseY);
        this.widgetList.forEach(w -> w.renderTooltip(mat, mouseX, mouseY));
    }

    public boolean func_231045_a_(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        this.optionList.func_231045_a_(p_231045_1_, p_231045_3_, p_231045_5_, p_231045_6_, p_231045_8_);
        return false;
    }
}

