/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.config.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.advancedcompass.gui.config.widgets.ConfirmButton;
import dlovin.advancedcompass.gui.config.widgets.NumericTextField;
import dlovin.advancedcompass.gui.config.widgets.RowOfWidgets;
import dlovin.advancedcompass.gui.config.widgets.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.util.ResourceLocation;

public class CustomOptionList
extends AbstractOptionList {
    int ITEM_HEIGHT;
    private final List<RowOfWidgets> rows = new ArrayList<RowOfWidgets>();
    private final Screen parent;
    private int maxHeight;
    private int scroll = 0;
    private double tmp_scroll = 0.0;
    private boolean isDragging = false;
    private final ResourceLocation SCROLL = new ResourceLocation("advancedcompass", "textures/gui/widgets/scroll.png");

    public CustomOptionList(Minecraft p_i51130_1_, Screen screen) {
        super(p_i51130_1_, screen.field_230708_k_, screen.field_230709_l_, 55, screen.field_230709_l_ - 32, 30);
        this.ITEM_HEIGHT = 30;
        this.parent = screen;
    }

    public CustomOptionList(Minecraft p_i51130_1_, int top, int bottom, int itemHeight, Screen screen) {
        super(p_i51130_1_, screen.field_230708_k_, screen.field_230709_l_, top, screen.field_230709_l_ - bottom, itemHeight);
        this.ITEM_HEIGHT = itemHeight;
        this.parent = screen;
    }

    public void addWidget(Widget widget, int row) {
        if (this.maxHeight < (row + 1) * this.ITEM_HEIGHT + 10) {
            this.maxHeight = (row + 1) * this.ITEM_HEIGHT + 10;
        }
        widget.y = this.field_230672_i_ + 10 + this.ITEM_HEIGHT * row + widget.y;
        if (this.rows.stream().anyMatch(r -> r.index == row)) {
            this.rows.stream().filter(r -> r.index == row).findFirst().get().addWidget(widget);
        } else {
            this.rows.add(new RowOfWidgets(row, widget));
        }
    }

    public void removeRow(int index) {
        boolean removed = false;
        Iterator<RowOfWidgets> iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            RowOfWidgets item = iterator.next();
            if (item.index != index) continue;
            iterator.remove();
            removed = true;
            break;
        }
        if (!removed) {
            return;
        }
        for (RowOfWidgets row : this.rows) {
            if (row.index <= index) continue;
            for (Widget w : row.widgetList) {
                w.y -= this.ITEM_HEIGHT;
            }
        }
    }

    public List<Widget> getWidgets() {
        ArrayList<Widget> tmp = new ArrayList<Widget>();
        for (RowOfWidgets row : this.rows) {
            tmp.addAll(row.widgetList);
        }
        return tmp;
    }

    public boolean func_231043_a_(double p_231043_1_, double p_231043_3_, double p_231043_5_) {
        double tmp = 0.0;
        if (this.maxHeight > this.field_230673_j_ - this.field_230672_i_) {
            tmp = p_231043_5_ * 5.0;
            int diff = this.maxHeight - (this.field_230673_j_ - this.field_230672_i_);
            this.scroll = (int)((double)this.scroll - tmp);
            if (this.scroll < 0) {
                tmp += (double)this.scroll;
                this.scroll = 0;
            } else if (this.scroll > diff) {
                tmp += (double)(this.scroll - diff);
                this.scroll = diff;
            }
        }
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (w instanceof NumericTextField && ((NumericTextField)w).isFocused()) {
                    ((NumericTextField)w).setFocused2(false);
                }
                w.y = (int)((double)w.y + tmp);
            }
        }
        return true;
    }

    public boolean func_231045_a_(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        if (this.isDragging) {
            int height = this.field_230673_j_ - this.field_230672_i_;
            double scale = (double)height / (double)this.maxHeight;
            this.tmp_scroll += p_231045_8_ / scale;
            int tmp = (int)this.tmp_scroll;
            this.tmp_scroll -= (double)tmp;
            int diff = this.maxHeight - (this.field_230673_j_ - this.field_230672_i_);
            this.scroll += tmp;
            if (this.scroll < 0) {
                tmp -= this.scroll;
                this.scroll = 0;
            } else if (this.scroll > diff) {
                tmp -= this.scroll - diff;
                this.scroll = diff;
            }
            for (RowOfWidgets row : this.rows) {
                for (Widget w : row.widgetList) {
                    if (w instanceof NumericTextField && ((NumericTextField)w).isFocused()) {
                        ((NumericTextField)w).setFocused2(false);
                    }
                    w.y -= tmp;
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (!this.func_231047_b_(p_231044_1_, p_231044_3_)) {
            return false;
        }
        if (this.maxHeight > this.field_230673_j_ - this.field_230672_i_ && p_231044_5_ == 0) {
            int pos = this.field_230670_d_ > 309 ? this.field_230670_d_ / 2 + 150 : this.field_230670_d_ - 9;
            int height = this.field_230673_j_ - this.field_230672_i_;
            double scale = (double)height / (double)this.maxHeight;
            int yPos = this.field_230672_i_ + (int)((double)this.scroll * scale);
            if (this.isOver(p_231044_1_, p_231044_3_, pos + 1, pos + 8, yPos + 1, yPos + (height = (int)((double)height * scale)) - 1)) {
                this.isDragging = true;
            }
        }
        ArrayList<Runnable> clicks = new ArrayList<Runnable>();
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (!w.hovered && !(w instanceof NumericTextField) && !(w instanceof ConfirmButton)) continue;
                clicks.add(() -> w.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_));
            }
        }
        clicks.forEach(r -> r.run());
        return false;
    }

    public boolean func_231048_c_(double p_231048_1_, double p_231048_3_, int p_231048_5_) {
        this.isDragging = false;
        return false;
    }

    public boolean func_231042_a_(char p_231042_1_, int p_231042_2_) {
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (!(w instanceof NumericTextField) || !((NumericTextField)w).isFocused()) continue;
                w.func_231042_a_(p_231042_1_, p_231042_2_);
                return true;
            }
        }
        return false;
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (!(w instanceof NumericTextField) || !((NumericTextField)w).isFocused()) continue;
                w.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
                return true;
            }
        }
        super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
        return false;
    }

    private void renderScrollBG(MatrixStack mat, int xPos, int height) {
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)xPos, (int)this.field_230672_i_, (int)3, (int)3, (float)0.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)(xPos + 6), (int)this.field_230672_i_, (int)3, (int)3, (float)13.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)xPos, (int)(this.field_230673_j_ - 3), (int)3, (int)3, (float)0.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)(xPos + 6), (int)(this.field_230673_j_ - 3), (int)3, (int)3, (float)13.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)(xPos + 3), (int)this.field_230672_i_, (int)3, (int)3, (float)3.0f, (float)0.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)(xPos + 6), (int)(this.field_230672_i_ + 3), (int)3, (int)(height - 6), (float)13.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)(xPos + 3), (int)(this.field_230673_j_ - 3), (int)3, (int)3, (float)3.0f, (float)13.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)xPos, (int)(this.field_230672_i_ + 3), (int)3, (int)(height - 6), (float)0.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)(xPos + 3), (int)(this.field_230672_i_ + 3), (int)3, (int)(height - 6), (float)3.0f, (float)3.0f, (int)10, (int)10, (int)32, (int)32);
    }

    private void renderScroll(MatrixStack mat, int xPos, int height, int pos) {
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)xPos, (int)pos, (int)3, (int)3, (float)16.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)(xPos + 6), (int)pos, (int)3, (int)3, (float)29.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)xPos, (int)(-3 + height + pos), (int)3, (int)3, (float)16.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)(xPos + 6), (int)(-3 + height + pos), (int)3, (int)3, (float)29.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)(xPos + 3), (int)pos, (int)3, (int)3, (float)19.0f, (float)0.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)(xPos + 6), (int)(3 + pos), (int)3, (int)(height - 6 > 0 ? height - 6 : 0), (float)29.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)(xPos + 3), (int)(-3 + height + pos), (int)3, (int)3, (float)19.0f, (float)13.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)xPos, (int)(3 + pos), (int)3, (int)(height - 6 > 0 ? height - 6 : 0), (float)16.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.func_238466_a_((MatrixStack)mat, (int)(xPos + 3), (int)(3 + pos), (int)3, (int)(height - 6 > 0 ? height - 6 : 0), (float)19.0f, (float)3.0f, (int)10, (int)10, (int)32, (int)32);
    }

    private boolean isOver(double p_231047_1_, double p_231047_3_, int min_x, int max_x, int min_y, int max_y) {
        return p_231047_3_ >= (double)min_y && p_231047_3_ <= (double)max_y && p_231047_1_ >= (double)min_x && p_231047_1_ <= (double)max_x;
    }

    protected void func_238478_a_(MatrixStack p_238478_1_, int p_238478_2_, int p_238478_3_, int p_238478_4_, int p_238478_5_, float p_238478_6_) {
        if (this.maxHeight > this.field_230673_j_ - this.field_230672_i_) {
            int pos = this.field_230670_d_ > 309 ? this.field_230670_d_ / 2 + 150 : this.field_230670_d_ - 9;
            this.field_230668_b_.func_110434_K().func_110577_a(this.SCROLL);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
            int height = this.field_230673_j_ - this.field_230672_i_;
            this.renderScrollBG(p_238478_1_, pos, height);
            double scale = (double)height / (double)this.maxHeight;
            height = (int)((double)height * scale);
            int yPos = this.field_230672_i_ + (int)((double)this.scroll * scale);
            RenderSystem.color4f((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
            if (this.isOver(p_238478_4_, p_238478_5_, pos + 1, pos + 8, yPos + 1, yPos + height - 1) && this.isDragging) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.renderScroll(p_238478_1_, pos, height, yPos);
            RenderSystem.disableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                w.func_230430_a_(p_238478_1_, p_238478_4_, p_238478_5_, p_238478_6_);
            }
        }
    }

    public void renderTooltips(MatrixStack mat, int x, int y) {
        if (y > this.field_230673_j_ || y < this.field_230672_i_ || x > this.field_230674_k_ || x < this.field_230675_l_) {
            return;
        }
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                w.renderTooltip(mat, x, y);
            }
        }
    }
}

