/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.config.widgets;

import dlovin.advancedcompass.gui.config.widgets.TextField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.SharedConstants;

public class NumericTextField
extends TextField {
    public final int minValue;
    public final int maxValue;
    private final int defValue;

    public NumericTextField(FontRenderer font, int posX, int posY, int width, int height, int defValue, TextField.IPressable onChange) {
        this(font, posX, posY, width, height, Integer.MIN_VALUE, Integer.MAX_VALUE, defValue, onChange);
    }

    public NumericTextField(FontRenderer p_i232260_1_, int p_i232260_2_, int p_i232260_3_, int p_i232260_4_, int p_i232260_5_, int minValue, int maxValue, int defValue, TextField.IPressable onChange) {
        super(p_i232260_1_, p_i232260_2_, p_i232260_3_, p_i232260_4_, p_i232260_5_, defValue + "", onChange);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defValue = defValue;
        this.text = this.prevText = defValue + "";
        this.setMaxStringLength(String.valueOf(maxValue).length() > String.valueOf(minValue).length() ? String.valueOf(maxValue).length() + 1 : String.valueOf(minValue).length() + 1);
    }

    @Override
    public void writeText(String textToWrite) {
        String s1;
        int l;
        int i;
        block4: {
            String s;
            i = Math.min(this.cursorPosition, this.selectionEnd);
            int j = Math.max(this.cursorPosition, this.selectionEnd);
            int k = this.maxStringLength - this.text.length() - (i - j);
            if (k < (l = (s = SharedConstants.func_71565_a((String)textToWrite)).length())) {
                s = s.substring(0, k);
                l = k;
            }
            s1 = new StringBuilder(this.text).replace(i, j, s).toString();
            try {
                int num = Integer.parseInt(s1);
                s1 = num + "";
            }
            catch (NumberFormatException ex) {
                if (s.equalsIgnoreCase("-")) break block4;
                s1 = this.prevText;
            }
        }
        if (this.validator.test(s1)) {
            this.text = s1;
            this.clampCursorPosition(i + l);
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(this.text);
        }
    }

    @Override
    void onTextChanged(String newText) {
        if (!newText.equals(this.prevText) && this.isNumeric(newText)) {
            this.prevText = newText;
            this.onChange.onChanged(this);
        }
    }

    @Override
    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (!this.canWrite()) {
            return false;
        }
        this.field_212956_h = Screen.func_231173_s_();
        if (Screen.func_231170_j_((int)p_231046_1_)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (Screen.func_231169_i_((int)p_231046_1_)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            return true;
        }
        if (Screen.func_231168_h_((int)p_231046_1_)) {
            ((Object)((Object)this)).getClass();
            if (this.isNumeric(Minecraft.func_71410_x().field_195559_v.func_197965_a())) {
                this.writeText(Minecraft.func_71410_x().field_195559_v.func_197965_a());
            }
            return true;
        }
        if (Screen.func_231166_g_((int)p_231046_1_)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            ((Object)((Object)this)).getClass();
            this.writeText("");
            return true;
        }
        switch (p_231046_1_) {
            case 256: {
                this.setFocused2(false);
                return true;
            }
            case 259: {
                ((Object)((Object)this)).getClass();
                this.field_212956_h = false;
                this.delete(-1);
                this.field_212956_h = Screen.func_231173_s_();
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                ((Object)((Object)this)).getClass();
                this.field_212956_h = false;
                this.delete(1);
                this.field_212956_h = Screen.func_231173_s_();
                return true;
            }
            case 262: {
                if (Screen.func_231172_r_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (Screen.func_231172_r_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPositionZero();
                return true;
            }
            case 269: 
        }
        this.setCursorPositionEnd();
        return true;
    }

    public int getValue() {
        if (this.isNumeric(this.text)) {
            return Integer.parseInt(this.text);
        }
        return this.defValue;
    }

    @Override
    public boolean func_231042_a_(char p_231042_1_, int p_231042_2_) {
        if (!this.canWrite()) {
            return false;
        }
        if (this.isNumeric(Character.toString(p_231042_1_))) {
            ((Object)((Object)this)).getClass();
            this.writeText(Character.toString(p_231042_1_));
            return true;
        }
        if (p_231042_1_ == '-') {
            if (!this.getText().contains("-") && this.cursorPosition == 0) {
                ((Object)((Object)this)).getClass();
                this.writeText(Character.toString(p_231042_1_));
            }
            return true;
        }
        return false;
    }

    @Override
    public void setFocused2(boolean isFocusedIn) {
        this.isFocused = isFocusedIn;
        if (!isFocusedIn) {
            this.field_212956_h = false;
            this.setCursorPosition(0);
            if (!this.isNumeric(this.text) || this.text.equals("")) {
                this.setText(this.defValue + "");
            } else {
                try {
                    int num = Integer.parseInt(this.text);
                    if (num < this.minValue) {
                        this.setText(this.minValue + "");
                    } else if (num > this.maxValue) {
                        this.setText(this.maxValue + "");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isNumeric(String text) {
        if (text == null) {
            return false;
        }
        try {
            Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }
}

