/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.advancedcompass.gui.renderers.IRenderer;
import dlovin.advancedcompass.utils.SettingsValues;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;

public class CompassRenderer
extends IRenderer {
    public CompassRenderer(Minecraft mc, FontRenderer fontRenderer, SettingsValues settingsValues) {
        super(mc, fontRenderer, settingsValues);
    }

    public void render(MatrixStack mat, float angle, float scale) {
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawCardinal(mat, "N", this.ToFormat(angle), scale);
        this.drawCardinal(mat, "E", this.ToFormat(angle + 90.0f), scale);
        this.drawCardinal(mat, "S", this.ToFormat(angle - 180.0f), scale);
        this.drawCardinal(mat, "W", this.ToFormat(angle - 90.0f), scale);
        RenderSystem.popMatrix();
    }

    private void drawCardinal(MatrixStack mat, String letter, double angle, float scale) {
        if (Math.abs(angle) > (double)this.settings.getViewAngle()) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)this.getX(angle, scale), (double)((float)(this.settings.compassHeight / 2) * scale), (double)-1.0);
        RenderSystem.scalef((float)(scale * this.iconScale), (float)(scale * this.iconScale), (float)(scale * this.iconScale));
        this.mc.func_110434_K().func_110577_a(this.CARDINAL_P);
        AbstractGui.func_238463_a_((MatrixStack)mat, (int)-3, (int)-9, (float)0.0f, (float)0.0f, (int)6, (int)18, (int)6, (int)18);
        this.fontRenderer.func_238405_a_(mat, letter, -3.0f, -4.0f, -1);
        RenderSystem.translated((double)(-this.getX(angle, scale)), (double)(-11.0f * scale), (double)1.0);
        RenderSystem.popMatrix();
    }
}

