/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.advancedcompass.gui.renderers.IRenderer;
import dlovin.advancedcompass.utils.DrawRanges;
import dlovin.advancedcompass.utils.Group;
import dlovin.advancedcompass.utils.GroupEntity;
import dlovin.advancedcompass.utils.GroupPlayers;
import dlovin.advancedcompass.utils.GroupUtils;
import dlovin.advancedcompass.utils.HeadUtils;
import dlovin.advancedcompass.utils.NumsUtils;
import dlovin.advancedcompass.utils.SettingsValues;
import dlovin.advancedcompass.utils.TextureCoords;
import dlovin.advancedcompass.utils.TextureRes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class EntitiesRenderer
extends IRenderer {
    public EntitiesRenderer(Minecraft mc, FontRenderer fontRenderer, SettingsValues settingsValues) {
        super(mc, fontRenderer, settingsValues);
    }

    public void render(MatrixStack mat, float angle, float scale) {
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.settings.groupEntities) {
            if (this.settings.hideOverlapped) {
                this.renderGroups(mat, angle, scale);
            } else {
                this.renderOverlappedGroups(mat, angle, scale);
            }
        } else if (this.settings.hideOverlapped) {
            this.renderAllEntities(mat, angle, scale);
        } else {
            this.renderOverlappedAllEntities(mat, angle, scale);
        }
        RenderSystem.popMatrix();
    }

    private void renderGroups(MatrixStack mat, float angle, float scale) {
        ArrayList<DrawRanges> listOfAddedHeads = new ArrayList<DrawRanges>();
        ArrayList<Runnable> toRender = new ArrayList<Runnable>();
        for (Group gEn : GroupUtils.getSortedGroups(this.settings.maxDistance, this.settings.groupRadius, this.settings.showPlayers)) {
            Vector3d genPoint = gEn.getPoint();
            TextureCoords coords = HeadUtils.heads.get(gEn instanceof GroupEntity ? gEn.getType() : EntityType.field_200729_aH);
            if (coords == null) continue;
            float mobAngle = this.ToFormat(90.0f + angle + this.getAngle(genPoint));
            double x = this.getX(mobAngle, scale);
            double min = x - (double)((float)coords.width / 2.0f);
            double max = x + (double)((float)coords.width / 2.0f);
            if (!listOfAddedHeads.stream().noneMatch(w -> w.inRange(min, max, this.settings.overlapThreshold))) continue;
            if (gEn instanceof GroupEntity) {
                toRender.add(() -> this.drawMobHead(mat, mobAngle, scale, coords, this.settings.showDistance ? (int)this.getFlatDistance(genPoint, this.mc.field_71439_g.func_213303_ch()) : 0, this.mc.field_71439_g.func_226278_cu_() - genPoint.field_72448_b));
            } else {
                toRender.add(() -> this.drawPlayerHead(mat, mobAngle, scale, this.settings.showDistance ? (int)this.getFlatDistance(genPoint, this.mc.field_71439_g.func_213303_ch()) : 0, this.mc.field_71439_g.func_226278_cu_() - genPoint.field_72448_b, this.mc.func_175598_ae().func_78713_a(((GroupPlayers)gEn).getSample()).func_110775_a(((GroupPlayers)gEn).getSample()), coords));
            }
            listOfAddedHeads.add(new DrawRanges(min, max));
        }
        Collections.reverse(toRender);
        for (Runnable r : toRender) {
            r.run();
        }
    }

    private void renderOverlappedGroups(MatrixStack mat, float angle, float scale) {
        for (Group gEn : GroupUtils.getSortedReversedGroups(this.settings.maxDistance, this.settings.groupRadius, this.settings.showPlayers)) {
            Vector3d genPoint = gEn.getPoint();
            if (gEn instanceof GroupEntity) {
                this.drawMobHead(mat, this.ToFormat(90.0f + angle + this.getAngle(genPoint)), scale, HeadUtils.heads.get(gEn.getType()), this.settings.showDistance ? (int)this.getFlatDistance(genPoint, this.mc.field_71439_g.func_213303_ch()) : 0, this.mc.field_71439_g.func_226278_cu_() - genPoint.field_72448_b);
                continue;
            }
            this.drawPlayerHead(mat, this.ToFormat(90.0f + angle + this.getAngle(genPoint)), scale, this.settings.showDistance ? (int)this.getFlatDistance(genPoint, this.mc.field_71439_g.func_213303_ch()) : 0, this.mc.field_71439_g.func_226278_cu_() - genPoint.field_72448_b, this.mc.func_175598_ae().func_78713_a(((GroupPlayers)gEn).getSample()).func_110775_a(((GroupPlayers)gEn).getSample()), HeadUtils.heads.get(EntityType.field_200729_aH));
        }
    }

    private void renderAllEntities(MatrixStack mat, float angle, float scale) {
        double max;
        double min;
        double x;
        double mobAngle;
        TextureCoords coords;
        Vector3d genPoint;
        ArrayList entities = new ArrayList();
        ArrayList players = new ArrayList();
        this.mc.field_71441_e.func_217416_b().forEach(e -> {
            if (!e.func_98034_c((PlayerEntity)this.mc.field_71439_g)) {
                if (e instanceof MobEntity) {
                    if (GroupUtils.types.contains(e.func_200600_R())) {
                        entities.add(e);
                    }
                } else if (e instanceof PlayerEntity && !e.equals((Object)this.mc.field_71439_g)) {
                    if (this.mc.field_71439_g.field_71174_a.func_175102_a(e.func_110124_au()) == null) {
                        if (GroupUtils.types.contains(e.func_200600_R())) {
                            entities.add(e);
                        }
                    } else if (this.settings.showPlayers && !e.func_213453_ef()) {
                        players.add(e);
                    }
                }
            }
        });
        ArrayList<DrawRanges> listOfAddedHeads = new ArrayList<DrawRanges>();
        ArrayList<Runnable> toRender = new ArrayList<Runnable>();
        if (this.settings.showPlayers) {
            for (Entity en : players.stream().sorted(Comparator.comparing(e -> Float.valueOf(e.func_70032_d((Entity)this.mc.field_71439_g)))).collect(Collectors.toList())) {
                genPoint = en.func_213303_ch();
                coords = HeadUtils.heads.get(en.func_200600_R());
                if (coords == null) continue;
                mobAngle = this.ToFormat(90.0f + angle + this.getAngle(genPoint));
                x = this.getX(mobAngle, scale);
                min = x - (double)((float)coords.width / 2.0f);
                max = x + (double)((float)coords.width / 2.0f);
                if (!listOfAddedHeads.stream().noneMatch(w -> w.inRange(min, max, this.settings.overlapThreshold))) continue;
                toRender.add(() -> this.drawPlayerHead(mat, mobAngle, scale, this.settings.showDistance ? (int)this.getFlatDistance(en.func_213303_ch(), this.mc.field_71439_g.func_213303_ch()) : 0, this.mc.field_71439_g.func_226278_cu_() - en.func_226278_cu_(), this.mc.func_175598_ae().func_78713_a(en).func_110775_a(en), coords));
                listOfAddedHeads.add(new DrawRanges(min, max));
            }
        }
        for (Entity en : entities.stream().sorted(Comparator.comparing(e -> Float.valueOf(e.func_70032_d((Entity)this.mc.field_71439_g)))).collect(Collectors.toList())) {
            genPoint = en.func_213303_ch();
            coords = HeadUtils.heads.get(en.func_200600_R());
            if (coords == null) continue;
            mobAngle = this.ToFormat(90.0f + angle + this.getAngle(genPoint));
            x = this.getX(mobAngle, scale);
            min = x - (double)((float)coords.width / 2.0f);
            max = x + (double)((float)coords.width / 2.0f);
            if (!listOfAddedHeads.stream().noneMatch(w -> w.inRange(min, max, this.settings.overlapThreshold))) continue;
            if (en instanceof MobEntity) {
                toRender.add(() -> this.drawMobHead(mat, mobAngle, scale, coords, this.settings.showDistance ? (int)this.getFlatDistance(genPoint, this.mc.field_71439_g.func_213303_ch()) : 0, this.mc.field_71439_g.func_226278_cu_() - genPoint.field_72448_b));
            } else {
                toRender.add(() -> this.drawPlayerHead(mat, mobAngle, scale, this.settings.showDistance ? (int)this.getFlatDistance(en.func_213303_ch(), this.mc.field_71439_g.func_213303_ch()) : 0, this.mc.field_71439_g.func_226278_cu_() - en.func_226278_cu_(), this.mc.func_175598_ae().func_78713_a(en).func_110775_a(en), coords));
            }
            listOfAddedHeads.add(new DrawRanges(min, max));
        }
        Collections.reverse(toRender);
        for (Runnable r : toRender) {
            r.run();
        }
    }

    private void renderOverlappedAllEntities(MatrixStack mat, float angle, float scale) {
        ArrayList entities = new ArrayList();
        ArrayList players = new ArrayList();
        this.mc.field_71441_e.func_217416_b().forEach(e -> {
            if (!e.func_98034_c((PlayerEntity)this.mc.field_71439_g)) {
                if (e instanceof MobEntity) {
                    if (GroupUtils.types.contains(e.func_200600_R())) {
                        entities.add(e);
                    }
                } else if (e instanceof PlayerEntity && !e.equals((Object)this.mc.field_71439_g)) {
                    if (this.mc.field_71439_g.field_71174_a.func_175102_a(e.func_110124_au()) == null) {
                        if (GroupUtils.types.contains(e.func_200600_R())) {
                            entities.add(e);
                        }
                    } else if (this.settings.showPlayers && !e.func_213453_ef()) {
                        players.add(e);
                    }
                }
            }
        });
        for (Entity en : entities.stream().sorted(Comparator.comparing(e -> Float.valueOf(((Entity)e).func_70032_d((Entity)this.mc.field_71439_g))).reversed()).collect(Collectors.toList())) {
            if (en instanceof MobEntity) {
                this.drawMobHead(mat, this.ToFormat(90.0f + angle + this.getAngle(en.func_213303_ch())), scale, HeadUtils.heads.get(en.func_200600_R()), this.settings.showDistance ? (int)this.getFlatDistance(en.func_213303_ch(), this.mc.field_71439_g.func_213303_ch()) : 0, this.mc.field_71439_g.func_226278_cu_() - en.func_226278_cu_());
                continue;
            }
            this.drawPlayerHead(mat, this.ToFormat(90.0f + angle + this.getAngle(en.func_213303_ch())), scale, this.settings.showDistance ? (int)this.getFlatDistance(en.func_213303_ch(), this.mc.field_71439_g.func_213303_ch()) : 0, this.mc.field_71439_g.func_226278_cu_() - en.func_226278_cu_(), this.mc.func_175598_ae().func_78713_a(en).func_110775_a(en), HeadUtils.heads.get(en.func_200600_R()));
        }
        if (this.settings.showPlayers) {
            this.drawPlayers(mat, angle, scale, players.stream().sorted(Comparator.comparing(e -> Float.valueOf(((Entity)e).func_70032_d((Entity)this.mc.field_71439_g))).reversed()).collect(Collectors.toList()));
        }
    }

    private void drawPlayers(MatrixStack mat, float angle, float scale, Collection<Entity> players) {
        for (Entity en : players.stream().sorted(Comparator.comparing(e -> Float.valueOf(((Entity)e).func_70032_d((Entity)this.mc.field_71439_g))).reversed()).collect(Collectors.toList())) {
            this.drawPlayerHead(mat, this.ToFormat(90.0f + angle + this.getAngle(en.func_213303_ch())), scale, this.settings.showDistance ? (int)this.getFlatDistance(en.func_213303_ch(), this.mc.field_71439_g.func_213303_ch()) : 0, this.mc.field_71439_g.func_226278_cu_() - en.func_226278_cu_(), this.mc.func_175598_ae().func_78713_a(en).func_110775_a(en), HeadUtils.heads.get(en.func_200600_R()));
        }
    }

    private void drawMobHead(MatrixStack mat, double angle, float scale, TextureCoords tex, int distance, double hDif) {
        if (tex == null || Math.abs(angle) > (double)this.settings.angleThreshold) {
            return;
        }
        if (tex instanceof TextureRes) {
            this.drawMod(mat, (TextureRes)tex, angle, scale);
        } else {
            this.drawVanilla(mat, tex, angle, scale);
        }
        if (hDif < -3.0) {
            this.mc.func_110434_K().func_110577_a(this.ARROWS);
            AbstractGui.func_238463_a_((MatrixStack)mat, (int)(tex.width / 2 - 5), (int)0, (float)0.0f, (float)0.0f, (int)7, (int)7, (int)16, (int)16);
        } else if (hDif > 3.0) {
            this.mc.func_110434_K().func_110577_a(this.ARROWS);
            AbstractGui.func_238463_a_((MatrixStack)mat, (int)(tex.width / 2 - 5), (int)0, (float)7.0f, (float)0.0f, (int)7, (int)7, (int)16, (int)16);
        }
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (distance > 0) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)((double)NumsUtils.getWidth(distance + "m") / 2.0), (double)5.0, (double)0.0);
            int width = 0;
            this.mc.func_110434_K().func_110577_a(this.NUMS);
            TextureCoords c = NumsUtils.nums[10];
            AbstractGui.func_238463_a_((MatrixStack)mat, (int)(-c.width), (int)0, (float)c.xOffset, (float)c.yOffset, (int)c.width, (int)c.height, (int)128, (int)16);
            width += c.width - 1;
            while (distance > 0) {
                c = NumsUtils.nums[distance % 10];
                AbstractGui.func_238463_a_((MatrixStack)mat, (int)(-width - c.width), (int)0, (float)c.xOffset, (float)c.yOffset, (int)c.width, (int)c.height, (int)128, (int)16);
                distance /= 10;
                width += c.width - 1;
            }
            RenderSystem.popMatrix();
        }
        RenderSystem.popMatrix();
    }

    private void drawVanilla(MatrixStack mat, TextureCoords tex, double angle, float scale) {
        this.mc.func_110434_K().func_110577_a(this.MOBHEADS);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)this.getX(angle, scale), (double)((float)(this.settings.compassHeight / 2) * scale), (double)0.0);
        RenderSystem.scalef((float)(scale * this.iconScale), (float)(scale * this.iconScale), (float)(scale * this.iconScale));
        float alpha = 1.25f - MathHelper.func_76131_a((float)((float)Math.abs(angle) / (float)this.settings.getViewAngle()), (float)0.25f, (float)1.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.enableBlend();
        AbstractGui.func_238463_a_((MatrixStack)mat, (int)(-tex.width / 2), (int)(-tex.height / 2), (float)tex.xOffset, (float)tex.yOffset, (int)tex.width, (int)tex.height, (int)256, (int)256);
    }

    private void drawMod(MatrixStack mat, TextureRes tex, double angle, float scale) {
        this.mc.func_110434_K().func_110577_a(tex.res);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)this.getX(angle, scale), (double)((float)(this.settings.compassHeight / 2) * scale), (double)0.0);
        RenderSystem.scalef((float)(scale * this.iconScale), (float)(scale * this.iconScale), (float)(scale * this.iconScale));
        float alpha = 1.25f - MathHelper.func_76131_a((float)((float)Math.abs(angle) / (float)this.settings.getViewAngle()), (float)0.25f, (float)1.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.enableBlend();
        AbstractGui.func_238463_a_((MatrixStack)mat, (int)(-tex.width / 2), (int)(-tex.height / 2), (float)tex.xOffset, (float)tex.yOffset, (int)tex.width, (int)tex.height, (int)tex.width, (int)tex.height);
    }

    private void drawPlayerHead(MatrixStack mat, double angle, float scale, int distance, double hDif, ResourceLocation icon, TextureCoords tex) {
        if (Math.abs(angle) > (double)this.settings.angleThreshold) {
            return;
        }
        this.mc.func_110434_K().func_110577_a(icon);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)this.getX(angle, scale), (double)((float)(this.settings.compassHeight / 2) * scale), (double)0.0);
        RenderSystem.scalef((float)(scale * this.iconScale), (float)(scale * this.iconScale), (float)(scale * this.iconScale));
        float alpha = 1.25f - MathHelper.func_76131_a((float)((float)Math.abs(angle) / (float)this.settings.getViewAngle()), (float)0.25f, (float)1.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.mc.func_110434_K().func_110577_a(this.MOBHEADS);
        AbstractGui.func_238463_a_((MatrixStack)mat, (int)(-tex.width / 2), (int)(-tex.height / 2), (float)tex.xOffset, (float)tex.yOffset, (int)tex.width, (int)tex.height, (int)256, (int)256);
        this.mc.func_110434_K().func_110577_a(icon);
        AbstractGui.func_238466_a_((MatrixStack)mat, (int)-6, (int)-6, (int)12, (int)12, (float)12.0f, (float)12.0f, (int)12, (int)12, (int)96, (int)96);
        AbstractGui.func_238466_a_((MatrixStack)mat, (int)-6, (int)-6, (int)12, (int)12, (float)60.0f, (float)12.0f, (int)12, (int)12, (int)96, (int)96);
        if (hDif < -3.0) {
            this.mc.func_110434_K().func_110577_a(this.ARROWS);
            AbstractGui.func_238463_a_((MatrixStack)mat, (int)(tex.width / 2 - 5), (int)0, (float)0.0f, (float)0.0f, (int)7, (int)7, (int)16, (int)16);
        } else if (hDif > 3.0) {
            this.mc.func_110434_K().func_110577_a(this.ARROWS);
            AbstractGui.func_238463_a_((MatrixStack)mat, (int)(tex.width / 2 - 5), (int)0, (float)7.0f, (float)0.0f, (int)7, (int)7, (int)16, (int)16);
        }
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (distance > 0) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)((double)NumsUtils.getWidth(distance + "m") / 2.0), (double)5.0, (double)0.0);
            int width = 0;
            this.mc.func_110434_K().func_110577_a(this.NUMS);
            TextureCoords c = NumsUtils.nums[10];
            AbstractGui.func_238463_a_((MatrixStack)mat, (int)(-c.width), (int)0, (float)c.xOffset, (float)c.yOffset, (int)c.width, (int)c.height, (int)128, (int)16);
            width += c.width - 1;
            while (distance > 0) {
                c = NumsUtils.nums[distance % 10];
                AbstractGui.func_238463_a_((MatrixStack)mat, (int)(-width - c.width), (int)0, (float)c.xOffset, (float)c.yOffset, (int)c.width, (int)c.height, (int)128, (int)16);
                distance /= 10;
                width += c.width - 1;
            }
            RenderSystem.popMatrix();
        }
        RenderSystem.popMatrix();
    }
}

