/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.renderers;

import dlovin.advancedcompass.utils.SettingsValues;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class IRenderer {
    protected Minecraft mc;
    protected FontRenderer fontRenderer;
    protected SettingsValues settings;
    protected float iconScale;
    protected final ResourceLocation CARDINAL_P = new ResourceLocation("advancedcompass", "textures/gui/cardinal_point.png");
    protected final ResourceLocation MOBHEADS = new ResourceLocation("advancedcompass", "textures/mobs.png");
    protected final ResourceLocation NUMS = new ResourceLocation("advancedcompass", "textures/gui/nums.png");
    protected final ResourceLocation ARROWS = new ResourceLocation("advancedcompass", "textures/gui/arrows.png");
    protected final ResourceLocation WAYPOINTS = new ResourceLocation("advancedcompass", "textures/waypoints.png");

    public IRenderer(Minecraft mc, FontRenderer fontRenderer, SettingsValues settings) {
        this.mc = mc;
        this.fontRenderer = fontRenderer;
        this.settings = settings;
        this.iconScale = (float)settings.iconScale / 100.0f;
    }

    public void setIconScale(int scale) {
        this.iconScale = (float)this.settings.iconScale / 100.0f;
    }

    protected double getFlatDistance(Vector3d pos1, Vector3d pos2) {
        float f = (float)(pos1.field_72450_a - pos2.field_72450_a);
        float f2 = (float)(pos1.field_72449_c - pos2.field_72449_c);
        return Math.sqrt(f * f + f2 * f2);
    }

    protected float getAngle(Vector3d en) {
        return (float)Math.toDegrees(Math.atan2(en.field_72449_c - this.mc.field_71439_g.func_226281_cx_(), en.field_72450_a - this.mc.field_71439_g.func_226277_ct_()));
    }

    protected float ToFormat(float angle) {
        float f = (angle + 180.0f) % 360.0f;
        if (f < -180.0f) {
            f = (float)((double)f + 360.0);
        } else if (f >= 180.0f) {
            f = (float)((double)f - 360.0);
        }
        return f;
    }

    protected double getX(double angle, float scale) {
        int halfWidth = this.settings.compassWidth / 2;
        return MathHelper.func_151237_a((double)(angle / (double)this.settings.getViewAngle() * (double)halfWidth * (double)scale), (double)((float)(-halfWidth) * scale), (double)((float)halfWidth * scale));
    }
}

