/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import dlovin.advancedcompass.utils.GLShim;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class GLUtils {
    private static Tessellator tessellator = Tessellator.func_178181_a();
    private static BufferBuilder vertexBuffer = tessellator.func_178180_c();
    public static int fboID = 0;
    public static int rboID = 0;
    private static final boolean fboEnabledArb = GL.getCapabilities().GL_ARB_framebuffer_object;
    private static final boolean fboEnabledBase = GL.getCapabilities().OpenGL30;
    public static int fboTextureID = 0;
    private static int previousFBOID = 0;
    public static boolean hasAlphaBits = GL11.glGetInteger((int)3413) > 0;

    public static void setupFrameBuffer() {
        if (fboEnabledBase) {
            GLUtils.setupFrameBufferBASE();
        } else if (fboEnabledArb) {
            GLUtils.setupFrameBufferARB();
        } else {
            GLUtils.setupFrameBufferEXT();
        }
    }

    private static void setupFrameBufferBASE() {
        previousFBOID = GL11.glGetInteger((int)36006);
        fboID = GL30.glGenFramebuffers();
        fboTextureID = GL11.glGenTextures();
        int width = 512;
        int height = 512;
        GL30.glBindFramebuffer((int)36160, (int)fboID);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(4 * width * height));
        GLShim.glBindTexture(3553, fboTextureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glPixelStorei((int)3317, (int)1);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5120, (ByteBuffer)byteBuffer);
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)fboTextureID, (int)0);
        rboID = GL30.glGenRenderbuffers();
        GL30.glBindRenderbuffer((int)36161, (int)rboID);
        GL30.glRenderbufferStorage((int)36161, (int)33190, (int)width, (int)height);
        GL30.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)rboID);
        GL30.glBindRenderbuffer((int)36161, (int)0);
        GL30.glBindFramebuffer((int)36160, (int)previousFBOID);
        GL11.glPixelStorei((int)3317, (int)4);
    }

    private static void setupFrameBufferARB() {
        previousFBOID = GL11.glGetInteger((int)36006);
        fboID = ARBFramebufferObject.glGenFramebuffers();
        fboTextureID = GL11.glGenTextures();
        int width = 512;
        int height = 512;
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)fboID);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(4 * width * height));
        GLShim.glBindTexture(3553, fboTextureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glPixelStorei((int)3317, (int)1);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5120, (ByteBuffer)byteBuffer);
        ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)fboTextureID, (int)0);
        rboID = ARBFramebufferObject.glGenRenderbuffers();
        ARBFramebufferObject.glBindRenderbuffer((int)36161, (int)rboID);
        ARBFramebufferObject.glRenderbufferStorage((int)36161, (int)33190, (int)width, (int)height);
        ARBFramebufferObject.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)rboID);
        ARBFramebufferObject.glBindRenderbuffer((int)36161, (int)0);
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)previousFBOID);
        GL11.glPixelStorei((int)3317, (int)4);
    }

    private static void setupFrameBufferEXT() {
        previousFBOID = GL11.glGetInteger((int)36006);
        fboID = EXTFramebufferObject.glGenFramebuffersEXT();
        fboTextureID = GL11.glGenTextures();
        int width = 512;
        int height = 512;
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)fboID);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(4 * width * height));
        GLShim.glBindTexture(3553, fboTextureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glPixelStorei((int)3317, (int)1);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5120, (ByteBuffer)byteBuffer);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)fboTextureID, (int)0);
        rboID = EXTFramebufferObject.glGenRenderbuffersEXT();
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)rboID);
        EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)33190, (int)width, (int)height);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)rboID);
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)0);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)previousFBOID);
        GL11.glPixelStorei((int)3317, (int)4);
    }

    public static void bindFrameBuffer() {
        if (fboEnabledBase) {
            GLUtils.bindFrameBufferBASE();
        } else if (fboEnabledArb) {
            GLUtils.bindFrameBufferARB();
        } else {
            GLUtils.bindFrameBufferEXT();
        }
    }

    private static void bindFrameBufferBASE() {
        previousFBOID = GL11.glGetInteger((int)36006);
        GL30.glBindFramebuffer((int)36160, (int)fboID);
    }

    private static void bindFrameBufferARB() {
        previousFBOID = GL11.glGetInteger((int)36006);
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)fboID);
    }

    private static void bindFrameBufferEXT() {
        previousFBOID = GL11.glGetInteger((int)36006);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)fboID);
    }

    public static void unbindFrameBuffer() {
        if (fboEnabledBase) {
            GLUtils.unbindFrameBufferBASE();
        } else if (fboEnabledArb) {
            GLUtils.unbindFrameBufferARB();
        } else {
            GLUtils.unbindFrameBufferEXT();
        }
    }

    private static void unbindFrameBufferBASE() {
        GL30.glBindFramebuffer((int)36160, (int)previousFBOID);
    }

    private static void unbindFrameBufferARB() {
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)previousFBOID);
    }

    private static void unbindFrameBufferEXT() {
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)previousFBOID);
    }

    public static void disp(int paramInt) {
        GlStateManager.func_227760_t_((int)paramInt);
    }

    public static void drawPre() {
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
    }

    public static void drawPost() {
        tessellator.func_78381_a();
    }

    public static void ldrawthree(double x, double y, double z, float u, float v) {
        vertexBuffer.func_225582_a_(x, y, z).func_225583_a_(u, v).func_181675_d();
    }
}

