/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.utils.GroupUtils;
import dlovin.advancedcompass.utils.HeadPack;
import dlovin.advancedcompass.utils.TextureCoords;
import dlovin.advancedcompass.utils.TextureRes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.PackCompatibility;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class HeadUtils {
    public static HashMap<EntityType, TextureCoords> heads;
    private static List<HeadPack> ipack;

    public static void addHead(EntityType type, int width, int height, ResourceLocation resourceLocation) {
        if (ipack.stream().noneMatch(w -> w.func_195762_a().equals(resourceLocation.func_110624_b()))) {
            HeadPack pack = new HeadPack(type.getRegistryName().func_110624_b());
            ipack.add(pack);
            Minecraft.func_71410_x().func_195548_H().addPackFinder((infoConsumer, infoFactory) -> {
                ResourcePackInfo packInfo = new ResourcePackInfo(pack.func_195762_a(), true, () -> pack, (ITextComponent)new StringTextComponent("AC"), (ITextComponent)new StringTextComponent("AC"), PackCompatibility.COMPATIBLE, ResourcePackInfo.Priority.BOTTOM, true, IPackNameDecorator.field_232626_b_, true);
                infoConsumer.accept(packInfo);
            });
        }
        for (HeadPack pack : ipack) {
            if (!Minecraft.func_71410_x().func_195551_G().func_230232_b_().noneMatch(w -> w.func_195762_a().equals(pack.func_195762_a()))) continue;
            AdvancedCompass.logger.info("IResourcePack " + pack.func_195762_a() + " has been added");
            ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_199021_a((IResourcePack)pack);
        }
        heads.put(type, new TextureRes(0, 0, width, height, resourceLocation));
    }

    public static void loadModHeads() {
        File file = new File(FMLPaths.CONFIGDIR.get() + "/AdvancedCompass/mobs/");
        String[] directories = file.list((current, name) -> new File(current, name).isDirectory());
        for (String directory : directories) {
            AdvancedCompass.logger.info("scanning directory: " + directory);
            if (!ModList.get().isLoaded(directory)) {
                AdvancedCompass.logger.info(directory + " mod doesn't exists");
                continue;
            }
            File tmp = new File(file.getAbsolutePath() + "/" + directory + "/mobs.json");
            if (!tmp.exists()) continue;
            HeadPack tmpPack = new HeadPack(directory);
            try {
                FileReader reader = new FileReader(tmp);
                JsonParser parser = new JsonParser();
                JsonElement element = parser.parse((Reader)reader);
                for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                    File iconFile = new File(file.getAbsolutePath() + "/" + directory + "/" + (String)entry.getKey() + ".png");
                    if (!iconFile.exists()) {
                        AdvancedCompass.logger.info("Missed icon for mob: " + (String)entry.getKey());
                        continue;
                    }
                    ResourceLocation loc = new ResourceLocation("advancedcompass." + directory, (String)entry.getKey());
                    heads.put((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(directory, (String)entry.getKey())), new TextureRes(0, 0, ((JsonElement)entry.getValue()).getAsJsonObject().get("width").getAsInt(), ((JsonElement)entry.getValue()).getAsJsonObject().get("height").getAsInt(), loc));
                    AdvancedCompass.logger.info("Mob: " + loc + " added");
                    if (!((JsonElement)entry.getValue()).getAsJsonObject().get("show").getAsBoolean()) continue;
                    GroupUtils.types.add((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(directory, (String)entry.getKey())));
                }
                ipack.add(tmpPack);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        for (HeadPack pack : ipack) {
            Minecraft.func_71410_x().func_195548_H().addPackFinder((infoConsumer, infoFactory) -> {
                ResourcePackInfo packInfo = new ResourcePackInfo(pack.func_195762_a(), true, () -> pack, (ITextComponent)new StringTextComponent("AC"), (ITextComponent)new StringTextComponent("AC"), PackCompatibility.COMPATIBLE, ResourcePackInfo.Priority.BOTTOM, true, IPackNameDecorator.field_232626_b_, true);
                infoConsumer.accept(packInfo);
            });
        }
    }

    public static void AddResourcePacks() {
        for (HeadPack pack : ipack) {
            if (!Minecraft.func_71410_x().func_195551_G().func_230232_b_().noneMatch(p -> p.func_195762_a().equals(pack.func_195762_a()))) continue;
            ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_199021_a((IResourcePack)pack);
            AdvancedCompass.logger.info("IResourcePack " + pack.func_195762_a() + " has been added");
        }
    }

    public static EntityType getType(String name) {
        for (Map.Entry<EntityType, TextureCoords> en : heads.entrySet()) {
            if (!en.getKey().func_210760_d().equals(name)) continue;
            return en.getKey();
        }
        return null;
    }

    static {
        ipack = new ArrayList<HeadPack>();
        heads = new HashMap();
        heads.put(EntityType.field_200725_aD, new TextureCoords(0, 0, 16, 16));
        heads.put(EntityType.field_200727_aF, new TextureCoords(16, 0, 16, 19));
        heads.put(EntityType.field_200741_ag, new TextureCoords(32, 0, 16, 16));
        heads.put(EntityType.field_233592_ba_, new TextureCoords(48, 0, 20, 16));
        heads.put(EntityType.field_233590_aW_, new TextureCoords(68, 0, 18, 20));
        heads.put(EntityType.field_200724_aC, new TextureCoords(86, 0, 14, 17));
        heads.put(EntityType.field_200722_aA, new TextureCoords(100, 0, 16, 16));
        heads.put(EntityType.field_200760_az, new TextureCoords(116, 0, 32, 17));
        heads.put(EntityType.field_200759_ay, new TextureCoords(148, 0, 20, 25));
        heads.put(EntityType.field_200736_ab, new TextureCoords(168, 0, 14, 19));
        heads.put(EntityType.field_220351_aK, new TextureCoords(182, 0, 16, 17));
        heads.put(EntityType.field_200758_ax, new TextureCoords(198, 0, 16, 19));
        heads.put(EntityType.field_200756_av, new TextureCoords(214, 0, 16, 19));
        heads.put(EntityType.field_200755_au, new TextureCoords(230, 0, 16, 16));
        heads.put(EntityType.field_204262_at, new TextureCoords(0, 25, 13, 8));
        heads.put(EntityType.field_233589_aE_, new TextureCoords(13, 25, 18, 16));
        heads.put(EntityType.field_200750_ap, new TextureCoords(31, 25, 18, 17));
        heads.put(EntityType.field_200749_ao, new TextureCoords(49, 25, 16, 18));
        heads.put(EntityType.field_200748_an, new TextureCoords(65, 25, 18, 16));
        heads.put(EntityType.field_200745_ak, new TextureCoords(83, 25, 16, 16));
        heads.put(EntityType.field_220356_B, new TextureCoords(99, 25, 16, 16));
        heads.put(EntityType.field_200743_ai, new TextureCoords(115, 25, 16, 16));
        heads.put(EntityType.field_200740_af, new TextureCoords(131, 25, 20, 16));
        heads.put(EntityType.field_200738_ad, new TextureCoords(151, 25, 18, 16));
        heads.put(EntityType.field_200737_ac, new TextureCoords(169, 25, 16, 16));
        heads.put(EntityType.field_203778_ae, new TextureCoords(185, 25, 20, 13));
        heads.put(EntityType.field_200780_T, new TextureCoords(205, 25, 16, 16));
        heads.put(EntityType.field_220352_aU, new TextureCoords(221, 25, 18, 20));
        heads.put(EntityType.field_203779_Z, new TextureCoords(0, 45, 16, 16));
        heads.put(EntityType.field_200786_Z, new TextureCoords(16, 45, 18, 17));
        heads.put(EntityType.field_220350_aJ, new TextureCoords(34, 45, 16, 19));
        heads.put(EntityType.field_200806_t, new TextureCoords(34, 45, 16, 19));
        heads.put(EntityType.field_233591_ai_, new TextureCoords(50, 45, 20, 16));
        heads.put(EntityType.field_242287_aj, new TextureCoords(50, 45, 20, 16));
        heads.put(EntityType.field_200784_X, new TextureCoords(70, 45, 16, 16));
        heads.put(EntityType.field_203097_aH, new TextureCoords(86, 45, 18, 10));
        heads.put(EntityType.field_200783_W, new TextureCoords(104, 45, 9, 16));
        heads.put(EntityType.field_220353_aa, new TextureCoords(113, 45, 22, 17));
        heads.put(EntityType.field_200781_U, new TextureCoords(135, 45, 14, 14));
        heads.put(EntityType.field_200779_S, new TextureCoords(149, 45, 18, 18));
        heads.put(EntityType.field_200771_K, new TextureCoords(167, 45, 16, 16));
        heads.put(EntityType.field_200757_aw, new TextureCoords(183, 45, 16, 19));
        heads.put(EntityType.field_200764_D, new TextureCoords(199, 45, 16, 19));
        heads.put(EntityType.field_200763_C, new TextureCoords(215, 45, 16, 16));
        heads.put(EntityType.field_200726_aE, new TextureCoords(231, 45, 18, 18));
        heads.put(EntityType.field_200742_ah, new TextureCoords(0, 64, 18, 18));
        heads.put(EntityType.field_200762_B, new TextureCoords(18, 64, 18, 18));
        heads.put(EntityType.field_233588_G_, new TextureCoords(36, 64, 18, 20));
        heads.put(EntityType.field_200800_n, new TextureCoords(54, 64, 20, 20));
        heads.put(EntityType.field_200761_A, new TextureCoords(74, 64, 20, 20));
        heads.put(EntityType.field_200811_y, new TextureCoords(94, 64, 16, 16));
        heads.put(EntityType.field_200804_r, new TextureCoords(110, 64, 14, 10));
        heads.put(EntityType.field_200803_q, new TextureCoords(124, 64, 18, 16));
        heads.put(EntityType.field_204724_o, new TextureCoords(142, 64, 16, 16));
        heads.put(EntityType.field_200798_l, new TextureCoords(158, 64, 18, 18));
        heads.put(EntityType.field_200802_p, new TextureCoords(176, 64, 36, 18));
        heads.put(EntityType.field_205137_n, new TextureCoords(212, 64, 18, 16));
        heads.put(EntityType.field_200797_k, new TextureCoords(230, 64, 16, 16));
        heads.put(EntityType.field_200769_I, new TextureCoords(0, 84, 16, 19));
        heads.put(EntityType.field_220354_ax, new TextureCoords(0, 84, 16, 19));
        heads.put(EntityType.field_200796_j, new TextureCoords(16, 84, 16, 16));
        heads.put(EntityType.field_203780_j, new TextureCoords(32, 84, 19, 11));
        heads.put(EntityType.field_200795_i, new TextureCoords(51, 84, 12, 16));
        heads.put(EntityType.field_200794_h, new TextureCoords(63, 84, 18, 16));
        heads.put(EntityType.field_200792_f, new TextureCoords(81, 84, 16, 16));
        heads.put(EntityType.field_203099_aq, new TextureCoords(97, 84, 19, 11));
        heads.put(EntityType.field_226289_e_, new TextureCoords(116, 84, 16, 16));
        heads.put(EntityType.field_200791_e, new TextureCoords(132, 84, 12, 12));
        heads.put(EntityType.field_220360_g, new TextureCoords(144, 84, 14, 14));
        heads.put(EntityType.field_200729_aH, new TextureCoords(158, 84, 16, 16));
    }
}

