/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import dlovin.advancedcompass.utils.GLShim;
import dlovin.advancedcompass.utils.GLUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.client.Minecraft;

public class ImageUtils {
    private static int getMinY(BufferedImage src) {
        int yLast = -1;
        int y = 0;
        while (y < src.getHeight()) {
            boolean empty = true;
            for (int x = 0; x < src.getWidth(); ++x) {
                if (src.getRGB(x, y) == 0) continue;
                empty = false;
                break;
            }
            if (!empty) break;
            yLast = y++;
        }
        return yLast;
    }

    private static int getMaxY(BufferedImage src) {
        int yLast = src.getHeight();
        int y = src.getHeight() - 1;
        while (y >= 0) {
            boolean empty = true;
            for (int x = 0; x < src.getWidth(); ++x) {
                if (src.getRGB(x, y) == 0) continue;
                empty = false;
                break;
            }
            if (!empty) break;
            yLast = y--;
        }
        return yLast;
    }

    private static int getMinX(BufferedImage src) {
        int xLast = -1;
        int x = 0;
        while (x < src.getWidth()) {
            boolean empty = true;
            for (int y = 0; y < src.getHeight(); ++y) {
                if (src.getRGB(x, y) == 0) continue;
                empty = false;
                break;
            }
            if (!empty) break;
            xLast = x++;
        }
        return xLast;
    }

    private static int getMaxX(BufferedImage src) {
        int xLast = src.getWidth();
        int x = src.getWidth() - 1;
        while (x >= 0) {
            boolean empty = true;
            for (int y = 0; y < src.getHeight(); ++y) {
                if (src.getRGB(x, y) == 0) continue;
                empty = false;
                break;
            }
            if (!empty) break;
            xLast = x--;
        }
        return xLast;
    }

    public static BufferedImage cropImage(BufferedImage src) throws RasterFormatException {
        int yMin = ImageUtils.getMinY(src);
        int yMax = ImageUtils.getMaxY(src);
        int xMin = ImageUtils.getMinX(src);
        int xMax = ImageUtils.getMaxX(src);
        BufferedImage dest = src.getSubimage(xMin + 1, yMin + 1, xMax - xMin - 1, yMax - yMin - 1);
        return dest;
    }

    public static BufferedImage outlineImage(BufferedImage src) {
        int y;
        int x;
        BufferedImage cropped = ImageUtils.cropImage(src);
        BufferedImage resized = new BufferedImage(cropped.getWidth() + 4, cropped.getHeight() + 4, 2);
        Graphics2D g2d = resized.createGraphics();
        g2d.drawImage((Image)cropped, 2, 2, null);
        g2d.dispose();
        BufferedImage oimg = new BufferedImage(resized.getWidth(), resized.getHeight(), 2);
        for (x = 1; x < resized.getWidth() - 1; ++x) {
            for (y = 1; y < resized.getHeight() - 1; ++y) {
                if (resized.getRGB(x, y) != 0 || resized.getRGB(x - 1, y) == 0 && resized.getRGB(x + 1, y) == 0 && resized.getRGB(x, y - 1) == 0 && resized.getRGB(x, y + 1) == 0) continue;
                oimg.setRGB(x, y, -16777216);
            }
        }
        for (x = 1; x < resized.getWidth() - 1; ++x) {
            for (y = 1; y < resized.getHeight() - 1; ++y) {
                if (oimg.getRGB(x, y) != 0) continue;
                if (oimg.getRGB(x - 1, y) == -16777216 && oimg.getRGB(x, y - 1) == -16777216 && oimg.getRGB(x - 1, y - 1) != -16777216) {
                    oimg.setRGB(x, y, Integer.MIN_VALUE);
                    continue;
                }
                if (oimg.getRGB(x - 1, y) == -16777216 && oimg.getRGB(x, y + 1) == -16777216 && oimg.getRGB(x - 1, y + 1) != -16777216) {
                    oimg.setRGB(x, y, Integer.MIN_VALUE);
                    continue;
                }
                if (oimg.getRGB(x + 1, y) == -16777216 && oimg.getRGB(x, y - 1) == -16777216 && oimg.getRGB(x + 1, y - 1) != -16777216) {
                    oimg.setRGB(x, y, Integer.MIN_VALUE);
                    continue;
                }
                if (oimg.getRGB(x + 1, y) != -16777216 || oimg.getRGB(x, y + 1) != -16777216 || oimg.getRGB(x + 1, y + 1) == -16777216) continue;
                oimg.setRGB(x, y, Integer.MIN_VALUE);
            }
        }
        g2d = oimg.createGraphics();
        g2d.drawImage((Image)oimg, 0, 0, null);
        g2d.drawImage((Image)resized, 0, 0, null);
        g2d.dispose();
        return oimg;
    }

    public static BufferedImage rescale(BufferedImage src, int hints) {
        int scaledHeight = 0;
        int scaledWidth = 0;
        float scale = 0.0f;
        if ((float)src.getWidth() / (float)src.getHeight() > 1.4f) {
            scale = 16.0f / (float)src.getWidth();
            scaledWidth = 16;
            scaledHeight = (int)((float)src.getHeight() * scale);
        } else if ((float)src.getHeight() / (float)src.getWidth() > 1.4f) {
            scale = 16.0f / (float)src.getHeight();
            scaledHeight = 16;
            scaledWidth = (int)((float)src.getWidth() * scale);
        } else if (src.getHeight() < src.getWidth()) {
            scale = 12.0f / (float)src.getHeight();
            scaledHeight = 12;
            scaledWidth = (int)((float)src.getWidth() * scale);
        } else {
            scale = 12.0f / (float)src.getWidth();
            scaledWidth = 12;
            scaledHeight = (int)((float)src.getHeight() * scale);
        }
        Image tmp = src.getScaledInstance(scaledWidth, scaledHeight, hints);
        BufferedImage dimg = new BufferedImage(scaledWidth, scaledHeight, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    public static BufferedImage createBufferedImageFromGLID(int id) {
        GLShim.glBindTexture(3553, id);
        return ImageUtils.createBufferedImageFromCurrentGLImage();
    }

    public static BufferedImage createBufferedImageFromCurrentGLImage() {
        BufferedImage image;
        int imageHeight;
        int imageWidth = GLShim.glGetTexLevelParameteri(3553, 0, 4096);
        long size = (long)imageWidth * (long)(imageHeight = GLShim.glGetTexLevelParameteri(3553, 0, 4097)) * 4L;
        if (size < Integer.MAX_VALUE) {
            image = new BufferedImage(imageWidth, imageHeight, 6);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(imageWidth * imageHeight * 4).order(ByteOrder.nativeOrder());
            GLShim.glGetTexImage(3553, 0, 6408, 5121, byteBuffer);
            byteBuffer.position(0);
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            for (int x = 0; x < imageWidth; ++x) {
                for (int y = 0; y < imageHeight; ++y) {
                    int index = y * imageWidth * 4 + x * 4;
                    boolean var8 = false;
                    int color24 = 0 | (bytes[index + 2] & 0xFF) << 0;
                    color24 |= (bytes[index + 1] & 0xFF) << 8;
                    color24 |= (bytes[index + 0] & 0xFF) << 16;
                    image.setRGB(x, y, color24 |= (bytes[index + 3] & 0xFF) << 24);
                }
            }
        } else {
            while (size > Integer.MAX_VALUE) {
                size = (long)(imageWidth /= 2) * (long)(imageHeight /= 2) * 4L;
            }
            int glid = GlStateManager.func_227622_J_();
            image = new BufferedImage(imageWidth, imageHeight, 6);
            int fboWidth = 512;
            int fboHeight = 512;
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(0x100000).order(ByteOrder.nativeOrder());
            byte[] bytes2 = new byte[byteBuffer2.remaining()];
            GLShim.glPushAttrib(4096);
            GLShim.glViewport(0, 0, 512, 512);
            GLShim.glMatrixMode(5889);
            GLShim.glPushMatrix();
            GLShim.glLoadIdentity();
            GLShim.glOrtho(0.0, 512.0, 512.0, 0.0, 1000.0, 3000.0);
            GLShim.glMatrixMode(5888);
            GLShim.glPushMatrix();
            GLShim.glLoadIdentity();
            GLShim.glTranslatef(0.0f, 0.0f, -2000.0f);
            GLUtils.bindFrameBuffer();
            int startX = 0;
            while (startX + 512 < imageWidth) {
                int startY = 0;
                while (startY + 512 < imageHeight) {
                    GLUtils.disp(glid);
                    GLShim.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                    GLShim.glClear(16640);
                    GLUtils.drawPre();
                    GLUtils.ldrawthree(0.0, 512.0, 1.0, (float)startX / (float)imageWidth, (float)startY / (float)imageHeight);
                    GLUtils.ldrawthree(512.0, 512.0, 1.0, ((float)startX + 512.0f) / (float)imageWidth, (float)startY / (float)imageHeight);
                    GLUtils.ldrawthree(512.0, 0.0, 1.0, ((float)startX + 512.0f) / (float)imageWidth, ((float)startY + 512.0f) / (float)imageHeight);
                    GLUtils.ldrawthree(0.0, 0.0, 1.0, (float)startX / (float)imageWidth, ((float)startY + 512.0f) / (float)imageHeight);
                    GLUtils.drawPost();
                    GLUtils.disp(GLUtils.fboTextureID);
                    byteBuffer2.position(0);
                    GLShim.glGetTexImage(3553, 0, 6408, 5121, byteBuffer2);
                    byteBuffer2.position(0);
                    byteBuffer2.get(bytes2);
                    for (int x2 = 0; x2 < 512 && startX + x2 < imageWidth; ++x2) {
                        for (int y2 = 0; y2 < 512 && startY + y2 < imageHeight; ++y2) {
                            int index2 = y2 * 512 * 4 + x2 * 4;
                            boolean var9 = false;
                            int color25 = 0 | (bytes2[index2 + 2] & 0xFF) << 0;
                            color25 |= (bytes2[index2 + 1] & 0xFF) << 8;
                            color25 |= (bytes2[index2 + 0] & 0xFF) << 16;
                            image.setRGB(startX + x2, startY + y2, color25 |= (bytes2[index2 + 3] & 0xFF) << 24);
                        }
                    }
                    startY += 512;
                }
                startX += 512;
            }
            GLUtils.unbindFrameBuffer();
            GLShim.glMatrixMode(5889);
            GLShim.glPopMatrix();
            GLShim.glMatrixMode(5888);
            GLShim.glPopMatrix();
            GLShim.glPopAttrib();
            GLShim.glViewport(0, 0, Minecraft.func_71410_x().func_228018_at_().func_198109_k(), Minecraft.func_71410_x().func_228018_at_().func_198091_l());
        }
        return image;
    }
}

