/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.allurement.core;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="allurement")
public class AllurementConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> enchantableHorseArmor;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableAlleviating;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableReeling;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableReforming;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableShockwave;
        public final ForgeConfigSpec.ConfigValue<Boolean> removeLevelScaling;
        public final ForgeConfigSpec.ConfigValue<Integer> experiencePerLevel;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("enchantments");
            this.enableAlleviating = builder.comment("Armor enchantment that heals the user when collecting experience").define("enableAlleviating", true);
            this.enableReeling = builder.comment("Crossbow enchantment that pulls targets towards the user").define("enableReeling", true);
            this.enableReforming = builder.comment("Gear enchantment that very slowly repairs items over time").define("enableReforming", true);
            this.enableShockwave = builder.comment("Boots enchantment that creates a shockwave when taking fall damage").define("enableShockwave", true);
            builder.pop();
            builder.push("enchanting");
            this.enchantableHorseArmor = builder.comment("Allow horse armor to be enchanted").define("enchantableHorseArmor", true);
            builder.pop();
            builder.push("experience");
            this.removeLevelScaling = builder.comment("Remove the amount of experience per level increasing (experimental)").define("removeLevelScaling", false);
            this.experiencePerLevel = builder.comment("The amount of experience per level").define("experiencePerLevel", (Object)50);
            builder.pop();
        }
    }
}

