/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.allurement.core.other;

import com.google.common.collect.Maps;
import com.minecraftabnormals.allurement.core.other.AllurementDamageSources;
import com.minecraftabnormals.allurement.core.registry.AllurementEnchantments;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="allurement")
public class AllurementEvents {
    public static final Map<String, Integer> ENCHANTABILITY_MAP = (Map)Util.func_200696_a((Object)Maps.newHashMap(), map -> {
        map.put("minecraft:leather_horse_armor", 15);
        map.put("minecraft:iron_horse_armor", 9);
        map.put("minecraft:golden_horse_armor", 25);
        map.put("minecraft:diamond_horse_armor", 10);
        map.put("nether_extension:netherite_horse_armor", 15);
        map.put("caverns_and_chasms:silver_horse_armor", 17);
        map.put("caverns_and_chasms:necromium_horse_armor", 13);
    });

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        int level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AllurementEnchantments.SHOCKWAVE.get()), (ItemStack)entity.func_184582_a(EquipmentSlotType.FEET));
        EffectInstance effectinstance = entity.func_70660_b(Effects.field_76430_j);
        float f = effectinstance == null ? 0.0f : (float)(effectinstance.func_76458_c() + 1);
        int damage = MathHelper.func_76123_f((float)((event.getDistance() - 3.0f - f) * event.getDamageMultiplier()));
        if (level > 0 && damage > 0) {
            for (LivingEntity target : world.func_217357_a(LivingEntity.class, entity.func_174813_aQ().func_72314_b((double)level, 0.0, (double)level))) {
                if (entity == target) continue;
                target.func_70097_a(AllurementDamageSources.causeShockwaveDamage(entity), event.getDistance());
            }
            if (world instanceof ServerWorld) {
                ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197613_f, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 200, (double)level, 0.5, (double)level, 0.0);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack = entity.func_184582_a(slot);
            int level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AllurementEnchantments.REFORMING.get()), (ItemStack)stack);
            if (stack.func_190926_b() || !stack.func_77951_h() || level <= 0 || world.func_82737_E() % 600L != 0L) continue;
            stack.func_196085_b(stack.func_77952_i() - 1);
        }
    }
}

