/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animepets;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.animepets.AnimepetsMod;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class AnimepetsModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<Biome>> biomes = new ArrayList<Supplier<Biome>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public AnimepetsModElements() {
        sounds.put(new ResourceLocation("animepets", "pikachupetshock"), new SoundEvent(new ResourceLocation("animepets", "pikachupetshock")));
        sounds.put(new ResourceLocation("animepets", "pikachupetliving"), new SoundEvent(new ResourceLocation("animepets", "pikachupetliving")));
        sounds.put(new ResourceLocation("animepets", "eeveliv"), new SoundEvent(new ResourceLocation("animepets", "eeveliv")));
        sounds.put(new ResourceLocation("animepets", "evedano"), new SoundEvent(new ResourceLocation("animepets", "evedano")));
        sounds.put(new ResourceLocation("animepets", "evedie"), new SoundEvent(new ResourceLocation("animepets", "evedie")));
        sounds.put(new ResourceLocation("animepets", "elecsound"), new SoundEvent(new ResourceLocation("animepets", "elecsound")));
        sounds.put(new ResourceLocation("animepets", "voltorbsoud"), new SoundEvent(new ResourceLocation("animepets", "voltorbsoud")));
        sounds.put(new ResourceLocation("animepets", "miltanksd"), new SoundEvent(new ResourceLocation("animepets", "miltanksd")));
        sounds.put(new ResourceLocation("animepets", "plupipsoun"), new SoundEvent(new ResourceLocation("animepets", "plupipsoun")));
        sounds.put(new ResourceLocation("animepets", "danpipl"), new SoundEvent(new ResourceLocation("animepets", "danpipl")));
        sounds.put(new ResourceLocation("animepets", "charmlv"), new SoundEvent(new ResourceLocation("animepets", "charmlv")));
        sounds.put(new ResourceLocation("animepets", "charht"), new SoundEvent(new ResourceLocation("animepets", "charht")));
        sounds.put(new ResourceLocation("animepets", "chardie"), new SoundEvent(new ResourceLocation("animepets", "chardie")));
        sounds.put(new ResourceLocation("animepets", "pikliv"), new SoundEvent(new ResourceLocation("animepets", "pikliv")));
        sounds.put(new ResourceLocation("animepets", "pikdie"), new SoundEvent(new ResourceLocation("animepets", "pikdie")));
        sounds.put(new ResourceLocation("animepets", "pikhurt"), new SoundEvent(new ResourceLocation("animepets", "pikhurt")));
        sounds.put(new ResourceLocation("animepets", "karpdie"), new SoundEvent(new ResourceLocation("animepets", "karpdie")));
        sounds.put(new ResourceLocation("animepets", "karphurt"), new SoundEvent(new ResourceLocation("animepets", "karphurt")));
        sounds.put(new ResourceLocation("animepets", "karpliv"), new SoundEvent(new ResourceLocation("animepets", "karpliv")));
        sounds.put(new ResourceLocation("animepets", "koffingliv"), new SoundEvent(new ResourceLocation("animepets", "koffingliv")));
        sounds.put(new ResourceLocation("animepets", "koffinghurt"), new SoundEvent(new ResourceLocation("animepets", "koffinghurt")));
        sounds.put(new ResourceLocation("animepets", "koffingdie"), new SoundEvent(new ResourceLocation("animepets", "koffingdie")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("animepets").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        AnimepetsMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<Biome>> getBiomes() {
        return this.biomes;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final AnimepetsModElements elements;
        protected final int sortid;

        public ModElement(AnimepetsModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

