/*
 * Decompiled with CFR 0.152.
 */
package dav.mod.objects.blocks.tree;

import dav.mod.Main;
import dav.mod.init.BlockInit;
import dav.mod.init.ItemInit;
import dav.mod.util.interfaces.IHasModel;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockApplePlant
extends Block
implements IGrowable,
IHasModel {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    protected static final AxisAlignedBB[] APPLE_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.9, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.8, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.7, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.5, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.4, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.3, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.2, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.2, 0.25, 0.75, 1.0, 0.75)};
    private int Type;

    public BlockApplePlant(String name, int type) {
        super(Material.field_151585_k);
        this.Type = type;
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149711_c(0.5f);
        this.func_149675_a(true);
        this.func_149649_H();
        BlockInit.BLOCKS.add(this);
        ItemInit.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState upState = worldIn.func_180495_p(pos.func_177984_a());
        if (!upState.func_177230_c().isLeaves(upState, (IBlockAccess)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean isFoliage(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return APPLE_AABB[(Integer)state.func_177229_b((IProperty)this.getAgeProperty())];
    }

    protected PropertyInteger getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty()) >= this.getMaxAge();
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
    }

    protected Item getSeed() {
        switch (this.Type) {
            case 1: {
                return Items.field_151153_ao;
            }
        }
        return Items.field_151034_e;
    }

    protected Item getCrop() {
        switch (this.Type) {
            case 1: {
                return Items.field_151153_ao;
            }
        }
        return Items.field_151034_e;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, 0);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.isMaxAge(state) ? this.getCrop() : null;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getSeed());
    }

    public IBlockState func_176203_a(int meta) {
        return this.withAge(meta);
    }

    public int func_176201_c(IBlockState state) {
        return this.getAge(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        IBlockState upState = worldIn.func_180495_p(pos.func_177984_a());
        if (upState.func_177230_c().isLeaves(upState, (IBlockAccess)worldIn, pos)) {
            float f;
            int i;
            if (worldIn.func_175671_l(pos) >= 8 && (i = this.getAge(state)) < this.getMaxAge() && rand.nextInt((int)(20.0f / (f = BlockApplePlant.getGrowthChance(worldIn, pos))) + 1) == 0) {
                worldIn.func_180501_a(pos, this.withAge(i + 1), 2);
            }
        } else {
            worldIn.func_175655_b(pos, true);
        }
    }

    private static float getGrowthChance(World worldIn, BlockPos pos) {
        boolean flag1;
        float f = 2.0f;
        BlockPos blockpos = pos;
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (iblockstate.func_177230_c().func_176223_P() == air) {
                    f1 = 2.0f;
                }
                if (i != 0 || j != 0) {
                    f1 /= 2.0f;
                }
                f += f1;
            }
        }
        BlockPos blockposN = pos.func_177978_c();
        BlockPos blockposS = pos.func_177968_d();
        BlockPos blockposW = pos.func_177976_e();
        BlockPos blockposE = pos.func_177974_f();
        boolean flag = !BlockApplePlant.isLeavesOrAir(worldIn, blockposN) || !BlockApplePlant.isLeavesOrAir(worldIn, blockposS);
        boolean bl = flag1 = !BlockApplePlant.isLeavesOrAir(worldIn, blockposE) || !BlockApplePlant.isLeavesOrAir(worldIn, blockposW);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = !BlockApplePlant.isLeavesOrAir(worldIn, blockposW.func_177978_c()) || !BlockApplePlant.isLeavesOrAir(worldIn, blockposE.func_177978_c()) || !BlockApplePlant.isLeavesOrAir(worldIn, blockposN.func_177968_d()) || !BlockApplePlant.isLeavesOrAir(worldIn, blockposW.func_177968_d());
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    private static boolean isLeavesOrAir(World worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos) || worldIn.func_180495_p(pos).func_177230_c().isLeaves(worldIn.func_180495_p(pos), (IBlockAccess)worldIn, pos);
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease(worldIn);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.withAge(i), 2);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    @Override
    public void registerModels() {
        Main.proxy.registerModel(Item.func_150898_a((Block)this), 0);
    }
}

