/*
 * Decompiled with CFR 0.152.
 */
package dav.mod.world.gen;

import dav.mod.world.gen.tree.NaturalAppleTreeGen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeForest;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class TreeWorldGen
implements IWorldGenerator {
    private final WorldGenerator APPLE = new NaturalAppleTreeGen();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 1: {
                break;
            }
            case 0: {
                this.runGenerator(this.APPLE, world, random, chunkX, chunkZ, 600.0, -1, 0, BiomePlains.class);
                this.runGenerator(this.APPLE, world, random, chunkX, chunkZ, 350.0, -1, 0, BiomeForest.class);
                break;
            }
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, double chancesToSpawn, int minHeight, int maxHeight, Class<?> ... classes) {
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < 20; ++i) {
            Class<?> biome;
            BlockPos pos = new BlockPos(chunkX * 16 + 10 + random.nextInt(15), minHeight + random.nextInt(heightDiff), chunkZ * 16 + 10 + random.nextInt(15));
            if (minHeight < 0) {
                pos = world.func_175645_m(pos);
            }
            if (!classesList.contains(biome = world.field_73011_w.getBiomeForCoords(pos).getClass()) && classes.length != 0 || random.nextInt((int)chancesToSpawn) != 0) continue;
            generator.func_180709_b(world, random, pos);
        }
    }
}

