/*
 * Decompiled with CFR 0.152.
 */
package dav.mod.world.gen.tree;

import dav.mod.init.BlockInit;
import dav.mod.objects.blocks.tree.BlockApplePlant;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class NaturalAppleTreeGen
extends WorldGenAbstractTree {
    private static final IBlockState LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK);
    private static final IBlockState LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private static final IBlockState APPLE = BlockInit.APPLE_PLANT.func_176223_P().func_177226_a((IProperty)BlockApplePlant.AGE, (Comparable)Integer.valueOf(3));

    public NaturalAppleTreeGen() {
        super(false);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(2) + 5;
        int X = position.func_177958_n();
        int Y = position.func_177956_o();
        int Z = position.func_177952_p();
        boolean flag = true;
        if (Y >= 1 && Y + i + 1 <= 256) {
            for (int j = Y; j <= Y + 1 + i; ++j) {
                int k = 1;
                if (j == Y) {
                    k = 0;
                }
                if (j >= Y + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = X - k; l <= X + k && flag; ++l) {
                    for (int i1 = Z - k; i1 <= Z + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && Y < worldIn.func_72800_K() - i - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, down, position);
                for (int i2 = Y - 3 + i; i2 <= Y + i; ++i2) {
                    int k2 = i2 - (Y + i);
                    int l2 = 1 - k2 / 2;
                    for (int i3 = X - l2; i3 <= X + l2; ++i3) {
                        int j1 = i3 - X;
                        for (int k1 = Z - l2; k1 <= Z + l2; ++k1) {
                            BlockPos blockpos;
                            IBlockState state2;
                            int l1 = k1 - Z;
                            if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.func_180495_p(blockpos = new BlockPos(i3, i2, k1))).func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos) && !state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos)) continue;
                            this.func_175903_a(worldIn, blockpos, LEAF);
                        }
                    }
                }
                for (int j2 = 0; j2 < i; ++j2) {
                    BlockPos upN = position.func_177981_b(j2);
                    IBlockState state2 = worldIn.func_180495_p(upN);
                    if (!state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, upN) && !state2.func_177230_c().isLeaves(state2, (IBlockAccess)worldIn, upN)) continue;
                    this.func_175903_a(worldIn, position.func_177981_b(j2), LOG);
                }
                int cont = 2;
                int appleLayer = i - 4;
                this.func_175903_a(worldIn, position.func_177982_a(1, appleLayer, 1), APPLE);
                this.func_175903_a(worldIn, position.func_177982_a(-1, appleLayer, 2), APPLE);
                for (int xPos = -2; xPos < 3; ++xPos) {
                    for (int zPos = -2; zPos < 3; ++zPos) {
                        if (rand.nextInt(4) != 0 || cont >= 8 || !NaturalAppleTreeGen.isAirOrLeaves(worldIn, position.func_177982_a(xPos, appleLayer, zPos)) || !NaturalAppleTreeGen.isLeaves(worldIn, position.func_177982_a(xPos, appleLayer + 1, zPos))) continue;
                        this.func_175903_a(worldIn, position.func_177982_a(xPos, appleLayer, zPos), APPLE);
                        ++cont;
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean isAirOrLeaves(World worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos) || worldIn.func_180495_p(pos).func_177230_c().isLeaves(worldIn.func_180495_p(pos), (IBlockAccess)worldIn, pos);
    }

    private static boolean isLeaves(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c().isLeaves(worldIn.func_180495_p(pos), (IBlockAccess)worldIn, pos);
    }
}

