/*
 * Decompiled with CFR 0.152.
 */
package dav.mod.world.gen;

import com.google.common.collect.ImmutableList;
import dav.mod.AppleTreesRev;
import dav.mod.config.ConfigInit;
import dav.mod.init.ItemInit;
import dav.mod.world.gen.CustomFeatures;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_2998;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3141;
import net.minecraft.class_3284;
import net.minecraft.class_3297;
import net.minecraft.class_4643;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5464;

public class TreeWorldGen {
    public static void registerFeatures() {
        if (ConfigInit.allowAppleGen) {
            TreeWorldGen.registerFeatureToBiomes(TreeWorldGen.getEntries(ConfigInit.AppleLocations, ConfigInit.AppleChances), TreeVariant.APPLE);
        }
        if (ConfigInit.allowGoldenGen) {
            TreeWorldGen.registerFeatureToBiomes(TreeWorldGen.getEntries(ConfigInit.GoldenLocations, ConfigInit.GoldenChances), TreeVariant.GOLDEN);
        }
        if (ConfigInit.allowEmeraldGen) {
            TreeWorldGen.registerFeatureToBiomes(TreeWorldGen.getEntries(ConfigInit.EmeraldLocations, ConfigInit.EmeraldChances), TreeVariant.EMERALD);
        }
    }

    private static void registerFeatureToBiomes(Object2IntMap<class_2960> Values, TreeVariant Type) {
        class_2960 NonValid = AppleTreesRev.getPath("apple_forest");
        Values.forEach((Id, Chance) -> {
            if (Id.equals((Object)NonValid)) {
                return;
            }
            TreeWorldGen.registerFeatureToBiome(Id.method_12832() + "_" + Type.getName(), class_3031.field_13593.method_23397((class_3037)new class_3141((List)ImmutableList.of((Object)TreeWorldGen.getTree(Type, true).method_23387(0.06f)), TreeWorldGen.getTree(Type, false))).method_23388(CustomFeatures.CustomDecorators.SQUARE_HEIGHTMAP_OCEAN_FLOOR_NO_WATER).method_23388(class_3284.field_25861.method_23475((class_2998)new class_3297(Chance.intValue()))), (class_5321<class_1959>)class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)Id));
        });
    }

    private static Object2IntMap<class_2960> getEntries(List<String> Ids, List<Integer> Chances) {
        Object2IntOpenHashMap Map2 = new Object2IntOpenHashMap();
        int Default = 20;
        Map2.defaultReturnValue(20);
        for (int Index = 0; Index < Ids.size(); ++Index) {
            class_2960 Id = new class_2960(Ids.get(Index));
            if (Map2.containsKey((Object)Id)) continue;
            if (Index < Chances.size()) {
                int Chance = 20;
                try {
                    Chance = Chances.get(Index);
                }
                catch (NumberFormatException e) {
                    System.err.println("Something went wrong Parsing Value - Setting Default");
                    e.printStackTrace();
                }
                Map2.put((Object)Id, Chance <= 0 ? 20 : (Chance <= 500 ? Chance : 20));
                continue;
            }
            Map2.put((Object)Id, 20);
        }
        return Map2;
    }

    private static class_5321<class_2975<?, ?>> registerFeatureToBiome(String ID, class_2975<?, ?> Feature2, class_5321<class_1959> BiomeKey) {
        class_5321 Key = class_5321.method_29179((class_5321)class_2378.field_25914, (class_2960)AppleTreesRev.getPath(ID));
        class_2378.method_10230((class_2378)class_5458.field_25929, (class_2960)Key.method_29177(), Feature2);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{BiomeKey}), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)Key);
        return Key;
    }

    private static class_2975<class_4643, ?> getTree(TreeVariant Type, boolean isFancy) {
        switch (Type) {
            case APPLE: {
                return isFancy ? CustomFeatures.CustomTrees.NATURAL_FANCY_APPLE : CustomFeatures.CustomTrees.NATURAL_APPLE;
            }
            case EMERALD: {
                return isFancy ? CustomFeatures.CustomTrees.NATURAL_FANCY_GOLDEN : CustomFeatures.CustomTrees.NATURAL_GOLDEN;
            }
            case GOLDEN: {
                return isFancy ? CustomFeatures.CustomTrees.NATURAL_FANCY_EMERALD : CustomFeatures.CustomTrees.NATURAL_EMERALD;
            }
        }
        return isFancy ? class_5464.field_26044 : class_5464.field_26036;
    }

    public static enum TreeVariant {
        APPLE(0, "apple"),
        GOLDEN(1, "golden"),
        EMERALD(2, "emerald");

        private final int Type;
        private final String Name;

        private TreeVariant(int Type, String Name) {
            this.Type = Type;
            this.Name = Name;
        }

        public class_1935 getDrop() {
            if (this.Type > 0) {
                return this.Type > 1 ? ItemInit.EMERALD_APPLE : class_1802.field_8463;
            }
            return class_1802.field_8279;
        }

        public String getName() {
            return this.Name;
        }
    }
}

