/*
 * Decompiled with CFR 0.152.
 */
package dav.mod.world.gen;

import com.google.common.collect.Maps;
import dav.mod.AppleTreesRev;
import dav.mod.config.ConfigInit;
import dav.mod.world.gen.PlacedTreesFeatures;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3141;
import net.minecraft.class_3226;
import net.minecraft.class_5321;
import net.minecraft.class_5450;
import net.minecraft.class_5458;
import net.minecraft.class_6646;
import net.minecraft.class_6658;
import net.minecraft.class_6792;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6799;
import net.minecraft.class_6817;
import net.minecraft.class_6819;
import net.minecraft.class_6880;

public class TreeWorldGen {
    private static final HashMap<class_2960, class_6880<class_6796>> APPLE_FEATURES = Maps.newHashMap();
    private static final HashMap<class_2960, class_6880<class_6796>> GOLDEN_FEATURES = Maps.newHashMap();
    private static final HashMap<class_2960, class_6880<class_6796>> EMERALD_FEATURES = Maps.newHashMap();

    public static void registerFeatures() {
        if (ConfigInit.allowAppleGen) {
            TreeWorldGen.registerFeatureToBiomes(APPLE_FEATURES);
        }
        if (ConfigInit.allowGoldenGen) {
            TreeWorldGen.registerFeatureToBiomes(GOLDEN_FEATURES);
        }
        if (ConfigInit.allowEmeraldGen) {
            TreeWorldGen.registerFeatureToBiomes(EMERALD_FEATURES);
        }
    }

    private static void createAndMakeFeatures() {
        TreeWorldGen.getEntries(ConfigInit.AppleLocations, ConfigInit.AppleChances).forEach((ID, Value) -> {
            String Name = "a_" + ID.method_12832();
            class_6880<class_6796> FeatureIn = TreeWorldGen.makeRegistry(Name.concat("_placed"), TreeWorldGen.makeRegistry(Name, class_3031.field_13593, new class_3141(List.of(new class_3226(PlacedTreesFeatures.NATURAL_FANCY_APPLE_PLACED, 0.06f)), PlacedTreesFeatures.NATURAL_APPLE_PLACED)), new class_6797[]{class_6799.method_39659((int)Value), class_5450.method_39639(), class_6819.field_36134, class_6817.field_36081, class_6658.method_39618((class_6646)class_6646.method_39009((class_2680)class_2246.field_10394.method_9564(), (class_2382)class_2338.field_10980)), class_6792.method_39614()});
            APPLE_FEATURES.put((class_2960)ID, FeatureIn);
        });
        TreeWorldGen.getEntries(ConfigInit.GoldenLocations, ConfigInit.GoldenChances).forEach((ID, Value) -> {
            String Name = "g_" + ID.method_12832();
            class_6880<class_6796> FeatureIn = TreeWorldGen.makeRegistry(Name.concat("_placed"), TreeWorldGen.makeRegistry(Name, class_3031.field_13593, new class_3141(List.of(new class_3226(PlacedTreesFeatures.NATURAL_FANCY_GOLDEN_PLACED, 0.06f)), PlacedTreesFeatures.NATURAL_GOLDEN_PLACED)), new class_6797[]{class_6799.method_39659((int)Value), class_5450.method_39639(), class_6819.field_36134, class_6817.field_36081, class_6658.method_39618((class_6646)class_6646.method_39009((class_2680)class_2246.field_10394.method_9564(), (class_2382)class_2338.field_10980)), class_6792.method_39614()});
            GOLDEN_FEATURES.put((class_2960)ID, FeatureIn);
        });
        TreeWorldGen.getEntries(ConfigInit.EmeraldLocations, ConfigInit.EmeraldChances).forEach((ID, Value) -> {
            String Name = "e_" + ID.method_12832();
            class_6880<class_6796> FeatureIn = TreeWorldGen.makeRegistry(Name.concat("_placed"), TreeWorldGen.makeRegistry(Name, class_3031.field_13593, new class_3141(List.of(new class_3226(PlacedTreesFeatures.NATURAL_FANCY_EMERALD_PLACED, 0.06f)), PlacedTreesFeatures.NATURAL_EMERALD_PLACED)), new class_6797[]{class_6799.method_39659((int)Value), class_5450.method_39639(), class_6819.field_36134, class_6817.field_36081, class_6658.method_39618((class_6646)class_6646.method_39009((class_2680)class_2246.field_10394.method_9564(), (class_2382)class_2338.field_10980)), class_6792.method_39614()});
            EMERALD_FEATURES.put((class_2960)ID, FeatureIn);
        });
    }

    private static void registerFeatureToBiomes(Map<class_2960, class_6880<class_6796>> Values2) {
        class_2960 NonValid = AppleTreesRev.getPath("apple_forest");
        Values2.forEach((ID, Feature) -> {
            if (ID.equals((Object)NonValid)) {
                return;
            }
            class_1959 BiomeIn = (class_1959)class_5458.field_25933.method_10223(ID);
            if (BiomeIn != null) {
                TreeWorldGen.insertFeature((class_6880<class_6796>)Feature, (class_5321<class_1959>)((class_5321)class_5458.field_25933.method_29113((Object)BiomeIn).get()));
            }
        });
    }

    private static Object2IntMap<class_2960> getEntries(List<String> Ids, List<Integer> Chances) {
        Object2IntOpenHashMap Map2 = new Object2IntOpenHashMap();
        int Default = 20;
        Map2.defaultReturnValue(20);
        for (int Index = 0; Index < Ids.size(); ++Index) {
            class_2960 Id = new class_2960(Ids.get(Index));
            if (Map2.containsKey((Object)Id)) continue;
            if (Index < Chances.size()) {
                int Chance = 20;
                try {
                    Chance = Chances.get(Index);
                }
                catch (NumberFormatException e) {
                    System.err.println("Something went wrong Parsing Value - Setting Default");
                    e.printStackTrace();
                }
                Map2.put((Object)Id, Chance <= 0 ? 20 : (Chance <= 500 ? Chance : 20));
                continue;
            }
            Map2.put((Object)Id, 20);
        }
        return Map2;
    }

    private static <FC extends class_3037, F extends class_3031<FC>, V> class_6880<V> makeRegistry(String ID, F Feature2, FC Config) {
        return class_5458.method_30562((class_2378)class_5458.field_25929, (class_2960)AppleTreesRev.getPath(ID), (Object)new class_2975(Feature2, Config));
    }

    private static class_6880<class_6796> makeRegistry(String ID, class_6880<? extends class_2975<?, ?>> Feature2, class_6797 ... Modifiers) {
        return TreeWorldGen.makeRegistry(ID, Feature2, List.of(Modifiers));
    }

    private static class_6880<class_6796> makeRegistry(String ID, class_6880<? extends class_2975<?, ?>> Feature2, List<class_6797> Modifiers) {
        return class_5458.method_30562((class_2378)class_5458.field_35761, (class_2960)AppleTreesRev.getPath(ID), (Object)new class_6796(class_6880.method_40221(Feature2), Modifiers));
    }

    private static void insertFeature(class_6880<class_6796> Feature2, class_5321<class_1959> BiomeKey) {
        BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{BiomeKey}), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)((class_5321)Feature2.method_40230().get()));
    }

    static {
        TreeWorldGen.createAndMakeFeatures();
    }
}

