/*
 * Decompiled with CFR 0.152.
 */
package net.dav.appletreesrev.config;

import com.google.common.collect.Lists;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigJsonBuilder {
    private final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private static final List<Character> NotValidChars = Lists.newArrayList((Object[])new Character[]{Character.valueOf('!'), Character.valueOf('|'), Character.valueOf('\ufffd'), Character.valueOf('#'), Character.valueOf('='), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('/'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('\"')});
    private static final Predicate<Character> CharTest = P -> P.equals(Character.valueOf('[')) || P.equals(Character.valueOf(' ')) || NotValidChars.contains(P);
    private final File Config;
    private final List<String> Fields = Lists.newArrayList((Object[])new String[]{"file"});

    public ConfigJsonBuilder(String Path2) {
        this.Config = new File(FabricLoader.getInstance().getConfigDir().toFile(), Path2 + "_config.json");
        this.checkJsonConfig();
    }

    private void checkJsonConfig() {
        if (!this.Config.exists()) {
            this.writeJson(ConfigJsonBuilder.getMain());
        }
    }

    private JsonObject readJson() {
        JsonObject Json = null;
        try {
            BufferedReader Br = new BufferedReader(new FileReader(this.Config));
            Json = JsonParser.parseReader((Reader)Br).getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            System.err.println("Couldn't read configuration file, setting defaults");
            e.printStackTrace();
        }
        if (Json == null) {
            Json = ConfigJsonBuilder.getMain();
        }
        return Json;
    }

    private void writeJson(JsonObject Main) {
        String JsonString = this.GSON.toJson((JsonElement)Main);
        try (FileWriter FileWriter2 = new FileWriter(this.Config);){
            FileWriter2.write(JsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save configuration file, setting defaults");
            e.printStackTrace();
        }
    }

    private static JsonObject getMain() {
        JsonObject Json = new JsonObject();
        Json.addProperty("file", "Apple Trees Rev. - Config. File");
        return Json;
    }

    private JsonArray addCategory(JsonObject Main, String Category2) {
        return this.addCategory(new JsonArray(), Main, Category2);
    }

    private JsonArray addCategory(JsonArray Array, JsonObject Main, String Category2) {
        Main.add(Category2, (JsonElement)Array);
        return Array;
    }

    public void addNewCategory(String Category2) {
        this.checkJsonConfig();
        JsonObject Main = this.readJson();
        if (Main.has(Category2)) {
            return;
        }
        JsonArray Array = new JsonArray();
        Main.add(Category2, (JsonElement)Array);
    }

    public Boolean getBooleanProperty(String Category2, String Comment, String Field, Boolean Default) {
        return (Boolean)this.getProperty(Category2, Comment, Field, Default);
    }

    public Integer getIntProperty(String Category2, String Comment, String Field, Integer Default) {
        return (Integer)this.getProperty(Category2, Comment, Field, Default);
    }

    public Integer getRangeIntProperty(String Category2, String Comment, String Field, Integer Default, Integer MinVal, Integer MaxVal) {
        return ConfigJsonBuilder.range((Integer)this.getProperty(Category2, Comment + " | Range: [" + MinVal + " - " + MaxVal + "]", Field, Default), MaxVal, MinVal);
    }

    public Float getFloatProperty(String Category2, String Comment, String Field, Float Default) {
        return (Float)this.getProperty(Category2, Comment, Field, Default);
    }

    public Float getRangeFloatProperty(String Category2, String Comment, String Field, Float Default, Float MinVal, Float MaxVal) {
        return ConfigJsonBuilder.range((Float)this.getProperty(Category2, Comment + " | Range: [" + MinVal + " - " + MaxVal + "]", Field, Default), MaxVal, MinVal);
    }

    public Double getDoubleProperty(String Category2, String Comment, String Field, Double Default) {
        return (Double)this.getProperty(Category2, Comment, Field, Default);
    }

    public Double getRangeDoubleProperty(String Category2, String Comment, String Field, Double Default, Double MinVal, Double MaxVal) {
        return ConfigJsonBuilder.range((Double)this.getProperty(Category2, Comment + " | Range: [" + MinVal + " - " + MaxVal + "]", Field, Default), MaxVal, MinVal);
    }

    public Character getCharacterProperty(String Category2, String Comment, String Field, Character Default) {
        return (Character)this.getProperty(Category2, Comment, Field, Default);
    }

    public String getStringProperty(String Category2, String Comment, String Field, String Default) {
        return (String)this.getProperty(Category2, Comment, Field, Default);
    }

    private static <T extends Number> T range(T Value, T Max, T Min) {
        return Value.longValue() < Min.longValue() ? Min : (Value.longValue() > Max.longValue() ? Max : Value);
    }

    public void addComment(String Category2, String Comment) {
        this.checkJsonConfig();
        JsonObject Main = this.readJson();
        if (Main.has(Category2)) {
            JsonArray Array = Main.getAsJsonArray(Category2);
            boolean Flag = false;
            for (JsonElement Member : Array) {
                JsonObject M = Member.getAsJsonObject();
                if (!M.has("_comment") || !M.get("_comment").getAsString().equals(Comment)) continue;
                Flag = true;
                break;
            }
            if (!Flag) {
                Array.add((JsonElement)ConfigJsonBuilder.getComment(Comment));
            }
        } else {
            JsonArray Array = this.addCategory(Main, Category2);
            Array.add((JsonElement)ConfigJsonBuilder.getComment(Comment));
        }
        if (!this.Fields.contains(Category2)) {
            this.Fields.add(Category2);
        }
        this.writeJson(Main);
    }

    private Object getProperty(String Category2, String Comment, String Field, Object Default) {
        try {
            this.checkJsonConfig();
            JsonObject Main = this.readJson();
            Object Value = Default;
            if (Main.has(Category2)) {
                JsonArray Array = Main.getAsJsonArray(Category2);
                boolean Flag = false;
                for (JsonElement Member : Array) {
                    JsonObject M = Member.getAsJsonObject();
                    if (!M.has(Field)) continue;
                    Value = this.getCorrectValue(M, Field, Default);
                    Flag = true;
                    break;
                }
                if (!Flag) {
                    Array.add((JsonElement)this.writeObject(Comment, Field, Default));
                }
            } else {
                JsonArray Array = this.addCategory(Main, Category2);
                Array.add((JsonElement)this.writeObject(Comment, Field, Default));
            }
            if (!this.Fields.contains(Category2)) {
                this.Fields.add(Category2);
            }
            this.writeJson(Main);
            return Value;
        }
        catch (Exception e) {
            System.err.println("Couldn't read configuration file, setting defaults");
            e.printStackTrace();
            return Default;
        }
    }

    private static JsonObject getComment(String Comment) {
        JsonObject JsonComment = new JsonObject();
        JsonComment.addProperty("_comment", Comment);
        return JsonComment;
    }

    private Object getCorrectValue(JsonObject Member, String Field, Object Default) {
        if (Default instanceof Boolean) {
            return Member.get(Field).getAsBoolean();
        }
        if (Default instanceof Integer) {
            return Member.get(Field).getAsInt();
        }
        if (Default instanceof Float) {
            return Float.valueOf(Member.get(Field).getAsFloat());
        }
        if (Default instanceof Double) {
            return Member.get(Field).getAsDouble();
        }
        if (Default instanceof Character) {
            return Character.valueOf(Member.get(Field).getAsString().charAt(0));
        }
        return Member.get(Field).getAsString();
    }

    private JsonObject writeObject(String Comment, String Field, Object Default) {
        JsonObject Json = new JsonObject();
        Json.addProperty("_comment", Comment + " | [Default: " + Default.toString() + "]");
        if (Default instanceof Boolean) {
            Json.addProperty(Field, (Boolean)Default);
        } else if (Default instanceof Integer) {
            Json.addProperty(Field, (Number)((Integer)Default));
        } else if (Default instanceof Float) {
            Json.addProperty(Field, (Number)((Float)Default));
        } else if (Default instanceof Double) {
            Json.addProperty(Field, (Number)((Double)Default));
        } else if (Default instanceof Character) {
            Json.addProperty(Field, (Character)Default);
        } else {
            Json.addProperty(Field, (String)Default);
        }
        return Json;
    }

    public List<Boolean> getBooleanListProperty(String Category2, String Comment, String Field, List<Boolean> Default) {
        ArrayList<Boolean> List2 = new ArrayList<Boolean>();
        this.getListFromString(Category2, Comment, Field, Default).forEach(String2 -> List2.add(Boolean.valueOf(String2)));
        return List2;
    }

    public List<Integer> getIntegerListProperty(String Category2, String Comment, String Field, List<Integer> Default) {
        ArrayList<Integer> List2 = new ArrayList<Integer>();
        this.getListFromString(Category2, Comment, Field, Default).forEach(String2 -> {
            try {
                List2.add(Double.valueOf(String2).intValue());
            }
            catch (NumberFormatException e) {
                System.err.println("Not a Valid Value, Skipping");
                e.printStackTrace();
            }
        });
        return List2;
    }

    public List<Float> getFloatListProperty(String Category2, String Comment, String Field, List<Float> Default) {
        ArrayList<Float> List2 = new ArrayList<Float>();
        this.getListFromString(Category2, Comment, Field, Default).forEach(String2 -> {
            try {
                List2.add(Float.valueOf(Double.valueOf(String2).floatValue()));
            }
            catch (NumberFormatException e) {
                System.err.println("Not a Valid Value, Skipping");
                e.printStackTrace();
            }
        });
        return List2;
    }

    public List<Double> getDoubleListProperty(String Category2, String Comment, String Field, List<Double> Default) {
        ArrayList<Double> List2 = new ArrayList<Double>();
        this.getListFromString(Category2, Comment, Field, Default).forEach(String2 -> {
            try {
                List2.add(Double.valueOf(String2));
            }
            catch (NumberFormatException e) {
                System.err.println("Not a Valid Value, Skipping");
                e.printStackTrace();
            }
        });
        return List2;
    }

    public List<Character> getCharacterListProperty(String Category2, String Comment, String Field, List<Character> Default) {
        ArrayList<Character> List2 = new ArrayList<Character>();
        this.getListFromString(Category2, Comment, Field, Default).forEach(String2 -> List2.add(Character.valueOf(String2.charAt(0))));
        return List2;
    }

    public List<String> getStringListProperty(String Category2, String Comment, String Field, List<String> Default) {
        return this.getListFromString(Category2, Comment, Field, Default);
    }

    private <T> List<String> getListFromString(String Category2, String Comment, String Field, List<T> Default) {
        String ValueOfString = this.getStringProperty(Category2, Comment, Field, Default.toString());
        ArrayList<String> List2 = new ArrayList<String>();
        Object Current = "";
        for (int Index = 0; Index < ValueOfString.length(); ++Index) {
            char l = ValueOfString.charAt(Index);
            if (CharTest.test(Character.valueOf(l))) continue;
            if (l == ',' || l == ']') {
                if (((String)Current).length() <= 0) continue;
                List2.add((String)Current);
                Current = "";
                continue;
            }
            Current = (String)Current + l;
            if (Index != ValueOfString.length() - 1) continue;
            List2.add((String)Current);
        }
        return List2;
    }

    public void cleanJson() {
        try {
            this.checkJsonConfig();
            JsonObject Main = this.readJson();
            ArrayList NonValid = Lists.newArrayList();
            Main.entrySet().forEach(Entry2 -> {
                String Key = (String)Entry2.getKey();
                if (!this.Fields.contains(Key)) {
                    NonValid.add(Key);
                }
            });
            if (!NonValid.isEmpty()) {
                NonValid.forEach(Key -> Main.remove(Key));
                this.writeJson(Main);
            }
        }
        catch (ConcurrentModificationException e) {
            System.err.println("Couldn't remove Non Valid Fields");
            e.printStackTrace();
        }
    }
}

