/*
 * Decompiled with CFR 0.152.
 */
package dav.mod;

import dav.mod.init.BlockInit;
import dav.mod.init.CustomTree;
import dav.mod.init.ItemInit;
import dav.mod.objects.blocks.tree.AppleBlockPlant;
import dav.mod.objects.blocks.tree.CustomBlockSapling;
import dav.mod.world.gen.TreeWorldGen;
import dav.mod.world.gen.tree.AppleTreeFeature;
import dav.mod.world.gen.tree.GoldAppleTreeFeature;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="appletreesrev")
public class Main {
    public static final String MODID = "appletreesrev";
    public static Main instance;
    public static final Logger LOGGER;

    public Main() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientRegistries);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        TreeWorldGen.setupTreeGeneration();
        LOGGER.info("CommonSetup Registered.");
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        LOGGER.info("clientRegistries Registered.");
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ItemInit.APPLE_SAPLING = (Item)new BlockItem(BlockInit.APPLE_SAPLING, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName(BlockInit.APPLE_SAPLING.getRegistryName()), ItemInit.GAPPLE_SAPLING = (Item)new BlockItem(BlockInit.GAPPLE_SAPLING, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName(BlockInit.GAPPLE_SAPLING.getRegistryName())});
            LOGGER.info("Items Registered.");
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{BlockInit.APPLE_PLANT = (Block)new AppleBlockPlant(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_185850_c), Items.field_151034_e).setRegistryName(RegistryEvents.getPath("apple_plant")), BlockInit.GAPPLE_PLANT = (Block)new AppleBlockPlant(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_185850_c), Items.field_151153_ao).setRegistryName(RegistryEvents.getPath("gapple_plant")), BlockInit.APPLE_SAPLING = (Block)new CustomBlockSapling(new CustomTree(new AppleTreeFeature(NoFeatureConfig::func_214639_a)), Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_185850_c)).setRegistryName(RegistryEvents.getPath("apple_sapling")), BlockInit.GAPPLE_SAPLING = (Block)new CustomBlockSapling(new CustomTree(new GoldAppleTreeFeature(NoFeatureConfig::func_214639_a)), Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_185850_c)).setRegistryName(RegistryEvents.getPath("gapple_sapling"))});
            LOGGER.info("Blocks Registered.");
        }

        public static ResourceLocation getPath(String path) {
            return new ResourceLocation(Main.MODID, path);
        }
    }
}

