/*
 * Decompiled with CFR 0.152.
 */
package dav.mod.objects.blocks.tree;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class AppleBlockPlant
extends Block
implements IGrowable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208170_W;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)10.0, (double)16.0, (double)10.0, (double)6.0, (double)13.0, (double)6.0), Block.func_208617_a((double)10.0, (double)16.0, (double)10.0, (double)6.0, (double)11.0, (double)6.0), Block.func_208617_a((double)11.0, (double)16.0, (double)11.0, (double)4.0, (double)9.5, (double)4.0), Block.func_208617_a((double)12.0, (double)16.0, (double)12.0, (double)4.0, (double)6.0, (double)4.0), Block.func_208617_a((double)12.0, (double)16.0, (double)12.0, (double)3.0, (double)4.0, (double)3.0), Block.func_208617_a((double)14.0, (double)16.0, (double)14.0, (double)2.0, (double)3.0, (double)2.0), Block.func_208617_a((double)15.0, (double)16.0, (double)15.0, (double)1.0, (double)1.0, (double)1.0), Block.func_208617_a((double)15.0, (double)16.0, (double)15.0, (double)1.0, (double)1.0, (double)1.0)};
    private Item drop;

    public AppleBlockPlant(Block.Properties properties, Item drop) {
        super(properties.func_200942_a().func_200948_a(0.4f, 0.0f).func_200944_c());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
        this.drop = drop;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockState upState = worldIn.func_180495_p(pos.func_177984_a());
        if (!upState.func_203425_a(BlockTags.field_206952_E)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_BY_AGE[(Integer)state.func_177229_b((IProperty)this.getAgeProperty())];
    }

    protected boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177230_c() == Blocks.field_150458_ak;
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty()) >= this.getMaxAge();
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        BlockState upState = worldIn.func_180495_p(pos.func_177984_a());
        if (upState.func_203425_a(BlockTags.field_206952_E)) {
            float f;
            int i;
            if (worldIn.func_201669_a(pos, 0) >= 9 && (i = this.getAge(state)) < this.getMaxAge() && random.nextInt((int)(20.0f / (f = AppleBlockPlant.getGrowthChance(this, (IBlockReader)worldIn, pos))) + 1) == 0) {
                worldIn.func_180501_a(pos, this.withAge(i + 1), 2);
            }
        } else {
            worldIn.func_175655_b(pos, true);
        }
    }

    public void grow(World worldIn, BlockPos pos, BlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease(worldIn);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.withAge(i), 2);
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
    }

    protected static float getGrowthChance(Block blockIn, IBlockReader worldIn, BlockPos pos) {
        boolean flag1;
        float f = 2.0f;
        BlockPos blockpos = pos;
        BlockState air = Blocks.field_150350_a.func_176223_P();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState iblockstate = worldIn.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (iblockstate.func_177230_c().func_176223_P() == air) {
                    f1 = 2.0f;
                }
                if (i != 0 || j != 0) {
                    f1 /= 2.0f;
                }
                f += f1;
            }
        }
        BlockPos blockposN = pos.func_177978_c();
        BlockPos blockposS = pos.func_177968_d();
        BlockPos blockposW = pos.func_177976_e();
        BlockPos blockposE = pos.func_177974_f();
        boolean flag = !AppleBlockPlant.isLeavesOrAir(worldIn, blockposN) || !AppleBlockPlant.isLeavesOrAir(worldIn, blockposS);
        boolean bl = flag1 = !AppleBlockPlant.isLeavesOrAir(worldIn, blockposE) || !AppleBlockPlant.isLeavesOrAir(worldIn, blockposW);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = !AppleBlockPlant.isLeavesOrAir(worldIn, blockposW.func_177978_c()) || !AppleBlockPlant.isLeavesOrAir(worldIn, blockposE.func_177978_c()) || !AppleBlockPlant.isLeavesOrAir(worldIn, blockposN.func_177968_d()) || !AppleBlockPlant.isLeavesOrAir(worldIn, blockposW.func_177968_d());
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    private static boolean isLeavesOrAir(IBlockReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_196958_f() || worldIn.func_180495_p(pos).func_203425_a(BlockTags.field_206952_E);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_201669_a(pos, 0) >= 8 || worldIn.func_217337_f(pos);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof RavagerEntity && ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)entityIn)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    protected IItemProvider getSeedsItem() {
        return this.drop;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack(this.getSeedsItem());
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, BlockState state) {
        this.grow(worldIn, pos, state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE});
    }
}

