/*
 * Decompiled with CFR 0.152.
 */
package dav.mod.world.gen.tree;

import com.mojang.datafixers.Dynamic;
import dav.mod.init.BlockInit;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class AppleTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = Blocks.field_196617_K.func_176223_P();
    private static final BlockState LEAF = Blocks.field_196642_W.func_176223_P();
    private static final BlockState PLANT = BlockInit.APPLE_PLANT.func_176223_P();

    public AppleTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn, false);
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox p_208519_5_) {
        int i = rand.nextInt(2) + 5;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (AppleTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (AppleTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)this.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - i - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                for (int l1 = position.func_177956_o() - 3 + i; l1 <= position.func_177956_o() + i; ++l1) {
                    int j2 = l1 - (position.func_177956_o() + i);
                    int k2 = 1 - j2 / 2;
                    for (int l2 = position.func_177958_n() - k2; l2 <= position.func_177958_n() + k2; ++l2) {
                        int i3 = l2 - position.func_177958_n();
                        for (int j1 = position.func_177952_p() - k2; j1 <= position.func_177952_p() + k2; ++j1) {
                            BlockPos blockpos;
                            int k1 = j1 - position.func_177952_p();
                            if (Math.abs(i3) == k2 && Math.abs(k1) == k2 && (rand.nextInt(2) == 0 || j2 == 0) || !AppleTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)(blockpos = new BlockPos(l2, l1, j1)))) continue;
                            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, blockpos, LEAF, p_208519_5_);
                        }
                    }
                }
                int cont = 2;
                int appleLayer = i - 4;
                this.func_202278_a((IWorldWriter)worldIn, position.func_177982_a(1, appleLayer, 1), PLANT);
                this.func_202278_a((IWorldWriter)worldIn, position.func_177982_a(-1, appleLayer, 2), PLANT);
                for (int xPos = -2; xPos < 3; ++xPos) {
                    for (int zPos = -2; zPos < 3; ++zPos) {
                        if (xPos == zPos || xPos == -zPos || rand.nextInt(4) != 0 || cont > 8 || AppleTreeFeature.isLog((IWorldGenerationBaseReader)worldIn, position)) continue;
                        this.func_202278_a((IWorldWriter)worldIn, position.func_177982_a(xPos, appleLayer, zPos), PLANT);
                        ++cont;
                    }
                }
                for (int i2 = 0; i2 < i; ++i2) {
                    if (!AppleTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177981_b(i2))) continue;
                    this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177981_b(i2), LOG, p_208519_5_);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected static boolean isLog(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, Block2 -> Block2.func_203425_a(BlockTags.field_200031_h));
    }
}

