/*
 * Decompiled with CFR 0.152.
 */
package dav.mod.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigBuilder {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final Recipes RECIPES = new Recipes(BUILDER);
    public static final Plants PLANTS = new Plants(BUILDER);
    public static final WorldLoot LOOT = new WorldLoot(BUILDER);
    public static final AppleTreeGen APPLE_GEN = new AppleTreeGen(BUILDER);
    public static final GoldenTreeGen GOLDEN_GEN = new GoldenTreeGen(BUILDER);
    public static final EmeraldTreeGen EMERALD_GEN = new EmeraldTreeGen(BUILDER);
    public static final Biome BIOME = new Biome(BUILDER);
    public static final ForgeConfigSpec SPEC = BUILDER.build();

    public static class Recipes {
        public final ForgeConfigSpec.ConfigValue<Boolean> GoldAppleSaplingRecipe;
        public final ForgeConfigSpec.ConfigValue<Boolean> EmeraldAppleSaplingRecipe;
        public final ForgeConfigSpec.ConfigValue<Boolean> NotchAppleRecipe;

        public Recipes(ForgeConfigSpec.Builder Builder2) {
            Builder2.push("Recipes");
            this.GoldAppleSaplingRecipe = Builder2.comment("[Enable/Disable] Gold Apple Sapling Recipe [true/false] | [Default: false]").define("GoldAppleSaplingRecipe", false);
            this.EmeraldAppleSaplingRecipe = Builder2.comment("[Enable/Disable] Emerald Apple Sapling Recipe [true/false] | [Default: false]").define("EmeraldAppleSaplingRecipe", false);
            this.NotchAppleRecipe = Builder2.comment("[Enable/Disable] Notch Apple Recipe [true/false] | [Default: false]").define("NotchAppleRecipe", false);
            Builder2.pop();
        }
    }

    public static class Plants {
        public final ForgeConfigSpec.ConfigValue<Boolean> useEasyHarvest;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowBonemeal;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowAppleBonemeal;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowGoldenBonemeal;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowEmeraldBonemeal;

        public Plants(ForgeConfigSpec.Builder Builder2) {
            Builder2.push("Plants Config");
            this.useEasyHarvest = Builder2.comment("[Enable/Disable] Right Click Harvest on Any Apple Plant [true/false] | [Default: true]").define("useEasyHarvest", true);
            this.allowBonemeal = Builder2.comment("[Enable/Disable] Bonemeal use on Any Apple Plant (Override Individual Options) [true/false] | [Default: true]").define("allowBonemeal", true);
            this.allowAppleBonemeal = Builder2.comment("[Enable/Disable] Bonemeal use on Apple Plants [true/false] | [Default: true]").define("allowAppleBonemeal", true);
            this.allowGoldenBonemeal = Builder2.comment("[Enable/Disable] Bonemeal use on Golden Apple Plants [true/false] | [Default: true]").define("allowGoldenBonemeal", true);
            this.allowEmeraldBonemeal = Builder2.comment("[Enable/Disable] Bonemeal use on Emerald Apple Plants [true/false] | [Default: true]").define("allowEmeraldBonemeal", true);
            Builder2.pop();
        }
    }

    public static class WorldLoot {
        public final ForgeConfigSpec.ConfigValue<Boolean> allowWorldLoot;

        public WorldLoot(ForgeConfigSpec.Builder Builder2) {
            Builder2.push("World loot");
            this.allowWorldLoot = Builder2.comment("[Enable/Disable] Lootable content on Chests [true/false] | [Default: true]").define("allowWorldLoot", true);
            Builder2.pop();
        }
    }

    public static class AppleTreeGen {
        public final ForgeConfigSpec.ConfigValue<Boolean> AllowAppleTrees;
        public final ForgeConfigSpec.ConfigValue<List<String>> Locations;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> Chances;

        public AppleTreeGen(ForgeConfigSpec.Builder Builder2) {
            Builder2.push("Apple Tree Generation");
            Builder2.define("NOTE", (Object)"Custom biomes may could work, Use: [modid]:[biome_name] | Higher numbers has lesser chance | Unregistered values will be set to Default | Values accepted [1 - 500]");
            this.AllowAppleTrees = Builder2.comment("[Enable/Disable] Natural Apple Trees generation [true/false] | [Default: true]").define("AllowAppleTrees", true);
            this.Locations = Builder2.comment("Register the biomes to Spawn Apple Trees").define("Locations", (Object)Lists.newArrayList((Object[])new String[]{"plains", "sunflower_plains", "flower_forest", "forest", "dark_forest", "wooded_mountains"}));
            this.Chances = Builder2.comment("Register the Chances of each registered Biome").define("Chances", (Object)Lists.newArrayList((Object[])new Integer[]{18, 16, 1, 6, 7, 12}));
            Builder2.pop();
        }
    }

    public static class GoldenTreeGen {
        public final ForgeConfigSpec.ConfigValue<Boolean> AllowGoldenTrees;
        public final ForgeConfigSpec.ConfigValue<List<String>> Locations;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> Chances;

        public GoldenTreeGen(ForgeConfigSpec.Builder Builder2) {
            Builder2.push("Golden Tree Generation");
            this.AllowGoldenTrees = Builder2.comment("[Enable/Disable] Natural Golden Trees generation [true/false] | [Default: false]").define("AllowGoldenTrees", false);
            this.Locations = Builder2.comment("Register the biomes to Spawn Golden Trees").define("Locations", (Object)Lists.newArrayList());
            this.Chances = Builder2.comment("Register the Chances of each registered Biome").define("Chances", (Object)Lists.newArrayList());
            Builder2.pop();
        }
    }

    public static class EmeraldTreeGen {
        public final ForgeConfigSpec.ConfigValue<Boolean> AllowEmeraldTrees;
        public final ForgeConfigSpec.ConfigValue<List<String>> Locations;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> Chances;

        public EmeraldTreeGen(ForgeConfigSpec.Builder Builder2) {
            Builder2.push("Emerald Tree Generation");
            this.AllowEmeraldTrees = Builder2.comment("[Enable/Disable] Natural Golden Trees generation [true/false] | [Default: true]").define("AllowEmeraldTrees", true);
            this.Locations = Builder2.comment("Register the biomes to Spawn Golden Trees").define("Locations", (Object)Lists.newArrayList((Object[])new String[]{"flower_forest"}));
            this.Chances = Builder2.comment("Register the Chances of each registered Biome").define("Chances", (Object)Lists.newArrayList((Object[])new Integer[]{75}));
            Builder2.pop();
        }
    }

    public static class Biome {
        public final ForgeConfigSpec.ConfigValue<Integer> BiomeChance;

        public Biome(ForgeConfigSpec.Builder Builder2) {
            Builder2.push("Biome Config");
            this.BiomeChance = Builder2.comment("Define Apple Forest spawn Value on the overworld").defineInRange("BiomeChance", (Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(30), Integer.class);
            Builder2.define("Biomes", (Object)ForgeRegistries.BIOMES.getKeys().toString());
            Builder2.pop();
        }
    }
}

