/*
 * Decompiled with CFR 0.152.
 */
package dav.mod.world.biome;

import dav.mod.world.gen.CustomFeatures;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.Features;
import net.minecraft.data.worldgen.StructureFeatures;
import net.minecraft.data.worldgen.SurfaceBuilders;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class CustomBiomeMaker {
    private static MobSpawnSettings.Builder defaultSpawns() {
        MobSpawnSettings.Builder MobSpawnInfo = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)MobSpawnInfo);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)MobSpawnInfo);
        return MobSpawnInfo;
    }

    public static Biome makeAppleForestBiome() {
        MobSpawnSettings.Builder MobSpawnInfo = CustomBiomeMaker.defaultSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4)).m_48367_();
        BiomeGenerationSettings.Builder BiomeGen = new BiomeGenerationSettings.Builder().m_47851_(SurfaceBuilders.f_127285_);
        BiomeDefaultFeatures.m_126777_((BiomeGenerationSettings.Builder)BiomeGen);
        BiomeGen.m_47849_(StructureFeatures.f_127263_);
        BiomeDefaultFeatures.m_126790_((BiomeGenerationSettings.Builder)BiomeGen);
        BiomeDefaultFeatures.m_126798_((BiomeGenerationSettings.Builder)BiomeGen);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)BiomeGen);
        BiomeGen.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, CustomFeatures.APPLE_FOREST_TREES);
        BiomeGen.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, CustomFeatures.GOLDEN_FOREST_TREES);
        BiomeGen.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, CustomFeatures.EMERALD_FOREST_TREES);
        BiomeGen.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, CustomFeatures.GENERIC_TREES);
        BiomeGen.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, Features.f_127017_);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)BiomeGen);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)BiomeGen);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)BiomeGen);
        BiomeGen.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, CustomFeatures.FOREST_GRASS);
        BiomeGen.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, CustomFeatures.FOREST_FLOWERS);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)BiomeGen);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)BiomeGen);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)BiomeGen);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)BiomeGen);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.FOREST).m_47593_(0.15f).m_47607_(0.25f).m_47609_(1.7f).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(CustomBiomeMaker.calculateSkyColor(1.7f)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(MobSpawnInfo.m_48381_()).m_47601_(BiomeGen.m_47831_()).m_47592_();
    }

    private static int calculateSkyColor(float Temp) {
        float TempMod = Temp / 3.0f;
        TempMod = Mth.m_14036_((float)TempMod, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - TempMod * 0.05f), (float)(0.5f + TempMod * 0.1f), (float)1.0f);
    }
}

