/*
 * Decompiled with CFR 0.152.
 */
package dav.mod.world.gen;

import com.google.common.collect.ImmutableList;
import dav.mod.AppleTreesRev;
import dav.mod.config.ConfigBuilder;
import dav.mod.init.BiomeInit;
import dav.mod.world.gen.CustomFeatures;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DecoratorConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.ChanceDecoratorConfiguration;
import net.minecraft.world.level.levelgen.placement.FeatureDecorator;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TreeWorldGen {
    private static boolean isRegistered = false;
    private static Object2IntMap<ResourceLocation> AppleGen = null;
    private static Object2IntMap<ResourceLocation> GoldenGen = null;
    private static Object2IntMap<ResourceLocation> EmeraldGen = null;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void setupTreeGeneration(BiomeLoadingEvent Event) {
        if (!isRegistered) {
            AppleGen = TreeWorldGen.mergeLocationsValues((List)ConfigBuilder.APPLE_GEN.Locations.get(), (List)ConfigBuilder.APPLE_GEN.Chances.get());
            GoldenGen = TreeWorldGen.mergeLocationsValues((List)ConfigBuilder.GOLDEN_GEN.Locations.get(), (List)ConfigBuilder.GOLDEN_GEN.Chances.get());
            EmeraldGen = TreeWorldGen.mergeLocationsValues((List)ConfigBuilder.EMERALD_GEN.Locations.get(), (List)ConfigBuilder.EMERALD_GEN.Chances.get());
            isRegistered = true;
        }
        BiomeGenerationSettingsBuilder Gen = Event.getGeneration();
        ResourceLocation Evt = Event.getName();
        if (Evt.equals((Object)BiomeInit.APPLE_FOREST.getRegistryName())) {
            return;
        }
        if (AppleGen.containsKey((Object)Evt)) {
            TreeWorldGen.registerTo(Gen, Feature.f_65754_.m_65815_((FeatureConfiguration)new RandomFeatureConfiguration((List)ImmutableList.of((Object)CustomFeatures.CustomTrees.NATURAL_FANCY_APPLE.m_65383_(0.06f)), CustomFeatures.CustomTrees.NATURAL_APPLE)).m_7679_(CustomFeatures.CustomDecorators.HEIGHTMAP_WITH_TREE_THRESHOLD_SQUARED).m_7679_(FeatureDecorator.f_70682_.m_70720_((DecoratorConfiguration)new ChanceDecoratorConfiguration(AppleGen.getInt((Object)Evt)))));
        }
        if (GoldenGen.containsKey((Object)Evt)) {
            TreeWorldGen.registerTo(Gen, Feature.f_65754_.m_65815_((FeatureConfiguration)new RandomFeatureConfiguration((List)ImmutableList.of((Object)CustomFeatures.CustomTrees.NATURAL_FANCY_GOLDEN.m_65383_(0.06f)), CustomFeatures.CustomTrees.NATURAL_GOLDEN)).m_7679_(CustomFeatures.CustomDecorators.HEIGHTMAP_WITH_TREE_THRESHOLD_SQUARED).m_7679_(FeatureDecorator.f_70682_.m_70720_((DecoratorConfiguration)new ChanceDecoratorConfiguration(AppleGen.getInt((Object)Evt)))));
        }
        if (EmeraldGen.containsKey((Object)Evt)) {
            TreeWorldGen.registerTo(Gen, Feature.f_65754_.m_65815_((FeatureConfiguration)new RandomFeatureConfiguration((List)ImmutableList.of((Object)CustomFeatures.CustomTrees.NATURAL_FANCY_EMERALD.m_65383_(0.06f)), CustomFeatures.CustomTrees.NATURAL_EMERALD)).m_7679_(CustomFeatures.CustomDecorators.HEIGHTMAP_WITH_TREE_THRESHOLD_SQUARED).m_7679_(FeatureDecorator.f_70682_.m_70720_((DecoratorConfiguration)new ChanceDecoratorConfiguration(AppleGen.getInt((Object)Evt)))));
        }
    }

    private static Object2IntMap<ResourceLocation> mergeLocationsValues(List<String> Locations, List<Integer> Chances) {
        Object2IntOpenHashMap Map2 = new Object2IntOpenHashMap();
        int Default = 20;
        Map2.defaultReturnValue(20);
        for (int Index = 0; Index < Locations.size(); ++Index) {
            ResourceLocation Loc = new ResourceLocation(Locations.get(Index));
            if (Map2.containsKey((Object)Loc)) continue;
            if (Index < Chances.size()) {
                int Chance = 20;
                try {
                    Chance = Chances.get(Index);
                }
                catch (NumberFormatException e) {
                    AppleTreesRev.LOGGER.error("Something went wrong Parsing Value - Setting Default");
                    e.printStackTrace();
                }
                Map2.put((Object)Loc, Chance <= 0 ? 20 : (Chance <= 500 ? Chance : 20));
                continue;
            }
            Map2.put((Object)Loc, 20);
        }
        return Map2;
    }

    private static void registerTo(BiomeGenerationSettingsBuilder Builder2, ConfiguredFeature<?, ?> Feature2) {
        Builder2.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, Feature2);
    }
}

