/*
 * Decompiled with CFR 0.152.
 */
package dav.mod.world.loot;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import dav.mod.AppleTreesRev;
import dav.mod.init.ItemInit;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GlobalLootModifiers {
    public static void registerModifiers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> Event) {
        Event.getRegistry().register((IForgeRegistryEntry)new LuckyGlobalModifier.Serializer().setRegistryName(AppleTreesRev.getPath("lucky_harvest")));
    }

    private static class LuckyGlobalModifier
    extends LootModifier {
        private static final List<Item> NonApp = ImmutableList.of((Object)Items.f_42405_, (Object)Items.f_42732_, (Object)Items.f_42410_, (Object)Items.f_42436_, (Object)ItemInit.EMERALD_APPLE);

        protected LuckyGlobalModifier(ResourceLocation Name, LootItemCondition[] Conditions) {
            super(Conditions);
        }

        protected List<ItemStack> doApply(List<ItemStack> LootIn, LootContext Context) {
            Player Player2;
            Entity Entity2 = (Entity)Context.m_78953_(LootContextParams.f_81455_);
            if (Entity2 instanceof Player && !LuckyGlobalModifier.isContainerBlockEntityOrEntity(Context) && (Player2 = (Player)Entity2).m_21023_(MobEffects.f_19621_)) {
                Random Rand = Context.m_78933_();
                int FortunePlus = Player2.m_21124_(MobEffects.f_19621_).m_19564_() + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44987_, (LivingEntity)Player2) + 2;
                int Aux = FortunePlus < 1 ? 1 : FortunePlus;
                LootIn.forEach(StackInstance -> {
                    Item ItemIn = StackInstance.m_41720_();
                    if (ItemIn instanceof BlockItem || NonApp.contains(ItemIn)) {
                        return;
                    }
                    StackInstance.m_41764_(StackInstance.m_41613_() + Rand.nextInt(Aux));
                });
            }
            return LootIn;
        }

        private static boolean isContainerBlockEntityOrEntity(LootContext Context) {
            BlockEntity Tile = (BlockEntity)Context.m_78953_(LootContextParams.f_81462_);
            BlockState State = (BlockState)Context.m_78953_(LootContextParams.f_81461_);
            BlockPos Pos = new BlockPos((Vec3)Context.m_78953_(LootContextParams.f_81460_));
            ServerLevel World = Context.m_78952_();
            return Tile != null || State == null || World.m_7702_(Pos) != null || World.m_8055_(Pos).m_155947_();
        }

        private static class Serializer
        extends GlobalLootModifierSerializer<LuckyGlobalModifier> {
            private JsonObject Instance;

            private Serializer() {
            }

            public LuckyGlobalModifier read(ResourceLocation Name, JsonObject Json, LootItemCondition[] Conditions) {
                this.Instance = Json;
                return new LuckyGlobalModifier(Name, Conditions);
            }

            public JsonObject write(LuckyGlobalModifier Instance2) {
                return this.Instance;
            }
        }
    }
}

