/*
 * Decompiled with CFR 0.152.
 */
package dav.mod;

import dav.mod.client.ClientHandler;
import dav.mod.config.ConfigBuilder;
import dav.mod.crafting.SimpleCondition;
import dav.mod.init.BiomeInit;
import dav.mod.init.BlockInit;
import dav.mod.init.ItemInit;
import dav.mod.objects.items.AppleGroup;
import dav.mod.util.LootTableHandler;
import dav.mod.util.RegistryHandler;
import dav.mod.world.gen.TreeWorldGen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="appletreesrev")
public class AppleTreesRev {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "appletreesrev";
    public static final CreativeModeTab APPLE = new AppleGroup();

    public AppleTreesRev() {
        IEventBus EventBus = FMLJavaModLoadingContext.get().getModEventBus();
        EventBus.addListener(this::commonSetup);
        EventBus.addListener(this::clientSetup);
        RegistryHandler.registry(EventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(LootTableHandler.class);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigBuilder.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent Event) {
        MinecraftForge.EVENT_BUS.register(TreeWorldGen.class);
        CraftingHelper.register((IConditionSerializer)new SimpleCondition(AppleTreesRev.getPath("gapplerecipecondition"), (Boolean)ConfigBuilder.RECIPES.GoldAppleSaplingRecipe.get()));
        CraftingHelper.register((IConditionSerializer)new SimpleCondition(AppleTreesRev.getPath("eapplerecipecondition"), (Boolean)ConfigBuilder.RECIPES.EmeraldAppleSaplingRecipe.get()));
        CraftingHelper.register((IConditionSerializer)new SimpleCondition(AppleTreesRev.getPath("notchrecipecondition"), (Boolean)ConfigBuilder.RECIPES.NotchAppleRecipe.get()));
        Event.enqueueWork(BiomeInit::registerBiome);
        BlockInit.addExtraInfo();
        ItemInit.addExtraInfo();
    }

    private void clientSetup(FMLClientSetupEvent Event) {
        ClientHandler.setupClientRender();
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent Event) {
    }

    public static ResourceLocation getPath(String Name) {
        return new ResourceLocation(MOD_ID, Name);
    }
}

