/*
 * Decompiled with CFR 0.152.
 */
package dav.mod.objects.blocks.tree;

import dav.mod.config.ConfigBuilder;
import dav.mod.util.BlockStatePredicates;
import dav.mod.util.EnumHandler;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public class ApplePlantBlock
extends Block
implements BonemealableBlock {
    private final EnumHandler.TreeType Type;
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.f_61409_;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)6.0, (double)13.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.m_49796_((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.m_49796_((double)4.0, (double)9.5, (double)4.0, (double)11.0, (double)16.0, (double)11.0), Block.m_49796_((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)};

    public ApplePlantBlock(BlockBehaviour.Properties Prop, EnumHandler.TreeType Type2) {
        super(Prop.m_60910_().m_60977_().m_60913_(0.4f, 0.0f).m_60918_(SoundType.f_56740_).m_60955_().m_60960_(BlockStatePredicates::never).m_60971_(BlockStatePredicates::never));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
        this.Type = Type2;
    }

    public InteractionResult m_6227_(BlockState State, Level World, BlockPos Pos, Player PlayerIn, InteractionHand Hand, BlockHitResult Hit) {
        if (((Boolean)ConfigBuilder.PLANTS.useEasyHarvest.get()).booleanValue() && this.isMaxAge(State) && !World.f_46443_) {
            World.m_46961_(Pos, true);
            if (World.f_46441_.nextInt(3) != 0) {
                World.m_46597_(Pos, this.getStateForAge(0));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6861_(BlockState State, Level WorldIn, BlockPos Pos, Block BlockIn, BlockPos FromPos, boolean isMoving) {
        if (!WorldIn.m_8055_(Pos.m_7494_()).m_204336_(BlockTags.f_13035_)) {
            WorldIn.m_46961_(Pos, true);
        }
    }

    public boolean m_7898_(BlockState State, LevelReader WorldIn, BlockPos Pos) {
        return WorldIn.m_8055_(Pos.m_7494_()).m_204336_(BlockTags.f_13035_) && WorldIn.m_45524_(Pos, 0) >= 9;
    }

    public boolean m_7420_(BlockState State, BlockGetter Reader, BlockPos Pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState State, BlockGetter Reader, BlockPos Pos, CollisionContext Context) {
        return SHAPE_BY_AGE[(Integer)State.m_61143_((Property)this.getAgeProperty())];
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected int getAge(BlockState State) {
        return (Integer)State.m_61143_((Property)this.getAgeProperty());
    }

    public BlockState getStateForAge(int Age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(Age));
    }

    public boolean isMaxAge(BlockState State) {
        return (Integer)State.m_61143_((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public boolean m_6724_(BlockState State) {
        return !this.isMaxAge(State);
    }

    public void m_7455_(BlockState State, ServerLevel World, BlockPos Pos, Random Rand) {
        if (!World.isAreaLoaded(Pos, 1)) {
            return;
        }
        if (World.m_8055_(Pos.m_7494_()).m_204336_(BlockTags.f_13035_)) {
            float Chance;
            int CurrentAge;
            if (World.m_45524_(Pos, 0) >= 9 && (CurrentAge = this.getAge(State)) < this.getMaxAge() && Rand.nextInt((int)(20.0f / (Chance = ApplePlantBlock.getGrowthSpeed(this, (BlockGetter)World, Pos))) + 1) == 0) {
                World.m_7731_(Pos, this.getStateForAge(CurrentAge + 1), 2);
            }
        } else {
            World.m_46961_(Pos, true);
        }
    }

    protected static float getGrowthSpeed(Block BlockIn, BlockGetter World, BlockPos Pos) {
        boolean flag1;
        float f = 1.0f;
        BlockState AirState = Blocks.f_50016_.m_49966_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState NeighborState = World.m_8055_(Pos.m_142082_(i, 0, j));
                if (NeighborState.m_60734_().m_49966_() == AirState) {
                    f1 = 2.0f;
                }
                if (i != 0 || j != 0) {
                    f1 /= 2.0f;
                }
                f += f1;
            }
        }
        BlockPos PosN = Pos.m_142127_();
        BlockPos PosS = Pos.m_142128_();
        BlockPos PosW = Pos.m_142125_();
        BlockPos PosE = Pos.m_142126_();
        boolean flag = !ApplePlantBlock.isValidNeighbor(World, PosN) || !ApplePlantBlock.isValidNeighbor(World, PosS);
        boolean bl = flag1 = !ApplePlantBlock.isValidNeighbor(World, PosE) || !ApplePlantBlock.isValidNeighbor(World, PosW);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = !ApplePlantBlock.isValidNeighbor(World, PosW.m_142127_()) || !ApplePlantBlock.isValidNeighbor(World, PosE.m_142127_()) || !ApplePlantBlock.isValidNeighbor(World, PosN.m_142128_()) || !ApplePlantBlock.isValidNeighbor(World, PosW.m_142128_());
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    private static boolean isValidNeighbor(BlockGetter World, BlockPos Pos) {
        BlockState State = World.m_8055_(Pos);
        return State.m_60795_() || State.m_204336_(BlockTags.f_13035_) || State.m_60734_() instanceof ApplePlantBlock;
    }

    protected int getBonemealAgeIncrease(Level World) {
        return Mth.m_14072_((Random)World.f_46441_, (int)2, (int)4);
    }

    public void growCrops(Level World, BlockPos Pos, BlockState State) {
        int j;
        int i = this.getAge(State) + this.getBonemealAgeIncrease(World);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        World.m_7731_(Pos, this.getStateForAge(i), 2);
    }

    public void m_7892_(BlockState State, Level World, BlockPos Pos, Entity EntityIn) {
        if (EntityIn instanceof Ravager && ForgeEventFactory.getMobGriefingEvent((Level)World, (Entity)EntityIn)) {
            World.m_46953_(Pos, true, EntityIn);
        }
    }

    protected ItemLike getBaseSeedId() {
        return this.Type.getDrop();
    }

    public ItemStack m_7397_(BlockGetter World, BlockPos Pos, BlockState State) {
        return new ItemStack(this.getBaseSeedId());
    }

    public boolean m_7370_(BlockGetter World, BlockPos Pos, BlockState State, boolean isClient) {
        return !this.isMaxAge(State) && this.m_5491_((Level)World, ((Level)World).f_46441_, Pos, State);
    }

    public boolean m_5491_(Level World, Random Rand, BlockPos Pos, BlockState State) {
        if (((Boolean)ConfigBuilder.PLANTS.allowBonemeal.get()).booleanValue()) {
            return this.Type.canGrow();
        }
        return false;
    }

    public void m_7719_(ServerLevel World, Random Rand, BlockPos Pos, BlockState State) {
        this.growCrops((Level)World, Pos, State);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> Builder2) {
        Builder2.m_61104_(new Property[]{AGE});
    }
}

