/*
 * Decompiled with CFR 0.152.
 */
package dav.mod.util.registry;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import dav.mod.AppleTreesRev;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;

public class CustomRegistry {
    public static void registerFlammableBlock(Block BlockIn, int Flammability, int FireSpread) {
        ((FireBlock)Blocks.f_50083_).m_53444_(Objects.requireNonNull(BlockIn), FireSpread, Flammability);
    }

    public static void registerCompostableItem(float Chance, ItemLike Compostable) {
        ComposterBlock.f_51914_.put((Object)Compostable.m_5456_(), Chance);
    }

    public static void registerStrippableEntry(Block Input, Block Output) {
        WoodStripRegistry.INSTANCE.add(Input, Output);
    }

    public static final class WoodStripRegistry {
        private static final WoodStripRegistry INSTANCE = new WoodStripRegistry();
        private static final Map<Block, Block> BACK_UP = new ImmutableMap.Builder().put((Object)Blocks.f_50011_, (Object)Blocks.f_50044_).put((Object)Blocks.f_49999_, (Object)Blocks.f_50010_).put((Object)Blocks.f_50043_, (Object)Blocks.f_50049_).put((Object)Blocks.f_50004_, (Object)Blocks.f_50009_).put((Object)Blocks.f_50015_, (Object)Blocks.f_50048_).put((Object)Blocks.f_50003_, (Object)Blocks.f_50008_).put((Object)Blocks.f_50013_, (Object)Blocks.f_50046_).put((Object)Blocks.f_50001_, (Object)Blocks.f_50006_).put((Object)Blocks.f_50014_, (Object)Blocks.f_50047_).put((Object)Blocks.f_50002_, (Object)Blocks.f_50007_).put((Object)Blocks.f_50012_, (Object)Blocks.f_50045_).put((Object)Blocks.f_50000_, (Object)Blocks.f_50005_).put((Object)Blocks.f_50686_, (Object)Blocks.f_50687_).put((Object)Blocks.f_50688_, (Object)Blocks.f_50689_).put((Object)Blocks.f_50695_, (Object)Blocks.f_50696_).put((Object)Blocks.f_50697_, (Object)Blocks.f_50698_).build();

        public void add(Block Input, Block Output) {
            WoodStripRegistry.checkNonNullAndAxisProperty(Input);
            WoodStripRegistry.checkNonNullAndAxisProperty(Output);
            Block Old = this.getStripMap().put(Input, Output);
            AppleTreesRev.LOGGER.info("WoodStripRegistry: Block ADDED " + Input);
            if (Old != null) {
                AppleTreesRev.LOGGER.info("WoodStripRegistry: Block REPLACED " + Old + " To: " + Input);
            }
        }

        private static void checkNonNullAndAxisProperty(Block BlockIn) {
            Objects.requireNonNull(BlockIn);
            if (!BlockIn.m_49965_().m_61092_().contains(BlockStateProperties.f_61365_)) {
                throw new IllegalArgumentException("Block: " + BlockIn.m_49954_().getString() + " doesn't  contain 'AXIS' property");
            }
        }

        private Map<Block, Block> getStripMap() {
            return this.checkMap();
        }

        private Map<Block, Block> checkMap() {
            HashMap StripMap = this.getMap();
            if (!(StripMap instanceof HashMap)) {
                StripMap = Maps.newHashMap(StripMap);
                WoodStripRegistry.setMap(StripMap);
            }
            return StripMap;
        }

        private Map<Block, Block> getMap() {
            try {
                return Objects.requireNonNull(AxeItem.f_150683_);
            }
            catch (NullPointerException e) {
                AppleTreesRev.LOGGER.error("WoodStripRegistry: Null Map, Using BACKUP");
                e.printStackTrace();
                return BACK_UP;
            }
        }

        private static void setMap(Map<Block, Block> Map2) {
            AxeItem.f_150683_ = Objects.requireNonNull(Map2);
        }
    }
}

