/*
 * Decompiled with CFR 0.152.
 */
package dav.mod.world.gen;

import com.google.common.collect.Maps;
import dav.mod.AppleTreesRev;
import dav.mod.config.ConfigBuilder;
import dav.mod.init.BiomeInit;
import dav.mod.world.gen.PlacedFeatures;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TreeWorldGen {
    private static final HashMap<ResourceLocation, Holder<PlacedFeature>> APPLE_FEATURES = Maps.newHashMap();
    private static final HashMap<ResourceLocation, Holder<PlacedFeature>> GOLDEN_FEATURES = Maps.newHashMap();
    private static final HashMap<ResourceLocation, Holder<PlacedFeature>> EMERALD_FEATURES = Maps.newHashMap();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void setupTreeGeneration(BiomeLoadingEvent Event) {
        BiomeGenerationSettingsBuilder Gen = Event.getGeneration();
        ResourceLocation Evt = Event.getName();
        if (Evt.equals((Object)BiomeInit.APPLE_FOREST.getId())) {
            return;
        }
        TreeWorldGen.registerIfAvailable((Boolean)ConfigBuilder.APPLE_GEN.AllowAppleTrees.get(), Gen, APPLE_FEATURES.get(Evt));
        TreeWorldGen.registerIfAvailable((Boolean)ConfigBuilder.GOLDEN_GEN.AllowGoldenTrees.get(), Gen, GOLDEN_FEATURES.get(Evt));
        TreeWorldGen.registerIfAvailable((Boolean)ConfigBuilder.EMERALD_GEN.AllowEmeraldTrees.get(), Gen, EMERALD_FEATURES.get(Evt));
    }

    private static void registerAndMakeFeatures() {
        TreeWorldGen.mergeLocationsValues((List)ConfigBuilder.APPLE_GEN.Locations.get(), (List)ConfigBuilder.APPLE_GEN.Chances.get()).forEach((Loc, Int) -> {
            String Name = "a_" + Loc.m_135815_();
            Holder<PlacedFeature> FeatureIn = TreeWorldGen.register(Name.concat("_placed"), TreeWorldGen.register(Name, Feature.f_65754_, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacedFeatures.NATURAL_FANCY_APPLE_PLACED, 0.02f)), PlacedFeatures.NATURAL_APPLE_PLACED)), new PlacementModifier[]{RarityFilter.m_191900_((int)Int), InSquarePlacement.m_191715_(), VegetationPlacements.f_195420_, PlacementUtils.f_195355_, BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190399_((BlockState)Blocks.f_50746_.m_49966_(), (Vec3i)BlockPos.f_121853_)), BiomeFilter.m_191561_()});
            APPLE_FEATURES.put((ResourceLocation)Loc, FeatureIn);
        });
        TreeWorldGen.mergeLocationsValues((List)ConfigBuilder.GOLDEN_GEN.Locations.get(), (List)ConfigBuilder.GOLDEN_GEN.Chances.get()).forEach((Loc, Int) -> {
            String Name = "g_" + Loc.m_135815_();
            Holder<PlacedFeature> FeatureIn = TreeWorldGen.register(Name.concat("_placed"), TreeWorldGen.register(Name, Feature.f_65754_, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacedFeatures.NATURAL_FANCY_GOLDEN_PLACED, 0.02f)), PlacedFeatures.NATURAL_GOLDEN_PLACED)), new PlacementModifier[]{RarityFilter.m_191900_((int)Int), InSquarePlacement.m_191715_(), VegetationPlacements.f_195420_, PlacementUtils.f_195355_, BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190399_((BlockState)Blocks.f_50746_.m_49966_(), (Vec3i)BlockPos.f_121853_)), BiomeFilter.m_191561_()});
            GOLDEN_FEATURES.put((ResourceLocation)Loc, FeatureIn);
        });
        TreeWorldGen.mergeLocationsValues((List)ConfigBuilder.EMERALD_GEN.Locations.get(), (List)ConfigBuilder.EMERALD_GEN.Chances.get()).forEach((Loc, Int) -> {
            String Name = "e_" + Loc.m_135815_();
            Holder<PlacedFeature> FeatureIn = TreeWorldGen.register(Name.concat("_placed"), TreeWorldGen.register(Name, Feature.f_65754_, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacedFeatures.NATURAL_FANCY_EMERALD_PLACED, 0.02f)), PlacedFeatures.NATURAL_EMERALD_PLACED)), new PlacementModifier[]{RarityFilter.m_191900_((int)Int), InSquarePlacement.m_191715_(), VegetationPlacements.f_195420_, PlacementUtils.f_195355_, BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190399_((BlockState)Blocks.f_50746_.m_49966_(), (Vec3i)BlockPos.f_121853_)), BiomeFilter.m_191561_()});
            EMERALD_FEATURES.put((ResourceLocation)Loc, FeatureIn);
        });
    }

    private static Object2IntMap<ResourceLocation> mergeLocationsValues(List<String> Locations, List<Integer> Chances) {
        Object2IntOpenHashMap Map2 = new Object2IntOpenHashMap();
        boolean Default = true;
        Map2.defaultReturnValue(1);
        for (int Index = 0; Index < Locations.size(); ++Index) {
            ResourceLocation Loc = new ResourceLocation(Locations.get(Index));
            if (Map2.containsKey((Object)Loc)) continue;
            if (Index < Chances.size()) {
                int Chance = 1;
                try {
                    Chance = Chances.get(Index);
                }
                catch (NumberFormatException e) {
                    AppleTreesRev.LOGGER.error("Something went wrong Parsing Value - Setting Default");
                    e.printStackTrace();
                }
                Map2.put((Object)Loc, Chance <= 0 ? 1 : (Chance <= 500 ? Chance : 1));
                continue;
            }
            Map2.put((Object)Loc, 1);
        }
        return Map2;
    }

    private static void registerIfAvailable(boolean Valid, BiomeGenerationSettingsBuilder Builder2, @Nullable Holder<PlacedFeature> Feature2) {
        if (Valid && Feature2 != null) {
            Builder2.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, Feature2);
        }
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>, T> Holder<T> register(String Name, F Feature2, FC Config) {
        return BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)AppleTreesRev.getPath(Name), (Object)new ConfiguredFeature(Feature2, Config));
    }

    private static Holder<PlacedFeature> register(String Name, Holder<? extends ConfiguredFeature<?, ?>> Feature2, PlacementModifier ... Modifiers) {
        return TreeWorldGen.register(Name, Feature2, List.of(Modifiers));
    }

    private static Holder<PlacedFeature> register(String Name, Holder<? extends ConfiguredFeature<?, ?>> Feature2, List<PlacementModifier> Modifiers) {
        return BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)AppleTreesRev.getPath(Name), (Object)new PlacedFeature(Holder.m_205706_(Feature2), List.copyOf(Modifiers)));
    }

    static {
        TreeWorldGen.registerAndMakeFeatures();
    }
}

