/*
 * Decompiled with CFR 0.152.
 */
package dav.mod.world.gen.decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dav.mod.init.BlockInit;
import dav.mod.init.TreeDecoratorInit;
import dav.mod.objects.blocks.tree.ApplePlantBlock;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class AppleDecorator
extends TreeDecorator {
    public static final Codec<AppleDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)2).fieldOf("plant").forGetter(AppleDecorator2 -> AppleDecorator2.Plant), (App)Codec.BOOL.fieldOf("isnatural").forGetter(AppleDecorator2 -> AppleDecorator2.isNatural), (App)Codec.BOOL.fieldOf("isfancy").forGetter(AppleDecorator2 -> AppleDecorator2.isFancy)).apply((Applicative)instance, AppleDecorator::new));
    private final int Plant;
    private final boolean isNatural;
    private final boolean isFancy;

    public AppleDecorator(int Plant, boolean isNatural, boolean isFancy) {
        this.Plant = Plant;
        this.isNatural = isNatural;
        this.isFancy = isFancy;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)TreeDecoratorInit.APPLE_DECORATOR.get();
    }

    public void m_142741_(LevelSimulatedReader WorldReader, BiConsumer<BlockPos, BlockState> AcceptedLocations, Random Rand, List<BlockPos> Logs, List<BlockPos> Leaves) {
        BlockState AppleType = this.getDropType();
        List Spots = Leaves.stream().filter(Pos -> !Leaves.contains(Pos.m_7495_()) && WorldReader.m_7433_(Pos.m_7495_(), State -> State.m_60713_(Blocks.f_50016_))).collect(Collectors.toList());
        if (!Spots.isEmpty()) {
            int j;
            int Cont = 0;
            int MinCount = this.isFancy ? 6 : 3;
            int MaxCount = this.isFancy ? 15 : 8;
            for (j = 0; j < MinCount && !Spots.isEmpty(); ++j) {
                int Index = Rand.nextInt(Spots.size());
                AcceptedLocations.accept(((BlockPos)Spots.get(Index)).m_7495_(), this.getNaturalAge(AppleType, Rand));
                Spots.remove(Index);
                ++Cont;
            }
            for (j = 0; j < Spots.size() && Cont < MaxCount; ++j) {
                if (Rand.nextInt(5) != 0) continue;
                AcceptedLocations.accept(((BlockPos)Spots.get(j)).m_7495_(), this.getNaturalAge(AppleType, Rand));
                ++Cont;
            }
        }
    }

    private BlockState getNaturalAge(BlockState State, Random Rand) {
        if (!this.isNatural) {
            return State;
        }
        return (BlockState)State.m_61124_((Property)ApplePlantBlock.AGE, (Comparable)Integer.valueOf(2 + Rand.nextInt(4)));
    }

    private BlockState getDropType() {
        if (this.Plant == 1) {
            return ((Block)BlockInit.GOLDEN_APPLE_PLANT.get()).m_49966_();
        }
        if (this.Plant == 2) {
            return ((Block)BlockInit.EMERALD_APPLE_PLANT.get()).m_49966_();
        }
        return ((Block)BlockInit.APPLE_PLANT.get()).m_49966_();
    }
}

