/*
 * Decompiled with CFR 0.152.
 */
package net.dav.appletreesrev.init;

import java.util.function.Supplier;
import net.dav.appletreesrev.init.ItemInit;
import net.dav.appletreesrev.objects.blocks.tree.ApplePlantBlock;
import net.dav.appletreesrev.util.EnumHandler;
import net.dav.appletreesrev.world.gen.grower.AppleTreeGrower;
import net.dav.appletreesrev.world.gen.grower.GoldTreeGrower;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockInit {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"appletreesrev");
    public static final RegistryObject<Block> APPLE_PLANT = BlockInit.registerBlock("apple_plant", () -> new ApplePlantBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_), EnumHandler.TreeType.APPLE), null);
    public static final RegistryObject<Block> GOLD_APPLE_PLANT = BlockInit.registerBlock("gold_apple_plant", () -> new ApplePlantBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_), EnumHandler.TreeType.GOLDEN), null);
    public static final RegistryObject<Block> APPLE_SAPLING = BlockInit.registerBlock("apple_sapling", () -> new SaplingBlock((AbstractTreeGrower)new AppleTreeGrower(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_)), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> GOLD_APPLE_SAPLING = BlockInit.registerBlock("gold_apple_sapling", () -> new SaplingBlock((AbstractTreeGrower)new GoldTreeGrower(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_)), CreativeModeTab.f_40750_);

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block, CreativeModeTab tab) {
        RegistryObject blockIn = BLOCKS.register(name, block);
        BlockInit.registerBlockItem(name, blockIn, tab);
        return blockIn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block, CreativeModeTab tab) {
        return ItemInit.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(tab)));
    }

    public static void register(IEventBus modEventBus) {
        BLOCKS.register(modEventBus);
    }
}

