/*
 * Decompiled with CFR 0.152.
 */
package net.dav.appletreesrev.objects.blocks.tree;

import net.dav.appletreesrev.config.ConfigBuilder;
import net.dav.appletreesrev.util.EnumHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public class ApplePlantBlock
extends Block
implements BonemealableBlock {
    private final EnumHandler.TreeType Type;
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.f_61409_;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)6.0, (double)13.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.m_49796_((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.m_49796_((double)4.0, (double)9.5, (double)4.0, (double)11.0, (double)16.0, (double)11.0), Block.m_49796_((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)};

    public ApplePlantBlock(BlockBehaviour.Properties Prop, EnumHandler.TreeType Type2) {
        super(Prop.m_60910_().m_60977_().m_60913_(0.4f, 0.0f).m_60918_(SoundType.f_56740_).m_60955_().m_60960_(ApplePlantBlock::never).m_60971_(ApplePlantBlock::never));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
        this.Type = Type2;
    }

    private static boolean never(BlockState State, BlockGetter World, BlockPos Pos) {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hitResult) {
        if (((Boolean)ConfigBuilder.PLANTS.useEasyHarvest.get()).booleanValue() && this.isMaxAge(state) && !level.f_46443_) {
            level.m_46961_(pos, true);
            if (level.f_46441_.m_188503_(3) != 0) {
                level.m_46597_(pos, this.getStateForAge(0));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos update, boolean p_60514_) {
        if (!level.m_8055_(pos.m_7494_()).m_204336_(BlockTags.f_13035_)) {
            level.m_46961_(pos, true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7494_()).m_204336_(BlockTags.f_13035_) && level.m_45524_(pos, 0) >= 9;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)this.getAgeProperty())];
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected int getAge(BlockState State) {
        return (Integer)State.m_61143_((Property)this.getAgeProperty());
    }

    public BlockState getStateForAge(int Age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(Age));
    }

    public boolean isMaxAge(BlockState State) {
        return (Integer)State.m_61143_((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public boolean m_6724_(BlockState state) {
        return !this.isMaxAge(state);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.m_8055_(pos.m_7494_()).m_204336_(BlockTags.f_13035_)) {
            float Chance;
            int CurrentAge;
            if (level.m_45524_(pos, 0) >= 9 && (CurrentAge = this.getAge(state)) < this.getMaxAge() && rand.m_188503_((int)(20.0f / (Chance = ApplePlantBlock.getGrowthSpeed((BlockGetter)level, pos))) + 1) == 0) {
                level.m_7731_(pos, this.getStateForAge(CurrentAge + 1), 2);
            }
        } else {
            level.m_46961_(pos, true);
        }
    }

    protected static float getGrowthSpeed(BlockGetter World, BlockPos Pos) {
        boolean flag1;
        float f = 1.0f;
        BlockState AirState = Blocks.f_50016_.m_49966_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState NeighborState = World.m_8055_(Pos.m_7918_(i, 0, j));
                if (NeighborState.m_60734_().m_49966_() == AirState) {
                    f1 = 2.0f;
                }
                if (i != 0 || j != 0) {
                    f1 /= 2.0f;
                }
                f += f1;
            }
        }
        BlockPos PosN = Pos.m_122012_();
        BlockPos PosS = Pos.m_122019_();
        BlockPos PosW = Pos.m_122024_();
        BlockPos PosE = Pos.m_122029_();
        boolean flag = !ApplePlantBlock.isValidNeighbor(World, PosN) || !ApplePlantBlock.isValidNeighbor(World, PosS);
        boolean bl = flag1 = !ApplePlantBlock.isValidNeighbor(World, PosE) || !ApplePlantBlock.isValidNeighbor(World, PosW);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = !ApplePlantBlock.isValidNeighbor(World, PosW.m_122012_()) || !ApplePlantBlock.isValidNeighbor(World, PosE.m_122012_()) || !ApplePlantBlock.isValidNeighbor(World, PosN.m_122019_()) || !ApplePlantBlock.isValidNeighbor(World, PosW.m_122019_());
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    private static boolean isValidNeighbor(BlockGetter World, BlockPos Pos) {
        BlockState State = World.m_8055_(Pos);
        return State.m_60795_() || State.m_204336_(BlockTags.f_13035_) || State.m_60734_() instanceof ApplePlantBlock;
    }

    protected int getBonemealAgeIncrease(Level World) {
        return Mth.m_216271_((RandomSource)World.f_46441_, (int)2, (int)4);
    }

    public void growCrops(Level World, BlockPos Pos, BlockState State) {
        int j;
        int i = this.getAge(State) + this.getBonemealAgeIncrease(World);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        World.m_7731_(Pos, this.getStateForAge(i), 2);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Ravager && ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity)) {
            level.m_46953_(pos, true, entity);
        }
    }

    protected ItemLike getBaseSeedId() {
        return this.Type.getDrop();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack(this.getBaseSeedId());
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean p_50900_) {
        return !this.isMaxAge(state) && this.m_214167_((Level)level, ((Level)level).f_46441_, pos, state);
    }

    public boolean m_214167_(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        if (((Boolean)ConfigBuilder.PLANTS.allowBonemeal.get()).booleanValue()) {
            return this.Type.canGrow();
        }
        return false;
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        this.growCrops((Level)level, pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockDef) {
        blockDef.m_61104_(new Property[]{AGE});
    }
}

