/*
 * Decompiled with CFR 0.152.
 */
package net.dav.appletreesrev.world.gen;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.OptionalInt;
import net.dav.appletreesrev.world.gen.ModPlacedFeatures;
import net.dav.appletreesrev.world.gen.decorator.AppleDecorator;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ModConfiguredFeatures {
    public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"appletreesrev");
    public static final RegistryObject<ConfiguredFeature<?, ?>> APPLE = CONFIGURED_FEATURES.register("apple", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)ModConfiguredFeatures.createApple().m_68249_((List)ImmutableList.of((Object)ModTreeDecorators.BEEHIVES, (Object)((Object)ModTreeDecorators.APPLE))).m_68251_()));
    public static final RegistryObject<ConfiguredFeature<?, ?>> FANCY_APPLE = CONFIGURED_FEATURES.register("fancy_apple", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)ModConfiguredFeatures.createFancyApple().m_68249_((List)ImmutableList.of((Object)ModTreeDecorators.BEEHIVES, (Object)((Object)ModTreeDecorators.FANCY_APPLE))).m_68251_()));
    public static final RegistryObject<ConfiguredFeature<?, ?>> GOLD = CONFIGURED_FEATURES.register("gold", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)ModConfiguredFeatures.createApple().m_68249_((List)ImmutableList.of((Object)ModTreeDecorators.BEEHIVES, (Object)((Object)ModTreeDecorators.GOLD))).m_68251_()));
    public static final RegistryObject<ConfiguredFeature<?, ?>> FANCY_GOLD = CONFIGURED_FEATURES.register("fancy_gold", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)ModConfiguredFeatures.createFancyApple().m_68249_((List)ImmutableList.of((Object)ModTreeDecorators.BEEHIVES, (Object)((Object)ModTreeDecorators.FANCY_GOLD))).m_68251_()));
    public static final RegistryObject<ConfiguredFeature<?, ?>> NAT_APPLE = CONFIGURED_FEATURES.register("nat_apple", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)ModConfiguredFeatures.createApple().m_68249_((List)ImmutableList.of((Object)ModTreeDecorators.BEEHIVES, (Object)((Object)ModTreeDecorators.NAT_APPLE))).m_68251_()));
    public static final RegistryObject<ConfiguredFeature<?, ?>> NAT_FANCY_APPLE = CONFIGURED_FEATURES.register("nat_fancy_apple", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)ModConfiguredFeatures.createFancyApple().m_68249_((List)ImmutableList.of((Object)ModTreeDecorators.BEEHIVES, (Object)((Object)ModTreeDecorators.NAT_FANCY_APPLE))).m_68251_()));
    public static final RegistryObject<ConfiguredFeature<?, ?>> NAT_GOLD = CONFIGURED_FEATURES.register("nat_gold", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)ModConfiguredFeatures.createApple().m_68249_((List)ImmutableList.of((Object)ModTreeDecorators.BEEHIVES, (Object)((Object)ModTreeDecorators.NAT_GOLD))).m_68251_()));
    public static final RegistryObject<ConfiguredFeature<?, ?>> NAT_FANCY_GOLD = CONFIGURED_FEATURES.register("nat_fancy_gold", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)ModConfiguredFeatures.createFancyApple().m_68249_((List)ImmutableList.of((Object)ModTreeDecorators.BEEHIVES, (Object)((Object)ModTreeDecorators.NAT_FANCY_GOLD))).m_68251_()));
    public static final RegistryObject<ConfiguredFeature<?, ?>> APPLE_PLAINS_FEATURE = CONFIGURED_FEATURES.register("apple_plains_trees", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)ModPlacedFeatures.NAT_FANCY_APPLE_CHECKED.getHolder().get(), 0.02f)), (Holder)ModPlacedFeatures.NAT_APPLE_CHECKED.getHolder().get())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> APPLE_FOREST_FEATURE = CONFIGURED_FEATURES.register("apple_forest_trees", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)ModPlacedFeatures.NAT_FANCY_APPLE_CHECKED.getHolder().get(), 0.04f)), (Holder)ModPlacedFeatures.NAT_APPLE_CHECKED.getHolder().get())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> APPLE_FLOWER_FEATURE = CONFIGURED_FEATURES.register("apple_flower_trees", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)ModPlacedFeatures.NAT_FANCY_APPLE_CHECKED.getHolder().get(), 0.06f)), (Holder)ModPlacedFeatures.NAT_APPLE_CHECKED.getHolder().get())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> GOLD_FLOWER_FEATURE = CONFIGURED_FEATURES.register("gold_flower_trees", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)ModPlacedFeatures.NAT_FANCY_GOLD_CHECKED.getHolder().get(), 0.03f)), (Holder)ModPlacedFeatures.NAT_GOLD_CHECKED.getHolder().get())));

    private static TreeConfiguration.TreeConfigurationBuilder createStraightBlobTree(Block Log, Block Leaves, int BaseHeight, int RandHeightA, int RandHeightB, int Foliage) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)Log), (TrunkPlacer)new StraightTrunkPlacer(BaseHeight, RandHeightA, RandHeightB), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Leaves), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)Foliage), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createApple() {
        return ModConfiguredFeatures.createStraightBlobTree(Blocks.f_49999_, Blocks.f_50050_, 5, 2, 0, 2).m_68244_();
    }

    private static TreeConfiguration.TreeConfigurationBuilder createFancyApple() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_49999_), (TrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50050_), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68244_();
    }

    public static void register(IEventBus modEventBus) {
        CONFIGURED_FEATURES.register(modEventBus);
    }

    private static class ModTreeDecorators {
        private static final BeehiveDecorator BEEHIVES = new BeehiveDecorator(0.02f);
        private static final AppleDecorator APPLE = new AppleDecorator(0, false, false);
        private static final AppleDecorator GOLD = new AppleDecorator(1, false, false);
        private static final AppleDecorator FANCY_APPLE = new AppleDecorator(0, false, true);
        private static final AppleDecorator FANCY_GOLD = new AppleDecorator(1, false, true);
        private static final AppleDecorator NAT_APPLE = new AppleDecorator(0, true, false);
        private static final AppleDecorator NAT_GOLD = new AppleDecorator(1, true, false);
        private static final AppleDecorator NAT_FANCY_APPLE = new AppleDecorator(0, true, true);
        private static final AppleDecorator NAT_FANCY_GOLD = new AppleDecorator(1, true, true);

        private ModTreeDecorators() {
        }
    }
}

