/*
 * Decompiled with CFR 0.152.
 */
package net.dav.appletreesrev.datagen.provider;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.dav.appletreesrev.AppleTreesRev;
import net.dav.appletreesrev.datagen.provider.BuildedModifier;
import net.dav.appletreesrev.datagen.provider.forge_modifiers.AddFeaturesBiomeModifier;
import net.dav.appletreesrev.world.ModPlacedFeatures;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import org.apache.commons.compress.utils.Lists;

public class ForgeBiomeModifiersProvider
implements DataProvider {
    protected final PackOutput.PathProvider biomeModifiersPathProvider;
    protected final Set<BuildedModifier> modifiers = Sets.newHashSet();
    protected final String modid;

    public ForgeBiomeModifiersProvider(PackOutput output, String modid) {
        this.biomeModifiersPathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "forge/biome_modifier");
        this.modid = modid;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        ArrayList futures = Lists.newArrayList();
        this.generate();
        this.modifiers.forEach(modifier -> futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)modifier.serializeBiomeModifier(), (Path)this.biomeModifiersPathProvider.m_245731_(modifier.getId()))));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public void generate() {
        this.modifiers.add(AddFeaturesBiomeModifier.create().biome((ResourceKey<Biome>)Biomes.f_48179_).feature(ModPlacedFeatures.APPLE_FLOWER_PLACED).feature(ModPlacedFeatures.GOLD_FLOWER_PLACED).step(GenerationStep.Decoration.VEGETAL_DECORATION).build(AppleTreesRev.getLocation("apple_flower")));
        this.modifiers.add(AddFeaturesBiomeModifier.create().biome((ResourceKey<Biome>)Biomes.f_48205_).biome((ResourceKey<Biome>)Biomes.f_48151_).feature(ModPlacedFeatures.APPLE_FOREST_PLACED).step(GenerationStep.Decoration.VEGETAL_DECORATION).build(AppleTreesRev.getLocation("apple_forest")));
        this.modifiers.add(AddFeaturesBiomeModifier.create().biome((ResourceKey<Biome>)Biomes.f_48202_).biome((ResourceKey<Biome>)Biomes.f_48176_).feature(ModPlacedFeatures.APPLE_PLAINS_PLACED).step(GenerationStep.Decoration.VEGETAL_DECORATION).build(AppleTreesRev.getLocation("apple_plains")));
    }

    public String m_6055_() {
        return "Biome Modifiers: " + this.modid;
    }
}

