/*
 * Decompiled with CFR 0.152.
 */
package net.dav.appletreesrev.datagen.provider.forge_modifiers;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Set;
import net.dav.appletreesrev.datagen.provider.BuildedModifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddFeaturesBiomeModifier
implements BuildedModifier {
    private final Set<ResourceLocation> modifiedBiomes;
    private final Set<ResourceLocation> addedFeatures;
    @Nullable
    private final TagKey<Biome> biomesTag;
    @Nullable
    private final TagKey<PlacedFeature> featuresTag;
    private final GenerationStep.Decoration generationStep;
    private final ResourceLocation modifierId;

    private AddFeaturesBiomeModifier(Collection<ResourceLocation> biomesToModify, Collection<ResourceLocation> featuresToBeAdded, @Nullable TagKey<Biome> biomeTag, @Nullable TagKey<PlacedFeature> featureTag, GenerationStep.Decoration genStep, ResourceLocation id) {
        this.modifiedBiomes = ImmutableSet.copyOf(biomesToModify);
        this.addedFeatures = ImmutableSet.copyOf(featuresToBeAdded);
        this.biomesTag = biomeTag;
        this.featuresTag = featureTag;
        this.generationStep = genStep;
        this.modifierId = id;
    }

    @Override
    public void serializeModifierData(JsonObject json) {
        if (this.biomesTag != null) {
            json.addProperty("biomes", this.biomesTag.f_203868_().toString());
        } else {
            JsonArray biomesArray = new JsonArray();
            this.modifiedBiomes.forEach(location -> biomesArray.add(location.toString()));
            json.add("biomes", (JsonElement)biomesArray);
        }
        if (this.featuresTag != null) {
            json.addProperty("features", this.featuresTag.f_203868_().toString());
        } else {
            JsonArray featuresArray = new JsonArray();
            this.getFeatures().forEach(location -> featuresArray.add(location.toString()));
            json.add("features", (JsonElement)featuresArray);
        }
        json.addProperty("step", this.generationStep.m_224194_());
    }

    @Override
    public ResourceLocation getId() {
        return this.modifierId;
    }

    @Override
    public ResourceLocation getType() {
        return ForgeMod.ADD_FEATURES_BIOME_MODIFIER_TYPE.getId();
    }

    @Override
    public Set<ResourceLocation> getFeatures() {
        return this.addedFeatures;
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private final Set<ResourceLocation> biomesToModify = Sets.newHashSet();
        private final Set<ResourceLocation> featuresToAdd = Sets.newHashSet();
        @Nullable
        private TagKey<Biome> biomesTag;
        @Nullable
        private TagKey<PlacedFeature> featuresTag;
        private GenerationStep.Decoration genStep;

        public Builder biome(ResourceKey<Biome> biome) {
            this.biomesToModify.add(biome.m_135782_());
            return this;
        }

        public Builder biome(TagKey<Biome> biomeTag) {
            this.biomesTag = biomeTag;
            return this;
        }

        public Builder feature(ResourceKey<PlacedFeature> feature) {
            this.featuresToAdd.add(feature.m_135782_());
            return this;
        }

        public Builder feature(TagKey<PlacedFeature> featureTag) {
            this.featuresTag = featureTag;
            return this;
        }

        public Builder step(GenerationStep.Decoration step) {
            this.genStep = step;
            return this;
        }

        public AddFeaturesBiomeModifier build(@NotNull ResourceLocation modifierId) {
            if (this.biomesToModify.isEmpty() && this.biomesTag == null) {
                throw new IllegalArgumentException("There is no biome to modify");
            }
            if (this.featuresToAdd.isEmpty() && this.featuresTag == null) {
                throw new IllegalArgumentException("There is no features to be added");
            }
            if (this.genStep == null) {
                throw new IllegalArgumentException("Must be a decoration step to apply modifications");
            }
            return new AddFeaturesBiomeModifier(this.biomesToModify, this.featuresToAdd, this.biomesTag, this.featuresTag, this.genStep, modifierId);
        }
    }
}

