/*
 * Decompiled with CFR 0.152.
 */
package net.dav.appletreesrev.init;

import java.util.function.Supplier;
import net.dav.appletreesrev.init.ItemInit;
import net.dav.appletreesrev.objects.blocks.tree.ApplePlantBlock;
import net.dav.appletreesrev.util.EnumHandler;
import net.dav.appletreesrev.world.gen.grower.AppleTreeGrower;
import net.dav.appletreesrev.world.gen.grower.GoldTreeGrower;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockInit {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"appletreesrev");
    public static final RegistryObject<Block> APPLE_PLANT = BlockInit.registerBlock("apple_plant", () -> new ApplePlantBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_), EnumHandler.TreeType.APPLE));
    public static final RegistryObject<Block> GOLD_APPLE_PLANT = BlockInit.registerBlock("gold_apple_plant", () -> new ApplePlantBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_), EnumHandler.TreeType.GOLDEN), new Item.Properties().m_41497_(Rarity.EPIC));
    public static final RegistryObject<Block> APPLE_SAPLING = BlockInit.registerBlock("apple_sapling", () -> new SaplingBlock((AbstractTreeGrower)new AppleTreeGrower(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_)));
    public static final RegistryObject<Block> GOLD_APPLE_SAPLING = BlockInit.registerBlock("gold_apple_sapling", () -> new SaplingBlock((AbstractTreeGrower)new GoldTreeGrower(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_)), new Item.Properties().m_41497_(Rarity.RARE));

    private static <T extends Block> RegistryObject<T> registerBlock(String Name, Supplier<T> Block2) {
        RegistryObject BlockRegister = BLOCKS.register(Name, Block2);
        BlockInit.registerBlockItem(Name, BlockRegister, new Item.Properties());
        return BlockRegister;
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String Name, Supplier<T> Block2, Item.Properties properties) {
        RegistryObject BlockRegister = BLOCKS.register(Name, Block2);
        BlockInit.registerBlockItem(Name, BlockRegister, properties);
        return BlockRegister;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String Name, RegistryObject<T> Block2, Item.Properties properties) {
        return ItemInit.ITEMS.register(Name, () -> new BlockItem((Block)Block2.get(), properties));
    }

    public static void register(IEventBus ModEventBus) {
        BLOCKS.register(ModEventBus);
    }
}

