/*
 * Decompiled with CFR 0.152.
 */
package net.dav.appletreesrev.world;

import java.util.List;
import net.dav.appletreesrev.AppleTreesRev;
import net.dav.appletreesrev.init.BlockInit;
import net.dav.appletreesrev.world.ModConfiguredFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> NAT_APPLE_PLACED = ModPlacedFeatures.createKey("nat_apple_placed");
    public static final ResourceKey<PlacedFeature> NAT_FANCY_APPLE_PLACED = ModPlacedFeatures.createKey("nat_fancy_apple_placed");
    public static final ResourceKey<PlacedFeature> NAT_GOLD_PLACED = ModPlacedFeatures.createKey("nat_gold_placed");
    public static final ResourceKey<PlacedFeature> NAT_FANCY_GOLD_PLACED = ModPlacedFeatures.createKey("nat_fancy_gold_placed");
    public static final ResourceKey<PlacedFeature> APPLE_PLAINS_PLACED = ModPlacedFeatures.createKey("apple_plains_placed");
    public static final ResourceKey<PlacedFeature> APPLE_FOREST_PLACED = ModPlacedFeatures.createKey("apple_forest_placed");
    public static final ResourceKey<PlacedFeature> APPLE_FLOWER_PLACED = ModPlacedFeatures.createKey("apple_flower_placed");
    public static final ResourceKey<PlacedFeature> GOLD_FLOWER_PLACED = ModPlacedFeatures.createKey("gold_flower_placed");

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.m_255420_(Registries.f_256911_);
        ModPlacedFeatures.register(context, NAT_APPLE_PLACED, configuredFeatures.m_255043_(ModConfiguredFeatures.NAT_APPLE_FEATURE), new PlacementModifier[]{PlacementUtils.m_206493_((Block)((Block)BlockInit.APPLE_SAPLING.get()))});
        ModPlacedFeatures.register(context, NAT_FANCY_APPLE_PLACED, configuredFeatures.m_255043_(ModConfiguredFeatures.NAT_FANCY_APPLE_FEATURE), new PlacementModifier[]{PlacementUtils.m_206493_((Block)((Block)BlockInit.APPLE_SAPLING.get()))});
        ModPlacedFeatures.register(context, NAT_GOLD_PLACED, configuredFeatures.m_255043_(ModConfiguredFeatures.NAT_GOLDEN_FEATURE), new PlacementModifier[]{PlacementUtils.m_206493_((Block)((Block)BlockInit.GOLD_APPLE_SAPLING.get()))});
        ModPlacedFeatures.register(context, NAT_FANCY_GOLD_PLACED, configuredFeatures.m_255043_(ModConfiguredFeatures.NAT_FANCY_GOLDEN_FEATURE), new PlacementModifier[]{PlacementUtils.m_206493_((Block)((Block)BlockInit.GOLD_APPLE_SAPLING.get()))});
        ModPlacedFeatures.register(context, APPLE_PLAINS_PLACED, configuredFeatures.m_255043_(ModConfiguredFeatures.APPLE_PLAINS_FEATURE), VegetationPlacements.m_195479_((PlacementModifier)RarityFilter.m_191900_((int)12)));
        ModPlacedFeatures.register(context, APPLE_FOREST_PLACED, configuredFeatures.m_255043_(ModConfiguredFeatures.APPLE_FOREST_FEATURE), VegetationPlacements.m_195479_((PlacementModifier)RarityFilter.m_191900_((int)6)));
        ModPlacedFeatures.register(context, APPLE_FLOWER_PLACED, configuredFeatures.m_255043_(ModConfiguredFeatures.APPLE_FLOWER_FEATURE), VegetationPlacements.m_195479_((PlacementModifier)RarityFilter.m_191900_((int)2)));
        ModPlacedFeatures.register(context, GOLD_FLOWER_PLACED, configuredFeatures.m_255043_(ModConfiguredFeatures.GOLD_FLOWER_FEATURE), VegetationPlacements.m_195479_((PlacementModifier)RarityFilter.m_191900_((int)25)));
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)AppleTreesRev.getLocation(name));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> modifiers) {
        context.m_255272_(key, (Object)new PlacedFeature(feature, List.copyOf(modifiers)));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> feature, PlacementModifier ... modifiers) {
        ModPlacedFeatures.register(context, key, feature, List.of(modifiers));
    }
}

