/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.crafting;

import appeng.block.AEBaseTileBlock;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.CraftingCPUContainer;
import appeng.tile.crafting.CraftingTileEntity;
import appeng.util.InteractionUtil;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class AbstractCraftingUnitBlock<T extends CraftingTileEntity>
extends AEBaseTileBlock<T> {
    public static final BooleanProperty FORMED = BooleanProperty.func_177716_a((String)"formed");
    public static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");
    public final CraftingUnitType type;

    public AbstractCraftingUnitBlock(AbstractBlock.Properties props, CraftingUnitType type) {
        super(props);
        this.type = type;
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FORMED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{POWERED});
        builder.func_206894_a(new Property[]{FORMED});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        TileEntity te = worldIn.func_175625_s(currentPos);
        if (te != null) {
            te.requestModelDataUpdate();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        CraftingTileEntity cp = (CraftingTileEntity)this.getTileEntity((IBlockReader)worldIn, pos);
        if (cp != null) {
            cp.updateMultiBlock(fromPos);
        }
    }

    @Override
    public void func_196243_a(BlockState state, World w, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() == state.func_177230_c()) {
            return;
        }
        CraftingTileEntity cp = (CraftingTileEntity)this.getTileEntity((IBlockReader)w, pos);
        if (cp != null) {
            cp.breakCluster();
        }
        super.func_196243_a(state, w, pos, newState, isMoving);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World w, BlockPos pos, PlayerEntity p, Hand hand, BlockRayTraceResult hit) {
        CraftingTileEntity tg = (CraftingTileEntity)this.getTileEntity((IBlockReader)w, pos);
        if (tg != null && !InteractionUtil.isInAlternateUseMode(p) && tg.isFormed() && tg.isActive()) {
            if (!w.func_201670_d()) {
                ContainerOpener.openContainer(CraftingCPUContainer.TYPE, p, ContainerLocator.forTileEntitySide(tg, hit.func_216354_b()));
            }
            return ActionResultType.func_233537_a_((boolean)w.func_201670_d());
        }
        return super.func_225533_a_(state, w, pos, p, hand, hit);
    }

    public static enum CraftingUnitType {
        UNIT,
        ACCELERATOR,
        STORAGE_1K,
        STORAGE_4K,
        STORAGE_16K,
        STORAGE_64K,
        MONITOR;

    }
}

