/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.block.AEBaseTileBlock;
import appeng.block.storage.DriveSlotState;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.ChestContainer;
import appeng.core.localization.PlayerMessages;
import appeng.tile.storage.ChestTileEntity;
import appeng.util.InteractionUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ChestBlock
extends AEBaseTileBlock<ChestTileEntity> {
    private static final BooleanProperty LIGHTS_ON = BooleanProperty.func_177716_a((String)"lights_on");

    public ChestBlock() {
        super(ChestBlock.defaultProps(Material.field_151573_f));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)LIGHTS_ON, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{LIGHTS_ON});
    }

    @Override
    protected BlockState updateBlockStateFromTileEntity(BlockState currentState, ChestTileEntity te) {
        DriveSlotState slotState = DriveSlotState.EMPTY;
        if (te.getCellCount() >= 1) {
            slotState = DriveSlotState.fromCellStatus(te.getCellStatus(0));
        }
        if (!te.isPowered() && slotState != DriveSlotState.EMPTY) {
            slotState = DriveSlotState.OFFLINE;
        }
        return (BlockState)currentState.func_206870_a((Property)LIGHTS_ON, (Comparable)Boolean.valueOf(slotState != DriveSlotState.EMPTY && slotState != DriveSlotState.OFFLINE));
    }

    @Override
    public ActionResultType onActivated(World w, BlockPos pos, PlayerEntity p, Hand hand, @Nullable ItemStack heldItem, BlockRayTraceResult hit) {
        ChestTileEntity tg = (ChestTileEntity)this.getTileEntity((IBlockReader)w, pos);
        if (tg != null && !InteractionUtil.isInAlternateUseMode(p)) {
            if (!w.func_201670_d()) {
                if (hit.func_216354_b() == tg.getUp()) {
                    if (!tg.openGui(p)) {
                        p.func_145747_a(PlayerMessages.ChestCannotReadStorageCell.get(), Util.field_240973_b_);
                    }
                } else {
                    ContainerOpener.openContainer(ChestContainer.TYPE, p, ContainerLocator.forTileEntitySide(tg, hit.func_216354_b()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)w.func_201670_d());
        }
        return ActionResultType.PASS;
    }
}

