/*
 * Decompiled with CFR 0.152.
 */
package appeng.client;

import appeng.api.parts.CableRenderMode;
import appeng.block.AEBaseBlock;
import appeng.client.ActionKey;
import appeng.client.EffectType;
import appeng.client.render.effects.EnergyParticleData;
import appeng.client.render.effects.LightningArcFX;
import appeng.client.render.effects.ParticleTypes;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.helpers.IMouseWheelItem;
import appeng.server.ServerHelper;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ClientHelper
extends ServerHelper {
    private static final String KEY_CATEGORY = "key.appliedenergistics2.category";
    private final EnumMap<ActionKey, KeyBinding> bindings = new EnumMap(ActionKey.class);

    public void clientInit() {
        MinecraftForge.EVENT_BUS.addListener(this::postPlayerRender);
        MinecraftForge.EVENT_BUS.addListener(this::wheelEvent);
        for (ActionKey key : ActionKey.values()) {
            KeyBinding binding = new KeyBinding(key.getTranslationKey(), key.getDefaultKey(), KEY_CATEGORY);
            ClientRegistry.registerKeyBinding((KeyBinding)binding);
            this.bindings.put(key, binding);
        }
    }

    @Override
    public World getWorld() {
        if (Platform.isClient()) {
            return Minecraft.func_71410_x().field_71441_e;
        }
        return super.getWorld();
    }

    @Override
    public void bindTileEntitySpecialRenderer(Class<? extends TileEntity> tile, AEBaseBlock blk) {
    }

    @Override
    public List<? extends PlayerEntity> getPlayers() {
        if (Platform.isClient()) {
            return Collections.singletonList(Minecraft.func_71410_x().field_71439_g);
        }
        return super.getPlayers();
    }

    @Override
    public void spawnEffect(EffectType effect, World world, double posX, double posY, double posZ, Object o) {
        if (AEConfig.instance().isEnableEffects()) {
            switch (effect) {
                case Vibrant: {
                    this.spawnVibrant(world, posX, posY, posZ);
                    return;
                }
                case Energy: {
                    this.spawnEnergy(world, posX, posY, posZ);
                    return;
                }
                case Lightning: {
                    this.spawnLightning(world, posX, posY, posZ);
                    return;
                }
                case LightningArc: {
                    this.spawnLightningArc(world, posX, posY, posZ, (Vector3d)o);
                    return;
                }
            }
        }
    }

    @Override
    public boolean shouldAddParticles(Random r) {
        switch (Minecraft.func_71410_x().field_71474_y.field_74362_aa) {
            default: {
                return true;
            }
            case DECREASED: {
                return r.nextBoolean();
            }
            case MINIMAL: 
        }
        return false;
    }

    @Override
    public RayTraceResult getRTR() {
        return Minecraft.func_71410_x().field_71476_x;
    }

    @Override
    public void postInit() {
    }

    @Override
    public CableRenderMode getCableRenderMode() {
        if (Platform.isServer()) {
            return super.getCableRenderMode();
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        return this.getCableRenderModeForPlayer((PlayerEntity)player);
    }

    @Override
    public void triggerUpdates() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || mc.field_71441_e == null) {
            return;
        }
        ClientPlayerEntity player = mc.field_71439_g;
        int x = (int)player.func_226277_ct_();
        int y = (int)player.func_226278_cu_();
        int z = (int)player.func_226281_cx_();
        int range = 256;
        mc.field_71438_f.func_147585_a(x - 256, y - 256, z - 256, x + 256, y + 256, z + 256);
    }

    private void postPlayerRender(RenderLivingEvent.Pre p) {
    }

    private void spawnVibrant(World w, double x, double y, double z) {
        if (AppEng.proxy.shouldAddParticles(Platform.getRandom())) {
            double d0 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            double d1 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            double d2 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)ParticleTypes.VIBRANT, x + d0, y + d1, z + d2, 0.0, 0.0, 0.0);
        }
    }

    private void spawnEnergy(World w, double posX, double posY, double posZ) {
        float x = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float y = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float z = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)EnergyParticleData.FOR_BLOCK, posX + (double)x, posY + (double)y, posZ + (double)z, (double)(-x) * 0.1, (double)(-y) * 0.1, (double)(-z) * 0.1);
    }

    private void spawnLightning(World world, double posX, double posY, double posZ) {
        Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)ParticleTypes.LIGHTNING, posX, posY + (double)0.3f, posZ, 0.0, 0.0, 0.0);
    }

    private void spawnLightningArc(World world, double posX, double posY, double posZ, Vector3d second) {
        LightningArcFX fx = new LightningArcFX((ClientWorld)world, posX, posY, posZ, second.field_72450_a, second.field_72448_b, second.field_72449_c, 0.0, 0.0, 0.0);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
    }

    private void wheelEvent(InputEvent.MouseScrollEvent me) {
        if (me.getScrollDelta() == 0.0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (InteractionUtil.isInAlternateUseMode((PlayerEntity)player)) {
            boolean mainHand = player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof IMouseWheelItem;
            boolean offHand = player.func_184586_b(Hand.OFF_HAND).func_77973_b() instanceof IMouseWheelItem;
            if (mainHand || offHand) {
                NetworkHandler.instance().sendToServer(new ConfigValuePacket("Item", me.getScrollDelta() > 0.0 ? "WheelUp" : "WheelDown"));
                me.setCanceled(true);
            }
        }
    }

    @Override
    public boolean isActionKey(ActionKey key, InputMappings.Input pressedKey) {
        return this.bindings.get((Object)key).isActiveAndMatches(pressedKey);
    }
}

